/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.JVMPoolReference;
import com.ibm.cics.core.model.JVMPoolType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IJVMPool;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableJVMPool;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableJVMPool
extends MutableCICSResource
implements IMutableJVMPool {
    private IJVMPool delegate;
    private MutableSMRecord record;

    public MutableJVMPool(ICPSM cpsm, IContext context, IJVMPool cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("JVMPOOL");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public Long getPhasingOut() {
        return this.delegate.getPhasingOut();
    }

    public ICICSEnums.EnablementValue getStatus() {
        String result = this.record.get("STATUS");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (ICICSEnums.EnablementValue)((CICSAttribute)JVMPoolType.STATUS).get(result, this.record.getNormalizers());
    }

    public Long getTotal() {
        return this.delegate.getTotal();
    }

    public Long getCurrent() {
        return this.delegate.getCurrent();
    }

    public Long getSjgpeakjvms() {
        return this.delegate.getSjgpeakjvms();
    }

    public Long getSjgreqstotal() {
        return this.delegate.getSjgreqstotal();
    }

    public Long getSjgreqsreuse() {
        return this.delegate.getSjgreqsreuse();
    }

    public Long getSjgreqsinit() {
        return this.delegate.getSjgreqsinit();
    }

    public Long getSjgreqsmisma() {
        return this.delegate.getSjgreqsmisma();
    }

    public Long getSjgreqstermi() {
        return this.delegate.getSjgreqstermi();
    }

    public String getJvmlvl0trace() {
        String result = this.record.get("JVMLVL0TRACE");
        if (result == null) {
            return this.delegate.getJvmlvl0trace();
        }
        return (String)((CICSAttribute)JVMPoolType.JVMLVL_0_TRACE).get(result, this.record.getNormalizers());
    }

    public String getJvmlvl1trace() {
        String result = this.record.get("JVMLVL1TRACE");
        if (result == null) {
            return this.delegate.getJvmlvl1trace();
        }
        return (String)((CICSAttribute)JVMPoolType.JVMLVL_1_TRACE).get(result, this.record.getNormalizers());
    }

    public String getJvmlvl2trace() {
        String result = this.record.get("JVMLVL2TRACE");
        if (result == null) {
            return this.delegate.getJvmlvl2trace();
        }
        return (String)((CICSAttribute)JVMPoolType.JVMLVL_2_TRACE).get(result, this.record.getNormalizers());
    }

    public String getJvmusertrace() {
        String result = this.record.get("JVMUSERTRACE");
        if (result == null) {
            return this.delegate.getJvmusertrace();
        }
        return (String)((CICSAttribute)JVMPoolType.JVMUSERTRACE).get(result, this.record.getNormalizers());
    }

    public Long getSjgcurrcache() {
        return this.delegate.getSjgcurrcache();
    }

    public Long getSjgpeakcache() {
        return this.delegate.getSjgpeakcache();
    }

    public Long getSjgreqscache() {
        return this.delegate.getSjgreqscache();
    }

    public Long getSjgreqsreset() {
        return this.delegate.getSjgreqsreset();
    }

    public String getProfiledir() {
        return this.delegate.getProfiledir();
    }

    public void setStatus(ICICSEnums.EnablementValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("STATUS", null);
        } else {
            JVMPoolType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMPoolType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("STATUS", connectionSpecificExternalValue);
        }
    }

    public void setJvmlvl0trace(String _jvmlvl0trace) {
        if (_jvmlvl0trace.equals(this.delegate.getJvmlvl0trace())) {
            this.record.set("JVMLVL0TRACE", null);
        } else {
            JVMPoolType.JVMLVL_0_TRACE.validate((Object)_jvmlvl0trace);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMPoolType.JVMLVL_0_TRACE).set(_jvmlvl0trace, this.record.getNormalizers());
            this.record.set("JVMLVL0TRACE", connectionSpecificExternalValue);
        }
    }

    public void setJvmlvl1trace(String _jvmlvl1trace) {
        if (_jvmlvl1trace.equals(this.delegate.getJvmlvl1trace())) {
            this.record.set("JVMLVL1TRACE", null);
        } else {
            JVMPoolType.JVMLVL_1_TRACE.validate((Object)_jvmlvl1trace);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMPoolType.JVMLVL_1_TRACE).set(_jvmlvl1trace, this.record.getNormalizers());
            this.record.set("JVMLVL1TRACE", connectionSpecificExternalValue);
        }
    }

    public void setJvmlvl2trace(String _jvmlvl2trace) {
        if (_jvmlvl2trace.equals(this.delegate.getJvmlvl2trace())) {
            this.record.set("JVMLVL2TRACE", null);
        } else {
            JVMPoolType.JVMLVL_2_TRACE.validate((Object)_jvmlvl2trace);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMPoolType.JVMLVL_2_TRACE).set(_jvmlvl2trace, this.record.getNormalizers());
            this.record.set("JVMLVL2TRACE", connectionSpecificExternalValue);
        }
    }

    public void setJvmusertrace(String _jvmusertrace) {
        if (_jvmusertrace.equals(this.delegate.getJvmusertrace())) {
            this.record.set("JVMUSERTRACE", null);
        } else {
            JVMPoolType.JVMUSERTRACE.validate((Object)_jvmusertrace);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMPoolType.JVMUSERTRACE).set(_jvmusertrace, this.record.getNormalizers());
            this.record.set("JVMUSERTRACE", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == JVMPoolType.PHASING_OUT) {
            return (V)this.getPhasingOut();
        }
        if (attribute == JVMPoolType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == JVMPoolType.TOTAL) {
            return (V)this.getTotal();
        }
        if (attribute == JVMPoolType.CURRENT) {
            return (V)this.getCurrent();
        }
        if (attribute == JVMPoolType.SJGPEAKJVMS) {
            return (V)this.getSjgpeakjvms();
        }
        if (attribute == JVMPoolType.SJGREQSTOTAL) {
            return (V)this.getSjgreqstotal();
        }
        if (attribute == JVMPoolType.SJGREQSREUSE) {
            return (V)this.getSjgreqsreuse();
        }
        if (attribute == JVMPoolType.SJGREQSINIT) {
            return (V)this.getSjgreqsinit();
        }
        if (attribute == JVMPoolType.SJGREQSMISMA) {
            return (V)this.getSjgreqsmisma();
        }
        if (attribute == JVMPoolType.SJGREQSTERMI) {
            return (V)this.getSjgreqstermi();
        }
        if (attribute == JVMPoolType.JVMLVL_0_TRACE) {
            return (V)this.getJvmlvl0trace();
        }
        if (attribute == JVMPoolType.JVMLVL_1_TRACE) {
            return (V)this.getJvmlvl1trace();
        }
        if (attribute == JVMPoolType.JVMLVL_2_TRACE) {
            return (V)this.getJvmlvl2trace();
        }
        if (attribute == JVMPoolType.JVMUSERTRACE) {
            return (V)this.getJvmusertrace();
        }
        if (attribute == JVMPoolType.SJGCURRCACHE) {
            return (V)this.getSjgcurrcache();
        }
        if (attribute == JVMPoolType.SJGPEAKCACHE) {
            return (V)this.getSjgpeakcache();
        }
        if (attribute == JVMPoolType.SJGREQSCACHE) {
            return (V)this.getSjgreqscache();
        }
        if (attribute == JVMPoolType.SJGREQSRESET) {
            return (V)this.getSjgreqsreset();
        }
        if (attribute == JVMPoolType.PROFILEDIR) {
            return (V)this.getProfiledir();
        }
        return super.getAttributeValue(attribute);
    }

    public JVMPoolType getObjectType() {
        return JVMPoolType.getInstance();
    }

    @Override
    public JVMPoolReference getCICSObjectReference() {
        return new JVMPoolReference(this.getCICSContainer());
    }
}

