/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.RemoteTransactionReference;
import com.ibm.cics.core.model.RemoteTransactionType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IRemoteTransaction;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableRemoteTransaction;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableRemoteTransaction
extends MutableCICSResource
implements IMutableRemoteTransaction {
    private IRemoteTransaction delegate;
    private MutableSMRecord record;

    public MutableRemoteTransaction(ICPSM cpsm, IContext context, IRemoteTransaction cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("REMTRAN");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getRemoteName() {
        return this.delegate.getRemoteName();
    }

    public String getRemoteSystem() {
        return this.delegate.getRemoteSystem();
    }

    public String getProfile() {
        return this.delegate.getProfile();
    }

    public String getTransactionRoutingProfile() {
        return this.delegate.getTransactionRoutingProfile();
    }

    public IRemoteTransaction.RoutingValue getRouting() {
        return this.delegate.getRouting();
    }

    public Long getRemoteUseCount() {
        return this.delegate.getRemoteUseCount();
    }

    public Long getUseCount() {
        return this.delegate.getUseCount();
    }

    public Long getPriority() {
        String result = this.record.get("PRIORITY");
        if (result == null) {
            return this.delegate.getPriority();
        }
        return (Long)((CICSAttribute)RemoteTransactionType.PRIORITY).get(result, this.record.getNormalizers());
    }

    public IRemoteTransaction.PurgeabilityValue getPurgeability() {
        String result = this.record.get("PURGEABILITY");
        if (result == null) {
            return this.delegate.getPurgeability();
        }
        return (IRemoteTransaction.PurgeabilityValue)((CICSAttribute)RemoteTransactionType.PURGEABILITY).get(result, this.record.getNormalizers());
    }

    public Long getReadTimeout() {
        return this.delegate.getReadTimeout();
    }

    public IRemoteTransaction.ScreenSizeValue getScreenSize() {
        return this.delegate.getScreenSize();
    }

    public ICICSEnums.EnablementValue getStatus() {
        String result = this.record.get("STATUS");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (ICICSEnums.EnablementValue)((CICSAttribute)RemoteTransactionType.STATUS).get(result, this.record.getNormalizers());
    }

    public String getTransactionClass() {
        String result = this.record.get("TRANCLASS");
        if (result == null) {
            return this.delegate.getTransactionClass();
        }
        return (String)((CICSAttribute)RemoteTransactionType.TRANSACTION_CLASS).get(result, this.record.getNormalizers());
    }

    public Long getRemoteStartCount() {
        return this.delegate.getRemoteStartCount();
    }

    public IRemoteTransaction.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public IRemoteTransaction.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public String getApplicationName() {
        return this.delegate.getApplicationName();
    }

    public String getPlatformName() {
        return this.delegate.getPlatformName();
    }

    public String getOperationName() {
        return this.delegate.getOperationName();
    }

    public Long getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    public Long getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    public Long getMicroVersion() {
        return this.delegate.getMicroVersion();
    }

    public IRemoteTransaction.AvailabilityValue getAvailability() {
        return this.delegate.getAvailability();
    }

    public void setPriority(Long _priority) {
        if (_priority.equals(this.delegate.getPriority())) {
            this.record.set("PRIORITY", null);
        } else {
            RemoteTransactionType.PRIORITY.validate((Object)_priority);
            String connectionSpecificExternalValue = ((CICSAttribute)RemoteTransactionType.PRIORITY).set(_priority, this.record.getNormalizers());
            this.record.set("PRIORITY", connectionSpecificExternalValue);
        }
    }

    public void setPurgeability(IRemoteTransaction.PurgeabilityValue _purgeability) {
        if (_purgeability.equals((Object)this.delegate.getPurgeability())) {
            this.record.set("PURGEABILITY", null);
        } else {
            RemoteTransactionType.PURGEABILITY.validate((Object)_purgeability);
            String connectionSpecificExternalValue = ((CICSAttribute)RemoteTransactionType.PURGEABILITY).set(_purgeability, this.record.getNormalizers());
            this.record.set("PURGEABILITY", connectionSpecificExternalValue);
        }
    }

    public void setStatus(ICICSEnums.EnablementValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("STATUS", null);
        } else {
            RemoteTransactionType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)RemoteTransactionType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("STATUS", connectionSpecificExternalValue);
        }
    }

    public void setTransactionClass(String _transactionClass) {
        if (_transactionClass.equals(this.delegate.getTransactionClass())) {
            this.record.set("TRANCLASS", null);
        } else {
            RemoteTransactionType.TRANSACTION_CLASS.validate((Object)_transactionClass);
            String connectionSpecificExternalValue = ((CICSAttribute)RemoteTransactionType.TRANSACTION_CLASS).set(_transactionClass, this.record.getNormalizers());
            this.record.set("TRANCLASS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == RemoteTransactionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == RemoteTransactionType.REMOTE_NAME) {
            return (V)this.getRemoteName();
        }
        if (attribute == RemoteTransactionType.REMOTE_SYSTEM) {
            return (V)this.getRemoteSystem();
        }
        if (attribute == RemoteTransactionType.PROFILE) {
            return (V)this.getProfile();
        }
        if (attribute == RemoteTransactionType.TRANSACTION_ROUTING_PROFILE) {
            return (V)this.getTransactionRoutingProfile();
        }
        if (attribute == RemoteTransactionType.ROUTING) {
            return (V)this.getRouting();
        }
        if (attribute == RemoteTransactionType.REMOTE_USE_COUNT) {
            return (V)this.getRemoteUseCount();
        }
        if (attribute == RemoteTransactionType.USE_COUNT) {
            return (V)this.getUseCount();
        }
        if (attribute == RemoteTransactionType.PRIORITY) {
            return (V)this.getPriority();
        }
        if (attribute == RemoteTransactionType.PURGEABILITY) {
            return (V)this.getPurgeability();
        }
        if (attribute == RemoteTransactionType.READ_TIMEOUT) {
            return (V)this.getReadTimeout();
        }
        if (attribute == RemoteTransactionType.SCREEN_SIZE) {
            return (V)this.getScreenSize();
        }
        if (attribute == RemoteTransactionType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == RemoteTransactionType.TRANSACTION_CLASS) {
            return (V)this.getTransactionClass();
        }
        if (attribute == RemoteTransactionType.REMOTE_START_COUNT) {
            return (V)this.getRemoteStartCount();
        }
        if (attribute == RemoteTransactionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == RemoteTransactionType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == RemoteTransactionType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == RemoteTransactionType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == RemoteTransactionType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == RemoteTransactionType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == RemoteTransactionType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == RemoteTransactionType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == RemoteTransactionType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == RemoteTransactionType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        if (attribute == RemoteTransactionType.APPLICATION_NAME) {
            return (V)this.getApplicationName();
        }
        if (attribute == RemoteTransactionType.PLATFORM_NAME) {
            return (V)this.getPlatformName();
        }
        if (attribute == RemoteTransactionType.OPERATION_NAME) {
            return (V)this.getOperationName();
        }
        if (attribute == RemoteTransactionType.MAJOR_VERSION) {
            return (V)this.getMajorVersion();
        }
        if (attribute == RemoteTransactionType.MINOR_VERSION) {
            return (V)this.getMinorVersion();
        }
        if (attribute == RemoteTransactionType.MICRO_VERSION) {
            return (V)this.getMicroVersion();
        }
        if (attribute == RemoteTransactionType.AVAILABILITY) {
            return (V)this.getAvailability();
        }
        return super.getAttributeValue(attribute);
    }

    public RemoteTransactionType getObjectType() {
        return RemoteTransactionType.getInstance();
    }

    @Override
    public RemoteTransactionReference getCICSObjectReference() {
        return new RemoteTransactionReference(this.getCICSContainer(), this.getName());
    }
}

