/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.SystemLinkReference;
import com.ibm.cics.core.model.SystemLinkType;
import com.ibm.cics.core.model.internal.MutableCPSMDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.ISystemLink;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableSystemLink;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableSystemLink
extends MutableCPSMDefinition
implements IMutableSystemLink {
    private ISystemLink delegate;
    private MutableSMRecord record;

    public MutableSystemLink(ICPSM cpsm, IContext context, ISystemLink cicsObject) {
        super(cpsm, context, (ICPSMDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("SYSLINK");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getFromcsys() {
        return this.delegate.getFromcsys();
    }

    public String getTocsys() {
        return this.delegate.getTocsys();
    }

    public String getConndef() {
        return this.delegate.getConndef();
    }

    public String getSessdef() {
        return this.delegate.getSessdef();
    }

    public Long getConndefver() {
        return this.delegate.getConndefver();
    }

    public Long getSessdefver() {
        return this.delegate.getSessdefver();
    }

    public ISystemLink.LinktypeValue getLinktype() {
        String result = this.record.get("LINKTYPE");
        if (result == null) {
            return this.delegate.getLinktype();
        }
        return (ISystemLink.LinktypeValue)((CICSAttribute)SystemLinkType.LINKTYPE).get(result, this.record.getNormalizers());
    }

    public void setLinktype(ISystemLink.LinktypeValue _linktype) {
        if (_linktype.equals((Object)this.delegate.getLinktype())) {
            this.record.set("LINKTYPE", null);
        } else {
            SystemLinkType.LINKTYPE.validate((Object)_linktype);
            String connectionSpecificExternalValue = ((CICSAttribute)SystemLinkType.LINKTYPE).set(_linktype, this.record.getNormalizers());
            this.record.set("LINKTYPE", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == SystemLinkType.FROMCSYS) {
            return (V)this.getFromcsys();
        }
        if (attribute == SystemLinkType.TOCSYS) {
            return (V)this.getTocsys();
        }
        if (attribute == SystemLinkType.CONNDEF) {
            return (V)this.getConndef();
        }
        if (attribute == SystemLinkType.SESSDEF) {
            return (V)this.getSessdef();
        }
        if (attribute == SystemLinkType.CONNDEFVER) {
            return (V)this.getConndefver();
        }
        if (attribute == SystemLinkType.SESSDEFVER) {
            return (V)this.getSessdefver();
        }
        if (attribute == SystemLinkType.LINKTYPE) {
            return (V)this.getLinktype();
        }
        return super.getAttributeValue(attribute);
    }

    public SystemLinkType getObjectType() {
        return SystemLinkType.getInstance();
    }

    @Override
    public SystemLinkReference getCICSObjectReference() {
        return new SystemLinkReference(this.getCICSContainer(), this.getFromcsys(), this.getTocsys(), this.getConndef(), this.getConndefver(), this.getSessdef(), this.getSessdefver(), this.getLinktype());
    }
}

