/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.SystemDumpReference;
import com.ibm.cics.core.model.SystemDumpType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.ISystemDump;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class SystemDump
extends CICSResource
implements ISystemDump {
    private String _sysdumpcode;
    private Long _current;
    private Long _maximum;
    private ISystemDump.ShutdownOptionValue _shutoption;
    private ISystemDump.SystemDumpOptionValue _sysdumping;
    private Long _sdmptotl;
    private Long _sdmpsupp;
    private ISystemDump.SystemDumpScopeValue _sdumpscope;
    private ISystemDump.DAEOptionValue _daeoption;

    public SystemDump(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("SYSDUMPCODE");
        this._sysdumpcode = (String)((CICSAttribute)SystemDumpType.SYSTEM_DUMP_CODE).get(stringValue, normalizers);
        stringValue = record.get("CURRENT");
        this._current = (Long)((CICSAttribute)SystemDumpType.SYSTEM_DUMPS_SINCE_RESET).get(stringValue, normalizers);
        stringValue = record.get("MAXIMUM");
        this._maximum = (Long)((CICSAttribute)SystemDumpType.MAXIMUM_SYSTEM_DUMPS).get(stringValue, normalizers);
        stringValue = record.get("SHUTOPTION");
        this._shutoption = (ISystemDump.ShutdownOptionValue)((CICSAttribute)SystemDumpType.SHUTDOWN_OPTION).get(stringValue, normalizers);
        stringValue = record.get("SYSDUMPING");
        this._sysdumping = (ISystemDump.SystemDumpOptionValue)((CICSAttribute)SystemDumpType.SYSTEM_DUMP_OPTION).get(stringValue, normalizers);
        stringValue = record.get("SDMPTOTL");
        this._sdmptotl = (Long)((CICSAttribute)SystemDumpType.SYSTEM_DUMPS_TAKEN).get(stringValue, normalizers);
        stringValue = record.get("SDMPSUPP");
        this._sdmpsupp = (Long)((CICSAttribute)SystemDumpType.SYSTEM_DUMPS_SUPPRESSED).get(stringValue, normalizers);
        stringValue = record.get("SDUMPSCOPE");
        this._sdumpscope = (ISystemDump.SystemDumpScopeValue)((CICSAttribute)SystemDumpType.SYSTEM_DUMP_SCOPE).get(stringValue, normalizers);
        stringValue = record.get("DAEOPTION");
        this._daeoption = (ISystemDump.DAEOptionValue)((CICSAttribute)SystemDumpType.DAE_OPTION).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return SystemDumpType.SYSTEM_DUMP_CODE.internalToExternal((Object)this.getSystemDumpCode());
        }
        catch (IllegalCICSAttributeException illegalCICSAttributeException) {
            return "";
        }
    }

    public String getSystemDumpCode() {
        return this._sysdumpcode;
    }

    public Long getSystemDumpsSinceReset() {
        return this._current;
    }

    public Long getMaximumSystemDumps() {
        return this._maximum;
    }

    public ISystemDump.ShutdownOptionValue getShutdownOption() {
        return this._shutoption;
    }

    public ISystemDump.SystemDumpOptionValue getSystemDumpOption() {
        return this._sysdumping;
    }

    public Long getSystemDumpsTaken() {
        return this._sdmptotl;
    }

    public Long getSystemDumpsSuppressed() {
        return this._sdmpsupp;
    }

    public ISystemDump.SystemDumpScopeValue getSystemDumpScope() {
        return this._sdumpscope;
    }

    public ISystemDump.DAEOptionValue getDAEOption() {
        return this._daeoption;
    }

    public SystemDumpType getObjectType() {
        return SystemDumpType.getInstance();
    }

    @Override
    public SystemDumpReference getCICSObjectReference() {
        return new SystemDumpReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == SystemDumpType.SYSTEM_DUMP_CODE) {
            return (V)this.getSystemDumpCode();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMPS_SINCE_RESET) {
            return (V)this.getSystemDumpsSinceReset();
        }
        if (attribute == SystemDumpType.MAXIMUM_SYSTEM_DUMPS) {
            return (V)this.getMaximumSystemDumps();
        }
        if (attribute == SystemDumpType.SHUTDOWN_OPTION) {
            return (V)this.getShutdownOption();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMP_OPTION) {
            return (V)this.getSystemDumpOption();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMPS_TAKEN) {
            return (V)this.getSystemDumpsTaken();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMPS_SUPPRESSED) {
            return (V)this.getSystemDumpsSuppressed();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMP_SCOPE) {
            return (V)this.getSystemDumpScope();
        }
        if (attribute == SystemDumpType.DAE_OPTION) {
            return (V)this.getDAEOption();
        }
        V value = super.getAttributeValue(attribute);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not a valid attribute for type " + SystemDumpType.getInstance());
    }
}

