/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class ConnectionBoundEditorManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ConnectionBoundEditorManager.class);
    private final IWorkbench workbench;

    public ConnectionBoundEditorManager(IWorkbench workbench) {
        this.workbench = workbench;
    }

    public boolean tryCloseEditors(final IConnectable connectable) {
        final Boolean[] result = new Boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = ConnectionBoundEditorManager.this.workbench.getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    debug.enter("tryCloseEditors", (Object)this, (Object)connectable);
                    IEditorReference[] editorReferences = window.getActivePage().getEditorReferences();
                    editorReferences = ConnectionBoundEditorManager.this.filterEditorReferences(editorReferences, connectable);
                    if (!window.getActivePage().closeEditors(editorReferences, true)) {
                        debug.exit("tryCloseEditors", (Object)false);
                        result[0] = false;
                        return;
                    }
                    ++n2;
                }
                result[0] = true;
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(runnable);
        } else {
            runnable.run();
        }
        while (result[0] == null) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        debug.exit("tryCloseEditors", (Object)true);
        return result[0];
    }

    private IEditorReference[] filterEditorReferences(IEditorReference[] editorReferences, IConnectable connection) {
        debug.enter("filterEditorReferences", Arrays.asList(editorReferences));
        ArrayList<IEditorReference> currentConnectionEditorReferences = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = editorReferences;
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            String id = reference.getId();
            String editorId = this.getEditorId(connection);
            IEditorInput input = null;
            try {
                input = reference.getEditorInput();
            }
            catch (PartInitException partInitException) {}
            if (editorId != null && id.startsWith(editorId) && (input == null || !(input instanceof IFileEditorInput))) {
                debug.event("filterEditorReferences", (Object)reference.getEditor(false));
                currentConnectionEditorReferences.add(reference);
            }
            ++n2;
        }
        IEditorReference[] filteredReferences = new IEditorReference[currentConnectionEditorReferences.size()];
        currentConnectionEditorReferences.toArray(filteredReferences);
        debug.exit("filterEditorReferences", Arrays.asList(filteredReferences));
        return filteredReferences;
    }

    private String getEditorId(IConnectable connection) {
        Class<?>[] interfaces;
        HashMap<String, String> interfaceToEditorId = new HashMap<String, String>();
        interfaceToEditorId.put("ICPSM", "com.ibm.cics.core.ui.editors");
        interfaceToEditorId.put("IZOSConnectable", "com.ibm.cics.zos");
        Class<?>[] classArray = interfaces = connection.getClass().getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            String id = (String)interfaceToEditorId.get(iface.getSimpleName());
            if (id != null) {
                return id;
            }
            ++n2;
        }
        return null;
    }
}

