/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.EventManager;
import com.ibm.cics.common.util.IStaleableEventListener;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.CredentialsManagerListener;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.eclipse.common.IConnectionPasswordStorage;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CredentialsManager
implements ICredentialsManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CREDENTIALS_NODE_NAME = "credentials";
    private static final String ENCODING_TYPE = "UTF8";
    private static final Debug debug = new Debug(CredentialsManager.class);
    private Map<String, CredentialsConfiguration> authenticatedInThisSession = new HashMap<String, CredentialsConfiguration>();
    private EventManager<CredentialsManagerListener.CredentialsManagerEvent> eventManager = new EventManager();
    private final Preferences credentialsNode;
    private final IConnectionPasswordStorage passwordStorage;
    private final boolean canSavePasswords;

    public CredentialsManager(Preferences node, IConnectionPasswordStorage passwordStore, boolean passwordSaveable) {
        this.canSavePasswords = passwordSaveable;
        this.credentialsNode = node.node(CREDENTIALS_NODE_NAME);
        this.passwordStorage = passwordStore;
        for (CredentialsConfiguration credentialsConfiguration : this.getAllCredentials()) {
            if (!credentialsConfiguration.isSavePassword()) continue;
            this.authenticatedInThisSession.put(credentialsConfiguration.getID(), credentialsConfiguration);
        }
    }

    @Override
    public void addCredentialsManagerListener(CredentialsManagerListener listener) {
        this.eventManager.addListener((IStaleableEventListener)listener);
    }

    private String getSerializedConfig(String credentialsConfigurationId) {
        return this.credentialsNode.get(credentialsConfigurationId, null);
    }

    private CredentialsConfiguration read(String configurationID) {
        CredentialsConfiguration configuration;
        String serialized = this.getSerializedConfig(configurationID);
        if (serialized != null && (configuration = this.deserialize(configurationID, serialized)) != null) {
            if (configuration.isSavePassword()) {
                String passwd = this.passwordStorage.read(configuration.getID(), configuration.getUserID());
                configuration.setPassword(passwd);
            }
            return configuration;
        }
        return null;
    }

    public String serialize(CredentialsConfiguration credentialsConfiguration) {
        String userid64;
        String name64;
        String name = credentialsConfiguration.getName();
        StringBuffer configSb = new StringBuffer();
        try {
            name64 = new String(Base64.encodeBase64((byte[])name.getBytes(ENCODING_TYPE)));
        }
        catch (UnsupportedEncodingException e) {
            debug.error("save", (Throwable)e);
            name64 = new String(Base64.encodeBase64((byte[])name.getBytes()));
        }
        configSb.append(name64).append(",");
        String userid = credentialsConfiguration.getUserID();
        try {
            userid64 = new String(Base64.encodeBase64((byte[])userid.getBytes(ENCODING_TYPE)));
        }
        catch (UnsupportedEncodingException e) {
            debug.error("save", (Throwable)e);
            userid64 = new String(Base64.encodeBase64((byte[])userid.getBytes()));
        }
        configSb.append(userid64).append(",");
        boolean savePassword = credentialsConfiguration.isSavePassword();
        configSb.append(String.valueOf(savePassword));
        return configSb.toString();
    }

    public CredentialsConfiguration deserialize(String credentialsId, String credCSV64) {
        String userid;
        String name;
        String[] tokenized = credCSV64.split(",");
        boolean savePassword = false;
        if (tokenized.length > 0) {
            String name64 = tokenized[0];
            try {
                name = new String(Base64.decodeBase64((byte[])name64.getBytes()), ENCODING_TYPE);
            }
            catch (UnsupportedEncodingException e) {
                debug.error("read", (Throwable)e);
                name = new String(Base64.decodeBase64((byte[])name64.getBytes()));
            }
        } else {
            return null;
        }
        if (tokenized.length > 1) {
            String userid64 = tokenized[1];
            try {
                userid = new String(Base64.decodeBase64((byte[])userid64.getBytes()), ENCODING_TYPE);
            }
            catch (UnsupportedEncodingException e) {
                debug.error("read", (Throwable)e);
                userid = new String(Base64.decodeBase64((byte[])userid64.getBytes()));
            }
        } else {
            return null;
        }
        if (tokenized.length > 2) {
            String savePwdStr = tokenized[2];
            savePassword = Boolean.valueOf(savePwdStr);
        }
        CredentialsConfiguration config = new CredentialsConfiguration(credentialsId, name, userid, "", savePassword);
        return config;
    }

    @Override
    public void setAuthenticatedInThisSession(CredentialsConfiguration configuration, boolean success) {
        if (success) {
            this.authenticatedInThisSession.put(configuration.getID(), new CredentialsConfiguration(configuration));
        } else {
            this.authenticatedInThisSession.remove(configuration.getID());
        }
    }

    @Override
    public void clearAuthenticated() {
        this.authenticatedInThisSession.clear();
    }

    @Override
    public boolean isAuthenticatedInthisSession(String configurationID) {
        if (configurationID == null) {
            return false;
        }
        return this.authenticatedInThisSession.containsKey(configurationID);
    }

    @Override
    public Collection<CredentialsConfiguration> getAllCredentials() {
        try {
            HashSet<CredentialsConfiguration> result = new HashSet<CredentialsConfiguration>();
            String[] stringArray = this.credentialsNode.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String credentialsID = stringArray[n2];
                CredentialsConfiguration configuration = this.findCredentialsConfigurationByID(credentialsID);
                if (configuration != null) {
                    result.add(configuration);
                }
                ++n2;
            }
            return result;
        }
        catch (BackingStoreException backingStoreException) {
            return Collections.emptySet();
        }
    }

    @Override
    public CredentialsConfiguration findCredentialsConfigurationByID(String credentialsID) {
        if (credentialsID == null) {
            return null;
        }
        if (this.authenticatedInThisSession.containsKey(credentialsID)) {
            return this.authenticatedInThisSession.get(credentialsID);
        }
        try {
            String[] keys;
            String[] stringArray = keys = this.credentialsNode.keys();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key.equals(credentialsID)) {
                    return this.read(credentialsID);
                }
                ++n2;
            }
            return null;
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }

    private void persist() {
        try {
            this.credentialsNode.flush();
        }
        catch (BackingStoreException ex) {
            debug.error("persist", "Error writing credentials", (Throwable)ex);
        }
    }

    private void notifyListeners(CredentialsManagerListener.CredentialsManagerEvent event) {
        this.persist();
        this.eventManager.notifyListeners((Object)event);
    }

    @Override
    public void update(CredentialsConfiguration configuration) {
        this.update(configuration, false);
    }

    @Override
    public void update(CredentialsConfiguration configuration, boolean authenticated) {
        CredentialsConfiguration existingConfig = this.read(configuration.getID());
        CredentialsManagerListener.CredentialsManagerEvent event = null;
        if (!configuration.equals((Object)existingConfig)) {
            if (configuration.isSavePassword()) {
                this.passwordStorage.save(configuration.getID(), configuration.getUserID(), configuration.getPassword());
            } else {
                this.passwordStorage.delete(configuration.getID());
            }
            String serializedConfig = this.serialize(configuration);
            this.credentialsNode.put(configuration.getID(), serializedConfig);
            if (existingConfig == null) {
                event = new CredentialsManagerListener.CredentialAddedEvent(configuration);
            } else {
                authenticated = authenticated || this.isAuthenticatedInthisSession(existingConfig.getID()) && !this.hasSignificantlyChanged(existingConfig, configuration);
                event = new CredentialsManagerListener.CredentialModifiedEvent(existingConfig, configuration);
            }
        } else {
            boolean bl = authenticated = authenticated || this.isAuthenticatedInthisSession(configuration.getID());
        }
        if (authenticated) {
            this.authenticatedInThisSession.put(configuration.getID(), configuration);
        } else {
            this.clearAuthenticated(configuration.getID());
        }
        if (event != null) {
            this.notifyListeners(event);
        }
    }

    private boolean hasSignificantlyChanged(CredentialsConfiguration existing, CredentialsConfiguration replacement) {
        return !replacement.getPassword().equals(existing.getPassword()) || !replacement.getUserID().equals(existing.getUserID()) || replacement.isSavePassword() != existing.isSavePassword();
    }

    @Override
    public void remove(String credentialsConfigurationID) {
        CredentialsConfiguration config = this.read(credentialsConfigurationID);
        this.credentialsNode.remove(credentialsConfigurationID);
        this.passwordStorage.delete(credentialsConfigurationID);
        if (config != null) {
            this.authenticatedInThisSession.remove(credentialsConfigurationID);
            this.notifyListeners(new CredentialsManagerListener.CredentialRemovedEvent(config));
        }
    }

    @Override
    public String createNewName() {
        Collection<CredentialsConfiguration> creds = this.getAllCredentials();
        HashSet<String> names = new HashSet<String>();
        for (CredentialsConfiguration cred : creds) {
            names.add(cred.getName());
        }
        return ConnectionUtils.createNewNamesAgainst(names, Messages.CredentialsManager_newCredentials);
    }

    @Override
    public boolean isPasswordSaveable() {
        return this.canSavePasswords;
    }

    @Override
    public void clearAuthenticated(String credentialsId) {
        this.authenticatedInThisSession.remove(credentialsId);
    }

    @Override
    public void invalidate(String credentialsID) {
        CredentialsConfiguration config = this.findCredentialsConfigurationByID(credentialsID);
        if (config != null) {
            config.setPassword("");
            config.setSavePassword(false);
            this.clearAuthenticated(credentialsID);
            this.update(config);
        }
    }
}

