/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.ConnectionManager;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.IConnectionAuthenticationProvider;
import com.ibm.cics.core.connections.internal.PasswordDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PasswordDialogAuthenticationProvider
implements IConnectionAuthenticationProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICredentialsManager credentialsManager;
    private ConnectionManager connectionManager;

    public PasswordDialogAuthenticationProvider(ICredentialsManager credentialsManager, ConnectionManager connectionManager) {
        this.credentialsManager = credentialsManager;
        this.connectionManager = connectionManager;
    }

    @Override
    public boolean authenticate(String configurationId) {
        if (this.requiresAuthentication(configurationId)) {
            if (this.showDialog(configurationId)) {
                if (this.isAlreadyAuthenticated(configurationId)) {
                    return true;
                }
                return this.showDialog(configurationId);
            }
            return false;
        }
        return true;
    }

    private boolean showDialog(final String configurationId) {
        final boolean[] dialogNotCancelled = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                PasswordDialog passwordDialog = new PasswordDialog(shell, configurationId, PasswordDialogAuthenticationProvider.this.credentialsManager, PasswordDialogAuthenticationProvider.this.connectionManager);
                passwordDialog.open();
                if (passwordDialog.getReturnCode() == 0) {
                    dialogNotCancelled[0] = true;
                }
            }
        });
        return dialogNotCancelled[0];
    }

    private boolean requiresAuthentication(String configurationId) {
        if (this.isBlankAuthenticated(configurationId)) {
            return false;
        }
        return !this.isAlreadyAuthenticated(configurationId);
    }

    private boolean isAlreadyAuthenticated(String configurationId) {
        ConnectionProfile config = this.connectionManager.getConnectionProfile(configurationId);
        return config != null && config.getCredentials() != null && this.credentialsManager.isAuthenticatedInthisSession(config.getCredentials().getID());
    }

    private boolean isBlankAuthenticated(String configurationId) {
        boolean allowBlankUserID;
        ConnectionProfile config = this.connectionManager.getConnectionProfile(configurationId);
        boolean bl = allowBlankUserID = !ConnectionUtils.connectionTypeUsesCredentials(config.getConnectionDescriptor());
        if (allowBlankUserID) {
            String userID;
            String string = userID = config.getCredentials() != null ? config.getCredentials().getUserID() : null;
            if (StringUtil.isEmpty((String)userID)) {
                return true;
            }
        }
        return false;
    }
}

