/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSplexType;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.ICICSplexRepository;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.ScopedContext;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectContainer;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;

public class CICSplexRepository
implements ICICSplexRepository,
IContextProvider,
ICoreObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ICPSM cpsm;
    private ICICSplex cicsPlex;
    private IContext context;

    public CICSplexRepository(ICICSplex cicsPlex) {
        this.cpsm = ((ICoreObject)cicsPlex).getCPSM();
        this.cicsPlex = cicsPlex;
        this.context = cicsPlex.getCMASName().equals(CICSplexType.CMAS_NAME.getUnsupportedValue()) ? new ScopedContext(cicsPlex.getName(), cicsPlex.getName()) : new Context(cicsPlex.getName());
    }

    public ICPSM getCPSM() {
        return this.cpsm;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getName() {
        return this.cicsPlex.getName();
    }

    public ICICSplex getCICSplex() {
        return this.cicsPlex;
    }

    public IContext getIContext() {
        return this.context;
    }

    @Deprecated
    public ICICSType<?> getCICSType() {
        return null;
    }

    public ICICSType<?> getObjectType() {
        return this.getCICSType();
    }

    public boolean mpCMASActive() {
        ICICSplex cicsPlex = this.getCICSplex();
        ICICSEnums.YesNoValue mpStatus = cicsPlex.getMPStatus();
        boolean result = mpStatus != null && mpStatus == ICICSEnums.YesNoValue.YES && cicsPlex.getCMASStatus() == ICICSplex.CMASStatusValue.ACTIVE;
        return result;
    }

    public <T> T getAttributeValue(IAttribute<T> attribute) {
        return null;
    }

    public ICICSObjectReference<?> getCICSObjectReference() {
        return null;
    }

    public ICICSObjectContainer<? extends ICICSObject> getCICSContainer() {
        return null;
    }
}

