/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.EventManager;
import com.ibm.cics.common.util.IStaleableEventListener;
import com.ibm.cics.common.util.StaleableEventListener;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.ui.UIHelper;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.core.ui.views.FilterControlContribution;
import com.ibm.cics.core.ui.views.IElementTypeService;
import com.ibm.cics.core.ui.views.LegacyTableManager;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.core.ui.views.PreferenceService;
import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.ComplexFilteredContext;
import com.ibm.cics.sm.comm.ICICSGetAction;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;

public class FilterManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String NO_FILTER_PROPERTIES = "NONE";
    private static final String NONE = "";
    private static final Debug DEBUG = new Debug(FilterManager.class);
    public static final String FILTER_GROUP_NAME = "filter";
    public static final String FILTER_ACTIONS_GROUP_NAME = "filterActions";
    private EventManager eventManager = new EventManager();
    private List<ICICSAttribute<?>> enabledFilters = new ArrayList();
    private List<FilterData> filterDatas = new ArrayList<FilterData>();
    private List<FilterControlContribution> filterToolBarContributionItems = null;
    private IAction runFilterAction = new Action(){
        {
            this.setEnabled(false);
            this.setToolTipText(Messages.getString("ResourcesView.runFilterAction.tooltip", new Object[0]));
            this.setImageDescriptor(UIPlugin.getImageDescriptor("icons/full/elcl16/run.gif"));
        }

        public void run() {
            DEBUG.enter("runFilterAction.run", (Object)this);
            FilterManager.this.applyFilters();
            DEBUG.exit("runFilterAction.run");
        }

        public String toString() {
            return "IAction[runFilterAction]";
        }
    };
    private IAction clearFilterAction = new Action(){
        {
            this.setEnabled(false);
            this.setToolTipText(Messages.getString("ResourcesView.clearFilterAction.tooltip", new Object[0]));
            this.setImageDescriptor(UIPlugin.getImageDescriptor("icons/clear_filter.gif"));
        }

        public void run() {
            DEBUG.enter("clearFilterAction.run", (Object)this);
            ArrayList<FilterData> clearedFilters = new ArrayList<FilterData>();
            for (FilterControlContribution control : FilterManager.this.filterToolBarContributionItems) {
                clearedFilters.add(new FilterData((ICICSAttribute)control.getDescriptor().getAttribute(), FilterManager.NONE));
                control.getValueEditor().setValue(FilterManager.NONE);
            }
            FilterManager.this.addFilters(clearedFilters);
            DEBUG.exit("clearFilterAction.run");
        }

        public String toString() {
            return "IAction[clearFilterAction]";
        }
    };
    private final LegacyTableManager legacyTableManager;
    private final IElementTypeService elementTypeService;
    private final PreferenceService preferenceService;
    private final boolean saveEnabled;
    private IToolBarManager toolBarManager;
    private List<String> ignoredFilters = new ArrayList<String>();
    private boolean connectionSupportsComplexFilters = false;

    public FilterManager(LegacyTableManager legacyTableManager, IElementTypeService elementTypeService, PreferenceService preferenceService, boolean saveEnabled, IToolBarManager toolBarManager) {
        this.legacyTableManager = legacyTableManager;
        this.elementTypeService = elementTypeService;
        this.preferenceService = preferenceService;
        this.saveEnabled = saveEnabled;
        this.toolBarManager = toolBarManager;
        legacyTableManager.addListener(new LegacyTableManager.Listener(){

            public void event(LegacyTableManager.Event event) {
                if (event instanceof LegacyTableManager.TableDisposedEvent) {
                    FilterManager.this.saveFilters();
                }
            }
        });
        elementTypeService.addElementTypeServiceListener(new IElementTypeService.ElementTypeServiceListener(){

            public void event(IElementTypeService.Event event) {
                if (event instanceof IElementTypeService.ElementTypeChangedEvent) {
                    FilterManager.this.saveFilters(((IElementTypeService.ElementTypeChangedEvent)event).getOldType());
                    FilterManager.this.legacyTableManager.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FilterManager.this.disableFilters();
                            FilterManager.this.refreshFilterToolBarContributionsFromPreferences();
                        }
                    });
                }
            }
        });
    }

    public synchronized void addListener(FilterListener l) {
        this.eventManager.addListener((IStaleableEventListener)l);
    }

    public void removeListener(FilterListener l) {
        l.makeStale();
    }

    private List<ICICSAttribute<?>> getFilterIDs(List<FilterData> filters) {
        ArrayList attributes = new ArrayList(filters.size());
        for (FilterData fD : filters) {
            attributes.add(fD.getFilterField());
        }
        return attributes;
    }

    private synchronized boolean addFilters(List<FilterData> newFilters) {
        DEBUG.enter("addFilters", newFilters);
        newFilters = new ArrayList<FilterData>(newFilters);
        List<LegacyTableManager.ColumnData> columnData = this.legacyTableManager.getColumnData();
        Iterator<FilterData> iterator = newFilters.iterator();
        block0: while (iterator.hasNext()) {
            FilterData newFilterData = iterator.next();
            for (LegacyTableManager.ColumnData columnData2 : columnData) {
                if (((ICICSAttribute)columnData2.id).equals(newFilterData.field)) continue block0;
            }
            iterator.remove();
        }
        if (newFilters.isEmpty()) {
            return false;
        }
        boolean forceChangedEvent = false;
        if (this.filterToolBarContributionItems != null) {
            block2: for (FilterControlContribution filterControlContribution : this.filterToolBarContributionItems) {
                String currentValue = filterControlContribution.getValueEditor().getValue();
                for (FilterData data : this.filterDatas) {
                    if (!data.getFilterField().equals((Object)filterControlContribution.getDescriptor().getAttribute())) continue;
                    if (currentValue.equals(data.string)) continue block2;
                    forceChangedEvent = true;
                    break block2;
                }
            }
        }
        boolean fireChangedEvent = forceChangedEvent || newFilters.size() > 1 || !NONE.equals(newFilters.get(0).getFilterString());
        ArrayList<FilterData> arrayList = new ArrayList<FilterData>(this.filterDatas);
        ArrayList proposedEnabledFilters = new ArrayList(this.enabledFilters);
        List<ICICSAttribute<?>> newFilterIds = this.getFilterIDs(newFilters);
        ArrayList<FilterData> obsoleteFilterDatas = new ArrayList<FilterData>();
        for (FilterData f : arrayList) {
            if (!newFilterIds.contains(f.getFilterField())) continue;
            obsoleteFilterDatas.add(f);
        }
        arrayList.removeAll(obsoleteFilterDatas);
        proposedEnabledFilters.removeAll(newFilterIds);
        arrayList.addAll(newFilters);
        proposedEnabledFilters.addAll(newFilterIds);
        BeforeFilterChangeEvent event = new BeforeFilterChangeEvent(this.maskFilters(proposedEnabledFilters, arrayList));
        this.eventManager.notifyListeners((Object)event);
        FilterEvent afterEvent = null;
        if (!event.isVetoed()) {
            this.filterDatas = arrayList;
            this.enabledFilters = proposedEnabledFilters;
            if (fireChangedEvent) {
                afterEvent = new FilterChangedEvent(this.maskFilters(this.enabledFilters, this.filterDatas));
            }
            this.refreshFilterToolBarContributions();
        } else {
            afterEvent = new FilterChangeVetoedEvent(this.maskFilters(this.enabledFilters, this.filterDatas), event.getVetoReasons());
        }
        if (afterEvent != null) {
            this.eventManager.notifyListeners((Object)afterEvent);
        }
        DEBUG.exit("addFilters", (Object)(!event.isVetoed() ? 1 : 0));
        return !event.isVetoed();
    }

    public boolean addFilter(ICICSAttribute<?> id, String filter) {
        DEBUG.enter("addFilter", id, (Object)filter);
        FilterData newFilter = new FilterData(id, filter);
        boolean filtersSucceeded = this.addFilters(Collections.singletonList(newFilter));
        DEBUG.exit("addFilter", (Object)filtersSucceeded);
        return filtersSucceeded;
    }

    public synchronized boolean enableFilter(ICICSAttribute<?> id) {
        if (this.enabledFilters.contains(id)) {
            return true;
        }
        if (this.getFilterIDs(this.getAllFilters()).contains(id)) {
            FilterEvent afterEvent;
            ArrayList suggestedEnabledFilters = new ArrayList(this.enabledFilters);
            suggestedEnabledFilters.add(id);
            List<FilterData> proposedFilters = this.maskFilters(suggestedEnabledFilters, this.filterDatas);
            BeforeFilterChangeEvent beforeEvent = new BeforeFilterChangeEvent(proposedFilters);
            this.eventManager.notifyListeners((Object)beforeEvent);
            if (!beforeEvent.isVetoed()) {
                this.enabledFilters = suggestedEnabledFilters;
                afterEvent = new FilterChangedEvent(this.getEnabledFilters());
                this.refreshFilterToolBarContributions();
            } else {
                afterEvent = new FilterChangeVetoedEvent(this.getEnabledFilters(), beforeEvent.getVetoReasons());
            }
            this.eventManager.notifyListeners((Object)afterEvent);
            return !beforeEvent.isVetoed();
        }
        return false;
    }

    public synchronized boolean disableFilter(ICICSAttribute<?> id) {
        if (this.enabledFilters.contains(id)) {
            FilterEvent afterEvent;
            ArrayList suggestedEnabledFilters = new ArrayList(this.enabledFilters);
            suggestedEnabledFilters.remove(id);
            List<FilterData> proposedFilters = this.maskFilters(suggestedEnabledFilters, this.filterDatas);
            BeforeFilterChangeEvent beforeEvent = new BeforeFilterChangeEvent(proposedFilters);
            this.eventManager.notifyListeners((Object)beforeEvent);
            if (!beforeEvent.isVetoed()) {
                this.enabledFilters = suggestedEnabledFilters;
                afterEvent = new FilterChangedEvent(this.getEnabledFilters());
                this.refreshFilterToolBarContributions();
            } else {
                afterEvent = new FilterChangeVetoedEvent(this.getEnabledFilters(), beforeEvent.getVetoReasons());
            }
            this.eventManager.notifyListeners((Object)afterEvent);
            return !beforeEvent.isVetoed();
        }
        return false;
    }

    public synchronized boolean disableFilters() {
        FilterEvent afterEvent;
        ArrayList<FilterData> empty = new ArrayList<FilterData>();
        BeforeFilterChangeEvent beforeEvent = new BeforeFilterChangeEvent(empty);
        this.eventManager.notifyListeners((Object)beforeEvent);
        if (!beforeEvent.isVetoed()) {
            this.enabledFilters.clear();
            afterEvent = new FilterChangedEvent(this.getEnabledFilters());
        } else {
            afterEvent = new FilterChangeVetoedEvent(this.getEnabledFilters(), beforeEvent.getVetoReasons());
        }
        if (this.filterToolBarContributionItems != null) {
            for (FilterControlContribution item : this.filterToolBarContributionItems) {
                this.toolBarManager.remove((IContributionItem)item);
            }
        }
        this.toolBarManager.update(true);
        this.filterToolBarContributionItems = null;
        this.eventManager.notifyListeners((Object)afterEvent);
        return !beforeEvent.isVetoed();
    }

    private List<FilterData> maskFilters(List<ICICSAttribute<?>> mask, List<FilterData> full) {
        DEBUG.enter("maskFilters", (Object[])new List[]{mask, full});
        ArrayList<FilterData> maskedFilters = new ArrayList<FilterData>(mask.size());
        for (FilterData fd : full) {
            if (!mask.contains(fd.getFilterField())) continue;
            maskedFilters.add(fd);
        }
        if (maskedFilters.size() != mask.size()) {
            DEBUG.warning("maskFilters", (Object)"Mask contained some filters that weren't in the provided set");
        }
        DEBUG.exit("maskFilters", maskedFilters);
        return maskedFilters;
    }

    public FilterData getFilter(ICICSAttribute<?> id) {
        Iterator<FilterData> it = this.maskFilters(Collections.singletonList(id), this.getAllFilters()).iterator();
        return it.hasNext() ? it.next() : null;
    }

    public List<FilterData> getEnabledFilters() {
        return this.maskFilters(this.enabledFilters, this.filterDatas);
    }

    public List<FilterData> getAllFilters() {
        return this.filterDatas;
    }

    private List<FilterData> loadFilterProperties() {
        DEBUG.enter("loadFilterProperties", (Object)this, this.filterToolBarContributionItems);
        if (this.filterToolBarContributionItems == null) {
            this.filterToolBarContributionItems = new LinkedList<FilterControlContribution>();
            ICICSType<?> elementType = this.elementTypeService.getElementType();
            String ids = UIPlugin.getDefault().getPreferenceStore().getString(String.valueOf(elementType.getResourceTableName()) + ".filterPropertyIds");
            DEBUG.event("loadFilterProperties", ids);
            if (ids.equals(NONE)) {
                String name = elementType.getNameAttribute();
                String id = elementType.findAttributeByCicsName(name).getPropertyId();
                ids = String.valueOf(id) + "=";
                DEBUG.event("loadFilterProperties", ids);
            } else if (ids.equals(NO_FILTER_PROPERTIES)) {
                ids = NONE;
            }
            StringTokenizer st = new StringTokenizer(ids.trim(), ",");
            while (st.hasMoreTokens()) {
                StringTokenizer property = new StringTokenizer(st.nextToken(), "=");
                String id = property.nextToken();
                ICICSAttribute attribute = elementType.findAttributeByID(id);
                String value = NONE;
                if (property.hasMoreTokens()) {
                    value = property.nextToken();
                }
                DEBUG.event("loadFilterProperties", id);
                this.addFilterProperty(attribute, value);
            }
        }
        List<FilterData> enabledFilters = this.getEnabledFilters();
        DEBUG.exit("loadFilterProperties", enabledFilters);
        return enabledFilters;
    }

    public IMenuManager createFilterMenu() {
        MenuManager filterColumnsMenuManager = new MenuManager(Messages.getString("ResourcesView.filterMenu.text", new Object[0]));
        filterColumnsMenuManager.add((IAction)new Action(){});
        filterColumnsMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
                HashSet attributes = new HashSet();
                List enabledFilters = FilterManager.this.loadFilterProperties();
                for (FilterData filterData : enabledFilters) {
                    attributes.add(filterData.getFilterField());
                }
                DEBUG.event("fillFilterMenu", (Object)this, attributes);
                for (LegacyTableManager.ColumnData columnData : FilterManager.this.legacyTableManager.getColumnData()) {
                    ICICSAttribute attribute = (ICICSAttribute)columnData.id;
                    Class type = attribute.getType();
                    String name = attribute.getPropertyId();
                    IAttributePropertyDescriptor descriptor = FilterManager.this.preferenceService.getPropertySource().getPropertyDescriptor((Object)name);
                    FilterPropertySelectionAction action = new FilterPropertySelectionAction(descriptor);
                    IAttribute descriptorAttribute = descriptor.getAttribute();
                    if (attributes.contains(descriptorAttribute)) {
                        action.setChecked(true);
                        attributes.remove(descriptorAttribute);
                    }
                    if (name.equals("regionName") || name.equals("CICSRelease") || type == Date.class) {
                        action.setEnabled(false);
                    }
                    manager.add((IAction)action);
                    DEBUG.event("fillFilterMenu", (Object)this, (Object)columnData, (Object)action);
                }
                DEBUG.event("fillFilterMenu", (Object)this, attributes);
                for (ICICSAttribute iCICSAttribute : attributes) {
                    String name = iCICSAttribute.getPropertyId();
                    IAttributePropertyDescriptor descriptor = FilterManager.this.preferenceService.getPropertySource().getPropertyDescriptor((Object)name);
                    FilterPropertySelectionAction action = new FilterPropertySelectionAction(descriptor);
                    action.setChecked(true);
                    manager.add((IAction)action);
                    DEBUG.event("fillFilterMenu", (Object)this, (Object)action);
                }
            }
        });
        return filterColumnsMenuManager;
    }

    private void addFilterContribution(IAttributePropertyDescriptor descriptor) {
        IAttribute attribute = descriptor.getAttribute();
        final String cicsName = ((ICICSAttribute)attribute).getCicsName();
        new ICICSGetAction(){

            public ICICSOperation.OperationType getOperationType() {
                return ICICSOperation.OperationType.GET;
            }

            public String getAttributeName() {
                return cicsName;
            }
        };
        List<FilterData> filters = this.getAllFilters();
        String filterString = NONE;
        for (FilterData filterData : filters) {
            if (!filterData.getFilterField().equals((Object)descriptor.getAttribute())) continue;
            filterString = filterData.getFilterString();
        }
        String value = filterString;
        FilterControlContribution filterControl = new FilterControlContribution(descriptor, true, value, this.runFilterAction);
        DEBUG.event("addFilterToolBarContributions", (Object)descriptor, (Object)value);
        this.toolBarManager.prependToGroup(FILTER_GROUP_NAME, (IContributionItem)filterControl);
        this.filterToolBarContributionItems.add(filterControl);
    }

    private void refreshFilterToolBarContributions() {
        DEBUG.enter("refreshFilterToolBarContributions", (Object)this, (Object)this.toolBarManager, this.filterToolBarContributionItems);
        if (this.filterToolBarContributionItems != null) {
            HashMap enabledFilters = new HashMap();
            for (FilterData filter : this.getEnabledFilters()) {
                enabledFilters.put(filter.getFilterField(), filter);
            }
            ArrayList<FilterControlContribution> contributionItemsToRemove = new ArrayList<FilterControlContribution>();
            for (FilterControlContribution item : this.filterToolBarContributionItems) {
                if (!enabledFilters.containsKey(item.getDescriptor().getAttribute())) {
                    this.toolBarManager.remove((IContributionItem)item);
                    contributionItemsToRemove.add(item);
                    enabledFilters.remove(item.getDescriptor().getAttribute());
                    continue;
                }
                enabledFilters.remove(item.getDescriptor().getAttribute());
            }
            for (FilterControlContribution filterControlContribution : contributionItemsToRemove) {
                this.filterToolBarContributionItems.remove((Object)filterControlContribution);
            }
            for (FilterData filter : enabledFilters.values()) {
                IAttributePropertyDescriptor descriptor = this.preferenceService.getPropertySource().getPropertyDescriptor((Object)filter.getFilterField().getPropertyId());
                this.addFilterContribution(descriptor);
            }
            this.toolBarManager.update(true);
        }
        DEBUG.exit("refreshFilterToolBarContributions", this.filterToolBarContributionItems);
    }

    public void refreshFilterToolBarContributionsFromPreferences() {
        this.loadFilterProperties();
        this.refreshFilterToolBarContributions();
    }

    public IContext applyFilters(IContext context) {
        return this.connectionSupportsComplexFilters ? this.applyComplexFilters(context) : this.applyBasicFilters(context);
    }

    private IContext applyBasicFilters(IContext context) {
        FilteredContext fc = new FilteredContext(context);
        this.ignoredFilters.clear();
        for (FilterData filterData : this.getEnabledFilters()) {
            ICICSAttribute<?> attribute = filterData.getFilterField();
            String filterString = filterData.getFilterString();
            try {
                if (filterString.trim().length() <= 0) continue;
                FilterManager.setAttributeValue(fc, attribute, filterString.trim());
            }
            catch (IllegalCICSAttributeException illegalCICSAttributeException) {
                this.ignoredFilters.add(attribute.getCicsName());
            }
        }
        DEBUG.event("applyBasicFilters", (Object)fc);
        return fc;
    }

    private static <T> void setAttributeValue(FilteredContext fc, ICICSAttribute<T> attr, String stringValue) {
        Object value = attr.externalToInternal(stringValue);
        fc.setAttributeValue(attr, value);
    }

    private IContext applyComplexFilters(IContext context) {
        FilterExpression aFilterExpression = FilterExpression.NULL;
        this.ignoredFilters.clear();
        for (FilterData filterData : this.getEnabledFilters()) {
            try {
                if (filterData.getFilterExpression() == FilterExpression.NULL) continue;
                aFilterExpression = aFilterExpression.and(filterData.getFilterExpression());
            }
            catch (IllegalCICSAttributeValueException illegalCICSAttributeValueException) {
                aFilterExpression = aFilterExpression.and(FilterExpression.NULL);
                this.ignoredFilters.add(filterData.getFilterField().getCicsName());
            }
        }
        DEBUG.event("applyComplexFilters", (Object)aFilterExpression);
        return new ComplexFilteredContext(context, aFilterExpression);
    }

    protected String getIgnoredFiltersMessage() {
        if (this.ignoredFilters.isEmpty()) {
            return UIHelper.EMPTY_STRING;
        }
        return String.valueOf(Messages.getString("FilterManager.invalidFilterExpressionIgnored", new Object[0])) + this.ignoredFilters.toString().replace("[", NONE).replace("]", NONE);
    }

    private void applyFilters() {
        DEBUG.enter("applyFilters", (Object)this, this.filterToolBarContributionItems);
        ArrayList<FilterData> filters = new ArrayList<FilterData>();
        for (FilterControlContribution control : this.filterToolBarContributionItems) {
            String value = control.getValueEditor().getValue();
            filters.add(new FilterData((ICICSAttribute)control.getDescriptor().getAttribute(), value));
        }
        this.addFilters(filters);
        DEBUG.exit("applyFilters");
    }

    public void addFilterProperty(ICICSAttribute<?> id, String value) {
        if (value != null) {
            this.addFilter(id, value);
        } else {
            FilterData currentFilter = this.getFilter(id);
            if (currentFilter != null) {
                currentFilter.getFilterString().equals(NONE);
                this.enableFilter(id);
            } else {
                this.addFilter(id, NONE);
            }
        }
    }

    private void removeFilterProperty(ICICSAttribute<?> attribute) {
        this.disableFilter(attribute);
    }

    private void saveFilters() {
        this.saveFilters(this.elementTypeService.getElementType());
    }

    private void saveFilters(ICICSType<?> elementType) {
        DEBUG.enter("saveFilters", (Object)this, (Object)this.saveEnabled);
        if (this.saveEnabled) {
            StringBuffer ids = new StringBuffer();
            if (this.getEnabledFilters().size() > 0) {
                for (FilterData filter : this.getEnabledFilters()) {
                    String id = filter.getFilterField().getPropertyId();
                    String value = filter.getFilterString();
                    if (value == null) {
                        value = NONE;
                    }
                    ids.append(id + "=" + value).append(",");
                }
            } else {
                ids.append(NO_FILTER_PROPERTIES);
            }
            DEBUG.event("saveFilters", (Object)ids);
            IPreferenceStore preferenceStore = UIPlugin.getDefault().getPreferenceStore();
            preferenceStore.setValue(String.valueOf(elementType.getResourceTableName()) + ".filterPropertyIds", ids.toString());
            if (preferenceStore instanceof IPersistentPreferenceStore) {
                IPersistentPreferenceStore persistentPreferenceStore = (IPersistentPreferenceStore)preferenceStore;
                try {
                    persistentPreferenceStore.save();
                }
                catch (IOException ex) {
                    DEBUG.error("saveFilters", (Throwable)ex);
                }
            }
        }
        DEBUG.exit("saveFilters");
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        toolBarManager.appendToGroup(FILTER_ACTIONS_GROUP_NAME, this.runFilterAction);
        toolBarManager.appendToGroup(FILTER_ACTIONS_GROUP_NAME, this.clearFilterAction);
    }

    public void disableActions() {
        this.runFilterAction.setEnabled(false);
        this.clearFilterAction.setEnabled(false);
    }

    public void enableActions() {
        this.runFilterAction.setEnabled(true);
        this.clearFilterAction.setEnabled(true);
    }

    public void setComplexFiltersSupported(boolean newState) {
        this.connectionSupportsComplexFilters = newState;
    }

    public static class BeforeFilterChangeEvent
    implements FilterEvent {
        private List<FilterData> filterDatas;
        private Map<ICICSAttribute<?>, String> vetoReasons = new HashMap();

        public BeforeFilterChangeEvent(List<FilterData> filterDatas) {
            this.filterDatas = filterDatas;
        }

        public List<FilterData> getFilterDatas() {
            return this.filterDatas;
        }

        public void veto(ICICSAttribute<?> id, String reason) {
            this.vetoReasons.put(id, reason);
        }

        public boolean isVetoed() {
            return this.vetoReasons.size() > 0;
        }

        public Map<ICICSAttribute<?>, String> getVetoReasons() {
            return this.vetoReasons;
        }
    }

    public static class FilterChangeVetoedEvent
    implements FilterEvent {
        private List<FilterData> filterDatas;
        private Map<ICICSAttribute<?>, String> vetoReasons;

        public FilterChangeVetoedEvent(List<FilterData> filterDatas, Map<ICICSAttribute<?>, String> vetoReasons) {
            this.filterDatas = filterDatas;
            this.vetoReasons = vetoReasons;
        }

        public List<FilterData> getFilterDatas() {
            return this.filterDatas;
        }

        public Map<ICICSAttribute<?>, String> getVetoReasons() {
            return this.vetoReasons;
        }
    }

    public static class FilterChangedEvent
    implements FilterEvent {
        private List<FilterData> filterDatas;

        public FilterChangedEvent(List<FilterData> filterDatas) {
            this.filterDatas = filterDatas;
        }

        public List<FilterData> getFilterDatas() {
            return this.filterDatas;
        }
    }

    static class FilterData {
        private final ICICSAttribute<?> field;
        private final String string;
        private final String IS = "==";
        private final String EQ = "=";
        private final String LT = "<";
        private final String LE = "<=";
        private final String GT = ">";
        private final String GE = ">=";
        private final String NOT = "!";

        public FilterData(ICICSAttribute<?> field, String string) {
            this.field = field;
            this.string = string;
        }

        public ICICSAttribute<?> getFilterField() {
            return this.field;
        }

        public String getFilterString() {
            return this.string;
        }

        public <T> FilterExpression getFilterExpression() throws IllegalCICSAttributeValueException {
            ICICSAttribute<?> attribute = this.getFilterField();
            String trimmed = this.getFilterString().trim();
            if (StringUtil.isEmpty((String)trimmed)) {
                return FilterExpression.NULL;
            }
            try {
                if (trimmed.startsWith("==")) {
                    return FilterExpression.is(attribute, (Object)attribute.externalToInternal(this.stripOperator("==", trimmed)));
                }
                if (trimmed.startsWith("<=")) {
                    return FilterExpression.le(attribute, (Object)attribute.externalToInternal(this.stripOperator("<=", trimmed)));
                }
                if (trimmed.startsWith("<")) {
                    return FilterExpression.lt(attribute, (Object)attribute.externalToInternal(this.stripOperator("<", trimmed)));
                }
                if (trimmed.startsWith(">=")) {
                    return FilterExpression.ge(attribute, (Object)attribute.externalToInternal(this.stripOperator(">=", trimmed)));
                }
                if (trimmed.startsWith(">")) {
                    return FilterExpression.gt(attribute, (Object)attribute.externalToInternal(this.stripOperator(">", trimmed)));
                }
                if (trimmed.startsWith("!")) {
                    return FilterExpression.ne(attribute, (Object)attribute.externalToInternal(this.stripOperator("!", trimmed)));
                }
                return FilterExpression.eq(attribute, (Object)attribute.externalToInternal(this.stripOperator("=", trimmed)));
            }
            catch (IllegalCICSAttributeException illegalCICSAttributeException) {
                throw new IllegalCICSAttributeValueException("Illegal attribute value");
            }
        }

        private String stripOperator(String operand, String filterString) {
            return filterString.replaceAll(operand, FilterManager.NONE).trim();
        }

        public String toString() {
            return String.valueOf(this.getFilterField().getPropertyId()) + ":" + this.getFilterString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            result = 31 * result + (this.string == null ? 0 : this.string.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FilterData other = (FilterData)obj;
            if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
                return false;
            }
            return !(this.string == null ? other.string != null : !this.string.equals(other.string));
        }
    }

    public static interface FilterEvent {
    }

    public static abstract class FilterListener
    extends StaleableEventListener<FilterEvent> {
    }

    private class FilterPropertySelectionAction
    extends Action {
        private final IAttributePropertyDescriptor descriptor;

        public FilterPropertySelectionAction(IAttributePropertyDescriptor propertyDescriptor) {
            super(propertyDescriptor.getDisplayName(), 2);
            this.descriptor = propertyDescriptor;
        }

        public void run() {
            DEBUG.enter("FilterPropertySelectionAction.run", (Object)this, (Object)this.isChecked(), (Object)this.descriptor);
            if (this.isChecked()) {
                FilterManager.this.addFilterProperty((ICICSAttribute)this.descriptor.getAttribute(), null);
            } else {
                FilterManager.this.removeFilterProperty((ICICSAttribute)this.descriptor.getAttribute());
            }
            DEBUG.exit("FilterPropertySelectionAction.run");
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.descriptor + ", " + this.isChecked() + "]";
        }
    }

    static interface IPropertyValueEditor {
        public String getValue();

        public void setValue(String var1);
    }

    static class IllegalCICSAttributeValueException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalCICSAttributeValueException(String string) {
            super(string);
        }
    }
}

