/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IParameterisedContext;
import com.ibm.cics.sm.comm.IScopedContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ParameterisedContext
implements IParameterisedContext {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IContext parent;
    private Map<String, String> parameters = new HashMap<String, String>();

    public ParameterisedContext(IContext context) {
        this.parent = context;
    }

    @Override
    public String getContext() {
        return this.parent.getContext();
    }

    @Override
    public String getScope() {
        if (this.parent instanceof IScopedContext) {
            IScopedContext scopedContext = (IScopedContext)this.parent;
            return scopedContext.getScope();
        }
        return null;
    }

    @Override
    public IContext getParentContext() {
        return this.parent;
    }

    public <T> void setParameterValue(String parameterName, String parameterValue) {
        this.parameters.put(parameterName, parameterValue);
    }

    @Override
    public String getParameterValue(String parameterName) {
        return this.parameters.get(parameterName);
    }

    @Override
    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }
}

