/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.CertificateDetails;
import com.ibm.cics.core.comm.MissingCertificateException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public class ExplorerKeyStore {
    private static final Debug debug = new Debug(ExplorerKeyStore.class);
    private String source;
    private KeyStore ks;
    private X509KeyManager keyManager;

    public ExplorerKeyStore(String source, KeyStore ks, String passphrase) throws GeneralSecurityException {
        this.source = source;
        this.ks = ks;
        this.keyManager = this.initialiseKeyStore(ks, passphrase);
    }

    public X509KeyManager getKeyManager() {
        return this.keyManager;
    }

    private X509KeyManager initialiseKeyStore(KeyStore ks, String kspassPhrase) throws GeneralSecurityException {
        KeyManagerFactory defaultKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        defaultKeyManagerFactory.init(ks, kspassPhrase != null ? kspassPhrase.toCharArray() : null);
        KeyManager[] keyManagerArray = defaultKeyManagerFactory.getKeyManagers();
        int n = keyManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyManager keymanager = keyManagerArray[n2];
            if (keymanager instanceof X509KeyManager) {
                debug.exit("initialiseKeyStore", (Object)keymanager);
                return (X509KeyManager)keymanager;
            }
            ++n2;
        }
        debug.event("initialiseKeyStore", (Object)ks, (Object)KeyManagerFactory.getDefaultAlgorithm(), (Object)defaultKeyManagerFactory.getKeyManagers());
        throw new GeneralSecurityException("No X509 key manager available for " + KeyManagerFactory.getDefaultAlgorithm());
    }

    private static CertificateDetails getCertificateDetails(String alias, Certificate certificate, String certificateSource) {
        if (certificate instanceof X509Certificate) {
            X509Certificate cert = (X509Certificate)certificate;
            String subjectString = cert.getSubjectX500Principal().getName();
            try {
                LdapName subjectName = new LdapName(subjectString);
                subjectString = ExplorerKeyStore.getCn(subjectName);
            }
            catch (InvalidNameException invalidNameException) {}
            String issuerString = cert.getIssuerX500Principal().getName();
            try {
                LdapName issuerName = new LdapName(issuerString);
                issuerString = ExplorerKeyStore.getCn(issuerName);
            }
            catch (InvalidNameException invalidNameException) {}
            Date expiryDate = cert.getNotAfter();
            return new CertificateDetails(subjectString, issuerString, alias, certificateSource, expiryDate);
        }
        return new CertificateDetails("unknown subject", "unknown issuer", alias, certificateSource, null);
    }

    private static String getCn(LdapName name) {
        for (Rdn rdn : name.getRdns()) {
            if (!rdn.getType().equalsIgnoreCase("CN")) continue;
            return rdn.getValue().toString();
        }
        return name.toString();
    }

    public List<CertificateDetails> getKeyStoreCertificates() throws KeyStoreException {
        ArrayList<CertificateDetails> certificates = new ArrayList<CertificateDetails>();
        Enumeration<String> aliases = this.ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate certificate = this.ks.getCertificate(alias);
            if (certificate == null) continue;
            certificates.add(ExplorerKeyStore.getCertificateDetails(alias, certificate, this.source));
        }
        return certificates;
    }

    public X509ExtendedKeyManager getKeyManagerForCertificate(final CertificateDetails details) {
        return new X509ExtendedKeyManager(){

            @Override
            public String[] getServerAliases(String keyType, Principal[] issuers) {
                debug.enter("getServerAliases", (Object)keyType, (Object)issuers);
                String[] resp = ExplorerKeyStore.this.getKeyManager().getServerAliases(keyType, issuers);
                debug.exit("getServerAliases", (Object)resp);
                return resp;
            }

            @Override
            public PrivateKey getPrivateKey(String alias) {
                debug.enter("getPrivateKey", (Object)alias);
                PrivateKey pk = null;
                if (alias.equals(details.getAlias())) {
                    pk = ExplorerKeyStore.this.getKeyManager().getPrivateKey(alias);
                }
                debug.exit("getPrivateKey", pk);
                return pk;
            }

            @Override
            public String[] getClientAliases(String keyType, Principal[] issuers) {
                debug.enter("getClientAliases", (Object)keyType, (Object)issuers);
                String[] resp = ExplorerKeyStore.this.getKeyManager().getClientAliases(keyType, issuers);
                debug.exit("getClientAliases", (Object)resp);
                return resp;
            }

            @Override
            public X509Certificate[] getCertificateChain(String alias) {
                debug.enter("getCertificateChain", (Object)alias, (Object)details.getAlias());
                X509Certificate[] resp = null;
                resp = ExplorerKeyStore.this.getKeyManager().getCertificateChain(alias);
                if (!alias.equals(details.getAlias()) || resp == null) {
                    debug.event("getCertificateChain", "No matching certificate available for alias " + alias + " (available: " + this.printableCertificateAliasList() + ")");
                    throw new MissingCertificateException("No matching certificate available for alias " + alias + " (available: " + this.printableCertificateAliasList() + ")");
                }
                debug.exit("getCertificateChain", (Object)resp);
                return resp;
            }

            @Override
            public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
                debug.enter("chooseServerAlias", (Object)keyType, (Object)issuers);
                String resp = ExplorerKeyStore.this.getKeyManager().chooseServerAlias(keyType, issuers, socket);
                debug.exit("chooseServerAlias", (Object)resp);
                return resp;
            }

            @Override
            public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
                debug.enter("chooseClientAlias", (Object)keyType, (Object)issuers);
                debug.info("chooseClientAlias", new Object[]{"JVM would have chosen the alias: " + ExplorerKeyStore.this.getKeyManager().chooseClientAlias(keyType, issuers, socket), "available aliases: " + this.printableCertificateAliasList()});
                String resp = details.getAlias();
                debug.exit("chooseClientAlias", (Object)resp);
                return resp;
            }

            private String printableCertificateAliasList() {
                String list = "";
                try {
                    for (CertificateDetails certificate : ExplorerKeyStore.this.getKeyStoreCertificates()) {
                        list = String.valueOf(list) + certificate.getAlias() + ", ";
                    }
                }
                catch (KeyStoreException e) {
                    return e.getMessage();
                }
                return list;
            }
        };
    }
}

