/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.Activator;
import com.ibm.cics.core.comm.CertificateDetails;
import com.ibm.cics.core.comm.ExplorerHostnameVerifier;
import com.ibm.cics.core.comm.ExplorerKeyStore;
import com.ibm.cics.core.comm.ExplorerKeyStoreManager;
import com.ibm.cics.core.comm.ExplorerTrustStore;
import com.ibm.cics.core.comm.IPassphraseManager;
import com.ibm.cics.core.comm.SSLProtocolEnablerDecorator;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.Platform;

public class ExplorerSecurityHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ExplorerSecurityHelper.class);
    private static IPassphraseManager passphraseManager;
    private static KeystorePreferencesAdapter preferenceSource;

    static {
        preferenceSource = new KeystorePreferencesAdapter();
    }

    @Deprecated
    public ExplorerSecurityHelper() {
    }

    static void setKeyStorePreferenceSource(KeystorePreferencesAdapter source) {
        preferenceSource = source;
    }

    public static ExplorerTrustStore getTrustStore() throws GeneralSecurityException, IOException {
        return new ExplorerTrustStore(ExplorerSecurityHelper.getFileBasedKeyStore(true));
    }

    public static ExplorerKeyStore getKeyStore(String source) throws GeneralSecurityException, IOException {
        KeyStore ks;
        String passphrase = null;
        if (source.equals("SOURCE_CARD")) {
            Map<String, Provider> p;
            String pin = null;
            if (preferenceSource.isUsePkcs11()) {
                p = ExplorerKeyStoreManager.getPkcs11Provider(preferenceSource.getPkcs11DriverPath());
                pin = ExplorerSecurityHelper.getSmartcardPin();
            } else {
                p = ExplorerKeyStoreManager.getWindowsSmartCardProvider();
            }
            ks = ExplorerKeyStoreManager.getSmartcardKeyStore(p, pin);
        } else {
            ks = ExplorerSecurityHelper.getFileBasedKeyStore(false);
            passphrase = ExplorerSecurityHelper.getCurrentKeyStorePassphrase();
        }
        return new ExplorerKeyStore(source, ks, passphrase);
    }

    private static KeyStore getFileBasedKeyStore(boolean isTrustStoreType) throws GeneralSecurityException, IOException {
        String ksfileString = isTrustStoreType ? ExplorerSecurityHelper.getCurrentTrustStore() : ExplorerSecurityHelper.getCurrentKeyStore();
        String kspassPhrase = isTrustStoreType ? ExplorerSecurityHelper.getCurrentTrustStorePassphrase() : ExplorerSecurityHelper.getCurrentKeyStorePassphrase();
        String ksdbType = isTrustStoreType ? preferenceSource.getTrustStoreType() : preferenceSource.getKeyStoreType();
        KeyStore ks = KeyStore.getInstance(ksdbType);
        ks.load(new FileInputStream(ksfileString), kspassPhrase.toCharArray());
        return ks;
    }

    public static String validateStoreDetail(String tsfileString, String tspassPhrase, String tsdbType, String ksfileString, String kspassPhrase, String ksdbType) {
        return ExplorerKeyStoreManager.validateKeyAndTrustStore(tsfileString, tspassPhrase, tsdbType, ksfileString, kspassPhrase, ksdbType);
    }

    public static String validateTrustStoreDetail() {
        String dbType = preferenceSource.getTrustStoreType();
        String tsfileString = ExplorerSecurityHelper.getCurrentTrustStore();
        String tspassPhrase = ExplorerSecurityHelper.getCurrentTrustStorePassphrase();
        return ExplorerKeyStoreManager.validateCanWriteTrustStore(dbType, tsfileString, tspassPhrase);
    }

    public static String getCurrentTrustStore() {
        return preferenceSource.getTrustStorePath();
    }

    public static String getCurrentTrustStorePassphrase() {
        debug.enter("getCurrentTrustStorePassphrase");
        if (passphraseManager == null) {
            debug.event("getCurrentTrustStorePassphrase", "manager is null");
            return "changeit";
        }
        debug.exit("getCurrentTrustStorePassphrase");
        return passphraseManager.getTrustStorePassphrase();
    }

    public static String getCurrentKeyStore() {
        return preferenceSource.getKeyStorePath();
    }

    public static String getCurrentKeyStorePassphrase() {
        debug.enter("getCurrentKeyStorePassphrase");
        if (passphraseManager == null) {
            debug.event("getCurrentTrustStorePassphrase", "manager is null");
            return "changeit";
        }
        debug.exit("getCurrentKeyStorePassphrase");
        return passphraseManager.getKeyStorePassphrase();
    }

    public static void setPassphraseManager(IPassphraseManager passphraseManager) {
        debug.enter("setPassphraseManager");
        ExplorerSecurityHelper.passphraseManager = passphraseManager;
        debug.exit("setPassphraseManager");
    }

    public static Object[] getSSLContext(String name, String host) throws IOException {
        return ExplorerSecurityHelper.getSSLContext(name, host, null);
    }

    static Object[] getKeyAndTrustManagers(String name, String host, CertificateDetails certificate) throws IOException, GeneralSecurityException {
        Object[] managers = new Object[]{certificate != null ? ExplorerSecurityHelper.getKeyStore(certificate.getSource()).getKeyManagerForCertificate(certificate) : null, preferenceSource.isIgnoreTrustStore() ? new IgnoreTrustManager() : ExplorerKeyStoreManager.getTrustManager(name, host, ExplorerSecurityHelper.getTrustStore())};
        debug.event("getKeyAndTrustManagers", new Object[]{name, host, certificate, managers[0], managers[1]});
        return managers;
    }

    public static Object[] getSSLContext(String name, String host, CertificateDetails certificate) throws IOException {
        try {
            SSLContext sslContext;
            Boolean enableExtraTLSProtocols = false;
            String protocol = preferenceSource.getSecurityProtocol();
            if (StringUtil.hasContent((String)protocol)) {
                sslContext = SSLContext.getInstance(protocol);
            } else {
                try {
                    sslContext = SSLContext.getInstance("TLS");
                    enableExtraTLSProtocols = true;
                }
                catch (NoSuchAlgorithmException e) {
                    debug.warning("initialiseContext", (Object)e);
                    sslContext = SSLContext.getInstance("SSL");
                }
            }
            Object[] managers = ExplorerSecurityHelper.getKeyAndTrustManagers(name, host, certificate);
            sslContext.init(new KeyManager[]{(KeyManager)managers[0]}, new TrustManager[]{(TrustManager)managers[1]}, new SecureRandom());
            debug.event("getSSLContext", ExplorerSecurityHelper.getPrintableEnabledProtocols(sslContext));
            return new Object[]{sslContext, enableExtraTLSProtocols};
        }
        catch (KeyManagementException e) {
            throw new IOException(ExplorerSecurityHelper.createExceptionMessage(e));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(ExplorerSecurityHelper.createExceptionMessage(e));
        }
        catch (GeneralSecurityException e) {
            throw new IOException(ExplorerSecurityHelper.createExceptionMessage(e));
        }
    }

    private static String createExceptionMessage(Exception e) {
        return e.getCause() != null ? String.valueOf(e.toString()) + " (" + e.getCause().getMessage() + ")" : e.toString();
    }

    @Deprecated
    public X509TrustManager getTrustManager() {
        try {
            return preferenceSource.isIgnoreTrustStore() ? new IgnoreTrustManager() : ExplorerKeyStoreManager.getTrustManager(null, null, ExplorerSecurityHelper.getTrustStore());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static SSLContext setUpSSlContextAndInitialiseHostnameVerifier(String name, String host) throws IOException {
        Object[] sslContextArr = ExplorerSecurityHelper.getSSLContext(name, host);
        SSLSocketFactory socketFactory = ExplorerSecurityHelper.getSSLSocketFactory((SSLContext)sslContextArr[0], (Boolean)sslContextArr[1]);
        debug.enter("setUpSSlContextAndInitialiseHostnameVerifier");
        HttpsURLConnection.setDefaultHostnameVerifier(new ExplorerHostnameVerifier());
        HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
        debug.exit("setUpSSlContextAndInitialiseHostnameVerifier", sslContextArr[0]);
        return (SSLContext)sslContextArr[0];
    }

    private static SSLSocketFactory getSSLSocketFactory(SSLContext context, boolean enableExtraTLSProtocols) {
        return new SSLProtocolEnablerDecorator(context.getSocketFactory(), enableExtraTLSProtocols);
    }

    public static SSLSocketFactory getSSLSocketFactory(String name, String host, CertificateDetails certificate) throws IOException {
        Object[] sslContext = ExplorerSecurityHelper.getSSLContext(name, host, certificate);
        return ExplorerSecurityHelper.getSSLSocketFactory((SSLContext)sslContext[0], (Boolean)sslContext[1]);
    }

    public static SSLSocketFactory getSSLSocketFactory(String name, String host) throws IOException {
        Object[] sslContext = ExplorerSecurityHelper.getSSLContext(name, host);
        return ExplorerSecurityHelper.getSSLSocketFactory((SSLContext)sslContext[0], (Boolean)sslContext[1]);
    }

    private static String getPrintableEnabledProtocols(SSLContext sslContext) {
        StringBuffer sb = new StringBuffer();
        sb.append("Enabled protocols in SSLEngine (specified \"" + sslContext.getProtocol() + "\"): [");
        String[] stringArray = sslContext.createSSLEngine().getEnabledProtocols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pro = stringArray[n2];
            sb.append(String.valueOf(pro) + ", ");
            ++n2;
        }
        sb.append("]");
        return sb.toString();
    }

    public static String getSmartcardPin() {
        return passphraseManager.getSmartcardPIN();
    }

    public static void setSmartcardPin(String phrase) {
        passphraseManager.setSmartcardPin(phrase);
    }

    static class IgnoreTrustManager
    extends X509ExtendedTrustManager {
        IgnoreTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        }
    }

    public static class KeystorePreferencesAdapter {
        public String getTrustStoreType() {
            return Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.dbType", "", null);
        }

        public String getTrustStorePath() {
            return Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "javax.net.ssl.trustStore", "", null);
        }

        public String getKeyStoreType() {
            return Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.keystore.dbType", "", null);
        }

        public String getKeyStorePath() {
            return Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "javax.net.ssl.keyStore", "", null);
        }

        public String getSecurityProtocol() {
            return Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.security.protocol", "", null);
        }

        public boolean isIgnoreTrustStore() {
            return Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.ignore", false, null);
        }

        public boolean isUsePkcs11() {
            return Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.usePKCS11Driver", false, null);
        }

        public String getPkcs11DriverPath() {
            return Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.smartcardDriverPath", "", null);
        }
    }
}

