/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm.internal;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ConnectionCategory
implements IConnectionCategory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_ABBREVIATED_NAME = "abbreviatedName";
    private static final String ATT_CONNECTION_TYPE = "connectionType";
    private static final String ATT_ICON_PATH = "icon";
    private IConfigurationElement element;
    private String id;
    private String name;
    private String connectionType;
    private String abbreviatedName;
    private Set<IConnectionDescriptor> connections;
    private Bundle loadingBundle;
    private String iconPath;

    public ConnectionCategory(IConfigurationElement element) {
        this.element = element;
        this.id = element.getAttribute(ATT_ID);
        this.name = element.getAttribute(ATT_NAME);
        this.connectionType = element.getAttribute(ATT_CONNECTION_TYPE);
        this.abbreviatedName = element.getAttribute(ATT_ABBREVIATED_NAME);
        this.iconPath = element.getAttribute(ATT_ICON_PATH);
        IContributor contributor = element.getContributor();
        this.loadingBundle = contributor instanceof RegistryContributor ? FrameworkUtil.getBundle(this.getClass()) : Platform.getBundle((String)contributor.getName());
        this.connections = new HashSet<IConnectionDescriptor>();
    }

    public void addConnection(IConnectionDescriptor connection) {
        this.connections.add(connection);
    }

    @Override
    public IConnectionDescriptor[] getConnections() {
        if (this.connections.isEmpty()) {
            return new IConnectionDescriptor[0];
        }
        return this.connections.toArray(new IConnectionDescriptor[this.connections.size()]);
    }

    @Override
    public String getAbbreviatedName() {
        return this.abbreviatedName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ConnectionCategory[" + this.name + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getConnectionType() {
        return this.connectionType;
    }

    @Override
    public URL getIconPath() {
        if (this.iconPath != null) {
            try {
                if (this.loadingBundle.getSymbolicName().startsWith("com.ibm.cics.core.comm")) {
                    try {
                        Bundle bundle = Platform.getBundle((String)this.element.getNamespace());
                        return bundle.getEntry(this.iconPath);
                    }
                    catch (Exception exception) {
                        return this.loadingBundle.getResource(this.iconPath);
                    }
                }
                return this.loadingBundle.getResource(this.iconPath);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Class<? extends IConnection> getType() throws ClassNotFoundException {
        if (this.loadingBundle.getSymbolicName().startsWith("com.ibm.cics.core.comm")) {
            try {
                Bundle bundle = Platform.getBundle((String)this.element.getNamespace());
                return bundle.loadClass(this.getConnectionType());
            }
            catch (Exception exception) {
                return this.loadingBundle.loadClass(this.getConnectionType());
            }
        }
        return this.loadingBundle.loadClass(this.getConnectionType());
    }
}

