/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.EqualityHelper;
import com.ibm.cics.core.model.ManagedRegionType;
import com.ibm.cics.core.model.ScopedContext;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.sm.comm.IContext;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

abstract class AbstractRegionTypeDeferredWorkbenchAdapter
extends AbstractCPSMDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(AbstractRegionTypeDeferredWorkbenchAdapter.class);
    protected final ICICSRegionGroupDefinition regionType;

    AbstractRegionTypeDeferredWorkbenchAdapter(CloudInput anInput, ICICSRegionGroupDefinition aRegionType) {
        super(anInput);
        this.regionType = aRegionType;
        DEBUG.enter("constructor", (Object)this, (Object)anInput, (Object)aRegionType);
        DEBUG.exit("constructor");
    }

    public Object getParent(Object o) {
        return null;
    }

    public String getLabel(Object o) {
        DEBUG.enter("getLabel", (Object)this, o);
        String result = this.regionType.getRegiontype();
        DEBUG.exit("getLabel", (Object)result);
        return result;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        DEBUG.enter("getImageDescriptor", (Object)this, object);
        ImageDescriptor result = ImageDescriptor.createFromImage((Image)UIPlugin.getTableImage(CICSRegionGroupDefinitionType.getInstance().getResourceTableName()));
        DEBUG.exit("getImageDescriptor", (Object)result);
        return result;
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    @Override
    public String getDecorateText(IDecorationContext decoratorContext) {
        DEBUG.enter("getDecorateText", (Object)this);
        int activeRegionCount = 0;
        int allRegionsCount = 0;
        try {
            ICICSObject[] managedRegions = this.getCPSM().getDefinitions2((ICICSType)ManagedRegionType.getInstance(), (IContext)new ScopedContext(this.getCloudInput().getCICSPlexName(), this.regionType.getName()));
            allRegionsCount = managedRegions.length;
            ICICSObject[] iCICSObjectArray = managedRegions;
            int n = managedRegions.length;
            int n2 = 0;
            while (n2 < n) {
                ICICSObject obj = iCICSObjectArray[n2];
                if (((IManagedRegion)obj).getState() == IManagedRegion.StateValue.ACTIVE) {
                    ++activeRegionCount;
                }
                ++n2;
            }
        }
        catch (CICSSystemManagerException e) {
            DEBUG.error("getDecorateText", (Throwable)e);
        }
        String result = "(" + activeRegionCount + "/" + allRegionsCount + ")";
        DEBUG.exit("getDecorateText", (Object)result);
        return result;
    }

    @Override
    protected String getFetchingName() {
        return NLS.bind((String)CloudMessages.AbstractCPSMDeferredWorkbenchAdapter_management_parts, null);
    }

    public String toString() {
        return "Region Type [" + this.regionType.getRegiontype() + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.regionType == null ? 0 : this.regionType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractRegionTypeDeferredWorkbenchAdapter other = (AbstractRegionTypeDeferredWorkbenchAdapter)obj;
        return !(this.regionType == null ? other.regionType != null : !EqualityHelper.equals((ICICSObject)this.regionType, (ICICSObject)other.regionType));
    }
}

