/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.core.model.CICSRegionDefinitionType;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.PlatformType;
import com.ibm.cics.core.model.RegionType;
import com.ibm.cics.core.model.SystemSystemGroupEntryType;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.actions.AbstractOperationUIDelegate;
import com.ibm.cics.core.ui.decorators.CICSObjectLabelProvider;
import com.ibm.cics.core.ui.internal.cloud.AddExistingRegionToRegionTypeExecutionDelegate;
import com.ibm.cics.core.ui.internal.cloud.AddNewRegionToRegionTypeUIDelegate;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.eclipse.common.ops.IOperationExecutionDelegate;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionDefinition;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IPlatform;
import com.ibm.cics.model.ISystemSystemGroupEntry;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AddExistingRegionToRegionTypeUIDelegate<T>
extends AbstractOperationUIDelegate<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AddNewRegionToRegionTypeUIDelegate.class.getPackage().getName());
    private ICICSRegionGroupDefinition defaultRegionType;
    private Thread loadRegionsThread;
    Label lblRegionTypeValue;
    TableViewer regionsViewer;
    private final IPlatform selectedPlatform;
    private String specificRegionName;
    private boolean isComplete = false;
    private ICICSplex selectedCICSplex;
    private List<String> compatableRegionNames;

    public AddExistingRegionToRegionTypeUIDelegate(IPlatform platform, ICICSRegionGroupDefinition definition, ICICSplex cicsplex) {
        this.selectedPlatform = platform;
        this.defaultRegionType = definition;
        this.selectedCICSplex = cicsplex;
    }

    public ILabelProvider getLabelProvider() {
        return new CICSObjectLabelProvider();
    }

    private void setComplete(boolean complete) {
        this.isComplete = complete;
    }

    public void createControls(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Composite parentParentComposite = parent.getParent();
        GridData parentParentGridData = (GridData)parentParentComposite.getLayoutData();
        parentParentGridData.horizontalAlignment = 4;
        parentParentGridData.verticalAlignment = 4;
        parentParentGridData.grabExcessHorizontalSpace = true;
        parentParentGridData.grabExcessVerticalSpace = true;
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        content.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblTarget = new Label(content, 0);
        lblTarget.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblTarget.setText(NLS.bind((String)CloudMessages.AddExistingRegionToRegionTypeUIDelegate_targetLabel, null));
        Composite labelComposite = new Composite(content, 0);
        labelComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        Label lblRegionTypeImage = new Label(labelComposite, 0);
        lblRegionTypeImage.setImage(UIPlugin.getTableImage(CICSRegionGroupDefinitionType.getInstance().getResourceTableName()));
        this.lblRegionTypeValue = new Label(labelComposite, 0);
        this.lblRegionTypeValue.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblRegionTypeValue.setText(this.defaultRegionType.getRegiontype());
        GridData data = new GridData(4, 4, false, false, 1, 1);
        Label labelTarget = new Label(content, 0);
        labelTarget.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        labelTarget.setText(CloudMessages.AddExistingRegionToRegionTypeUIDelegate_regionsLabel);
        Label labelReplacement = new Label(content, 0);
        labelReplacement.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.regionsViewer = new TableViewer(content, 67584);
        data = new GridData(4, 4, true, true, 2, 1);
        data.widthHint = 150;
        data.heightHint = 150;
        this.regionsViewer.getTable().setLayoutData((Object)data);
        this.regionsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.regionsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (!AddExistingRegionToRegionTypeUIDelegate.this.regionsViewer.getTable().getEnabled()) {
                    return null;
                }
                return UIPlugin.getTableImage(RegionType.getInstance().getResourceTableName());
            }

            public String getText(Object element) {
                return element.toString();
            }
        });
        this.regionsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedElement;
                IStructuredSelection sSelection;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (sSelection = (IStructuredSelection)selection).size() == 1 && (selectedElement = sSelection.getFirstElement()) instanceof String) {
                    AddExistingRegionToRegionTypeUIDelegate.this.specificRegionName = (String)selectedElement;
                    AddExistingRegionToRegionTypeUIDelegate.this.updateControls();
                    return;
                }
            }
        });
        this.regionsViewer.getTable().setEnabled(false);
        this.loadRegions();
    }

    private void updateControls() {
        boolean errorHappens = false;
        errorHappens = this.specificRegionName == null;
        this.setComplete(!errorHappens);
        this.stateChanged();
    }

    private void loadRegions() {
        if (this.regionsViewer.getTable().isDisposed()) {
            return;
        }
        if (this.selectedPlatform == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AddExistingRegionToRegionTypeUIDelegate.this.setRegionTableWaiting();
            }
        });
        if (this.loadRegionsThread != null) {
            try {
                this.loadRegionsThread.join();
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "An InterruptedException caught: " + e.getMessage());
            }
            this.loadRegionsThread = null;
        }
        if (this.loadRegionsThread == null) {
            this.loadRegionsThread = new Thread(){

                @Override
                public void run() {
                    IPrimaryKey key;
                    if (AddExistingRegionToRegionTypeUIDelegate.this.selectedPlatform == null) {
                        return;
                    }
                    ICPSM cpsm = ((ICoreObject)AddExistingRegionToRegionTypeUIDelegate.this.selectedPlatform).getCPSM();
                    ArrayList<String> allRegionNames = new ArrayList<String>();
                    IManagedRegion[] managedRegions = null;
                    if (AddExistingRegionToRegionTypeUIDelegate.this.selectedCICSplex != null) {
                        managedRegions = cpsm.getManagedRegions(AddExistingRegionToRegionTypeUIDelegate.this.selectedCICSplex);
                    }
                    if ((key = (IPrimaryKey)((ICoreObject)AddExistingRegionToRegionTypeUIDelegate.this.selectedPlatform).getAdapter(IPrimaryKey.class)) == null) {
                        AddExistingRegionToRegionTypeUIDelegate.this.reportErrorToRegionViewer(NLS.bind((String)CloudMessages.AddExistingRegionToRegionTypeUIDelegate_getContextFailed, null), null);
                        return;
                    }
                    Context context = new Context(key.getContext());
                    FilteredContext filteredContext = new FilteredContext((IContext)context);
                    boolean regionTypeIsCreated = false;
                    String regionTypeGroupName = null;
                    if (AddExistingRegionToRegionTypeUIDelegate.this.defaultRegionType != null) {
                        regionTypeIsCreated = ICICSRegionGroupDefinition.CreateOriginValue.PLATFORM.equals((Object)AddExistingRegionToRegionTypeUIDelegate.this.defaultRegionType.getCreateOrigin());
                        regionTypeGroupName = AddExistingRegionToRegionTypeUIDelegate.this.defaultRegionType.getGroup();
                    }
                    try {
                        ICICSObject[] fetchedRegions = cpsm.getDefinitions2((ICICSType)CICSRegionDefinitionType.getInstance(), (IContext)filteredContext);
                        ICICSObject[] groupToRegionLinks = cpsm.getDefinitions2((ICICSType)SystemSystemGroupEntryType.getInstance(), (IContext)filteredContext);
                        HashSet<String> regionsInThisRegionType = new HashSet<String>();
                        ICICSObject[] iCICSObjectArray = groupToRegionLinks;
                        int n = groupToRegionLinks.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICICSObject groupToRegionLink = iCICSObjectArray[n2];
                            ISystemSystemGroupEntry link = (ISystemSystemGroupEntry)groupToRegionLink;
                            String group = link.getGroup();
                            if (group.equals(regionTypeGroupName)) {
                                regionsInThisRegionType.add(link.getSystemName());
                            }
                            ++n2;
                        }
                        iCICSObjectArray = fetchedRegions;
                        n = fetchedRegions.length;
                        n2 = 0;
                        while (n2 < n) {
                            block14: {
                                ICICSObject fetchedRegion = iCICSObjectArray[n2];
                                ICICSRegionDefinition region = (ICICSRegionDefinition)fetchedRegion;
                                if (!regionsInThisRegionType.contains(region.getName())) {
                                    if (managedRegions != null) {
                                        int i = 0;
                                        while (i < managedRegions.length) {
                                            if (managedRegions[i].getName().equals(region.getName())) {
                                                if (!managedRegions[i].getState().equals((Object)IManagedRegion.StateValue.ACTIVE)) break;
                                                break block14;
                                            }
                                            ++i;
                                        }
                                    }
                                    boolean regionIsCreated = ICICSRegionDefinition.CreateOriginValue.PLATFORM.equals((Object)region.getCreateOrigin());
                                    if (regionTypeGroupName == null || regionTypeIsCreated == regionIsCreated) {
                                        allRegionNames.add(region.getName());
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (CICSSystemManagerException e) {
                        AddExistingRegionToRegionTypeUIDelegate.this.reportErrorToRegionViewer(e.getLocalizedMessage(), e);
                        return;
                    }
                    AddExistingRegionToRegionTypeUIDelegate.this.compatableRegionNames = allRegionNames;
                    AddExistingRegionToRegionTypeUIDelegate.this.updateRegionsViewerUsingFetchedRegions();
                }
            };
        }
        this.loadRegionsThread.start();
    }

    private void reportErrorToRegionViewer(final String errormessage, Throwable th) {
        Debug.enter((Logger)logger, (String)AddNewRegionToRegionTypeUIDelegate.class.getName(), (String)"reportErrorToRegionViewer", (Object)errormessage, (Object)th);
        Debug.error((Logger)logger, (String)AddNewRegionToRegionTypeUIDelegate.class.getName(), (String)"reportErrorToRegionViewer", (Throwable)th);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AddExistingRegionToRegionTypeUIDelegate.this.regionsViewer.getTable().isDisposed()) {
                    return;
                }
                AddExistingRegionToRegionTypeUIDelegate.this.regionsViewer.setInput((Object)new Object[]{errormessage});
                AddExistingRegionToRegionTypeUIDelegate.this.regionsViewer.getTable().setEnabled(false);
            }
        });
        Debug.exit((Logger)logger, (String)AddNewRegionToRegionTypeUIDelegate.class.getName(), (String)"reportErrorToRegionViewer");
    }

    private void updateRegionsViewerUsingFetchedRegions() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AddExistingRegionToRegionTypeUIDelegate.this.regionsViewer.getTable().isDisposed()) {
                    return;
                }
                if (AddExistingRegionToRegionTypeUIDelegate.this.compatableRegionNames == null || AddExistingRegionToRegionTypeUIDelegate.this.compatableRegionNames.size() == 0) {
                    AddExistingRegionToRegionTypeUIDelegate.this.regionsViewer.setInput((Object)new Object[]{NLS.bind((String)CloudMessages.AddExistingRegionToRegionTypeUIDelegate_noSuitableRegionsFound, null)});
                    AddExistingRegionToRegionTypeUIDelegate.this.regionsViewer.getTable().setEnabled(false);
                    return;
                }
                AddExistingRegionToRegionTypeUIDelegate.this.regionsViewer.getTable().setEnabled(true);
                AddExistingRegionToRegionTypeUIDelegate.this.regionsViewer.setInput((Object)AddExistingRegionToRegionTypeUIDelegate.this.compatableRegionNames);
                AddExistingRegionToRegionTypeUIDelegate.this.updateControls();
            }
        });
    }

    private void setRegionTableWaiting() {
        if (this.regionsViewer.getTable().isDisposed()) {
            return;
        }
        this.regionsViewer.setInput((Object)new Object[]{NLS.bind((String)CloudMessages.AddExistingRegionToRegionTypeUIDelegate_fetching, null)});
        this.regionsViewer.getTable().setEnabled(false);
    }

    public IOperationExecutionDelegate<? super T> getExecutionDelegate() {
        return new AddExistingRegionToRegionTypeExecutionDelegate(this.selectedPlatform, this.defaultRegionType, this.specificRegionName);
    }

    public String getOperationName() {
        return NLS.bind((String)CloudMessages.AddExistingRegionToRegionTypeUIDelegate_addRegionToRegionType, null);
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    static class PlatformComboLabelProvider
    extends LabelProvider {
        PlatformComboLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IPlatform) {
                return UIPlugin.getTableImage(PlatformType.getInstance().getResourceTableName());
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IPlatform) {
                return ((IPlatform)element).getName();
            }
            return element.toString();
        }
    }
}

