/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.ApplicationType;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.AbstractRegionTypeDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.core.ui.internal.cloud.ManagedRegionDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.ManagementPartDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.PlatformRegionTypeDeferredWorkbenchAdapter;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IManagementPart;
import com.ibm.cics.model.IPlatform;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;

public class CloudLabelDecorator
extends LabelDecorator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(CloudLabelDecorator.class);
    private Map<Image, Image> map = new HashMap<Image, Image>();
    private TreeViewer treeViewer;

    public CloudLabelDecorator(TreeViewer aTreeViewer) {
        this.treeViewer = aTreeViewer;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image decorateImage(Image image, Object element) {
        return null;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    public Image decorateImage(Image image, Object element, IDecorationContext context) {
        DEBUG.enter("decorateImage", (Object)this, (Object)image, element, (Object)context);
        Image imageResponse = null;
        if ((element instanceof ICICSRegionGroupDefinition || element instanceof AbstractRegionTypeDeferredWorkbenchAdapter) && (imageResponse = this.map.get(image)) == null) {
            DecorationOverlayIcon overlay = new DecorationOverlayIcon(image, UIPlugin.IMGD_CSYSGRP_PLATFROM, 3);
            imageResponse = overlay.createImage();
            this.map.put(image, imageResponse);
        }
        DEBUG.exit("decorateImage", (Object)imageResponse);
        return imageResponse;
    }

    public String decorateText(String text, Object element, IDecorationContext context) {
        Object input;
        DEBUG.enter("decorateText", (Object)this, (Object)text, element, (Object)context);
        String decoration = "";
        if (element instanceof AbstractCPSMDeferredWorkbenchAdapter) {
            AbstractCPSMDeferredWorkbenchAdapter adapter = (AbstractCPSMDeferredWorkbenchAdapter)element;
            decoration = adapter.getDecorateText(context);
        } else if (element instanceof IPlatform) {
            decoration = String.valueOf(((IPlatform)element).getStatus().toString()) + "," + ((IPlatform)element).getEnablestatus().toString();
        } else if (element instanceof IApplication) {
            boolean enablementSupported;
            StringBuilder decorationBuilder = new StringBuilder();
            IApplication application = (IApplication)element;
            IApplication.AvailabilityValue availability = application.getAvailability();
            IApplication.EnableStatusValue enableStatus = application.getEnableStatus();
            boolean bl = enablementSupported = !((IApplication.EnableStatusValue)ApplicationType.ENABLE_STATUS.getUnsupportedValue()).equals((Object)enableStatus);
            if (enablementSupported) {
                decorationBuilder.append(enableStatus.toString());
            }
            if (!((IApplication.AvailabilityValue)ApplicationType.AVAILABILITY.getUnsupportedValue()).equals((Object)availability)) {
                if (enablementSupported) {
                    decorationBuilder.append(",");
                }
                String availabilityString = availability.equals((Object)IApplication.AvailabilityValue.NONE) ? "NO ENTRY POINTS" : availability.toString();
                decorationBuilder.append(availabilityString);
            }
            decoration = decorationBuilder.toString();
        } else if (element instanceof ICICSRegionGroupDefinition) {
            input = this.treeViewer.getInput();
            if (input instanceof CloudInput) {
                PlatformRegionTypeDeferredWorkbenchAdapter rdwa = new PlatformRegionTypeDeferredWorkbenchAdapter((CloudInput)this.treeViewer.getInput(), (ICICSRegionGroupDefinition)element);
                decoration = ((AbstractRegionTypeDeferredWorkbenchAdapter)rdwa).getDecorateText(context);
            } else if (input instanceof AbstractCPSMDeferredWorkbenchAdapter) {
                PlatformRegionTypeDeferredWorkbenchAdapter rdwa = new PlatformRegionTypeDeferredWorkbenchAdapter(((AbstractCPSMDeferredWorkbenchAdapter)input).getCloudInput(), (ICICSRegionGroupDefinition)element);
                decoration = ((AbstractRegionTypeDeferredWorkbenchAdapter)rdwa).getDecorateText(context);
            }
        } else if (element instanceof IManagementPart) {
            input = this.treeViewer.getInput();
            ManagementPartDeferredWorkbenchAdapter adapter = null;
            if (input instanceof CloudInput) {
                adapter = new ManagementPartDeferredWorkbenchAdapter((CloudInput)this.treeViewer.getInput(), (IManagementPart)element);
            } else if (input instanceof AbstractCPSMDeferredWorkbenchAdapter) {
                adapter = new ManagementPartDeferredWorkbenchAdapter(((AbstractCPSMDeferredWorkbenchAdapter)input).getCloudInput(), (IManagementPart)element);
            }
            if (adapter != null) {
                decoration = adapter.getDecorateText(context);
            }
        } else if (element instanceof IManagedRegion) {
            input = this.treeViewer.getInput();
            ManagedRegionDeferredWorkbenchAdapter adapter = null;
            if (input instanceof CloudInput) {
                adapter = new ManagedRegionDeferredWorkbenchAdapter((CloudInput)this.treeViewer.getInput(), (IManagedRegion)element);
            } else if (input instanceof AbstractCPSMDeferredWorkbenchAdapter) {
                adapter = new ManagedRegionDeferredWorkbenchAdapter(((AbstractCPSMDeferredWorkbenchAdapter)input).getCloudInput(), (IManagedRegion)element);
            }
            if (adapter != null) {
                decoration = adapter.getDecorateText(context);
            }
        } else if (element instanceof ErrorWrapper) {
            decoration = ((ErrorWrapper)element).getException().getLocalizedMessage();
        }
        String response = String.valueOf(text) + " " + decoration;
        DEBUG.exit("decorateText", (Object)response);
        return response;
    }

    public boolean prepareDecoration(Object element, String originalText, IDecorationContext context) {
        return true;
    }

    public void dispose() {
        DEBUG.enter("dispose", (Object)this);
        for (Image image : this.map.values()) {
            if (image == null || image.isDisposed()) continue;
            DEBUG.event("dispose", (Object)"image", (Object)image);
            image.dispose();
        }
        DEBUG.exit("dispose");
    }
}

