/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.perspectives;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.perspectives.AdminPerspective;
import com.ibm.cics.explorer.tables.TablesPlugin;
import com.ibm.cics.explorer.tables.internal.ViewBuilder;
import com.ibm.cics.explorer.tables.model.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractSMPerspective
implements IPerspectiveFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AbstractSMPerspective.class.getPackage().getName());
    public static final String TOPOLOGY_FOLDER_ID = "left";
    public static final String RESOURCES_FOLDER_ID = "centre";
    public static final String RESGROUP_FOLDER_ID = "resgroupFolder";
    public static final String EVENTS_FOLDER_ID = "bottom";
    protected IFolderLayout topologyFolder;
    protected IFolderLayout resourcesFolder;
    protected IFolderLayout eventsFolder;
    protected IPlaceholderFolderLayout resgroupFolder;
    protected List<String> viewsAdded = new ArrayList<String>();

    public void createInitialLayout(IPageLayout layout) {
        Debug.enter((Logger)logger, (String)AbstractSMPerspective.class.getName(), (String)"createInitialLayout", (Object)layout);
        boolean showEditorArea = false;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            IEditorPart activeEditor = activePage.getActiveEditor();
            Debug.event((Logger)logger, (String)AdminPerspective.class.getName(), (String)"createInitialLayout", (Object)activeEditor);
            if (activeEditor != null) {
                showEditorArea = true;
            }
        }
        layout.setEditorAreaVisible(showEditorArea);
        String editorArea = layout.getEditorArea();
        this.topologyFolder = layout.createFolder(TOPOLOGY_FOLDER_ID, 1, 0.22f, editorArea);
        this.resourcesFolder = layout.createFolder(RESOURCES_FOLDER_ID, 1, 0.44f, editorArea);
        this.resgroupFolder = layout.createPlaceholderFolder(RESGROUP_FOLDER_ID, 4, 0.5f, TOPOLOGY_FOLDER_ID);
        this.eventsFolder = layout.createFolder(EVENTS_FOLDER_ID, 4, 0.66f, RESOURCES_FOLDER_ID);
        this.addPlaceHolder(this.resgroupFolder, "com.ibm.cics.sm.ui.views.resourceGroupDefinitions");
        this.addPlaceHolder(this.resgroupFolder, "com.ibm.cics.sm.ui.views.resourceDescriptionDefinitions");
        this.addPlaceHolder(this.resgroupFolder, "com.ibm.cics.core.ui.internal.cloud.explorer");
        this.addView(this.eventsFolder, "org.eclipse.ui.views.PropertySheet");
        this.addView(this.eventsFolder, "org.eclipse.pde.runtime.LogView");
        this.addPlaceHolder((IPlaceholderFolderLayout)this.eventsFolder, "org.eclipse.ui.console.ConsoleView");
        Debug.exit((Logger)logger, (String)AdminPerspective.class.getName(), (String)"createInitialLayout");
    }

    protected void addTableView(IFolderLayout folderLayout, String tableId) {
        this.addView(folderLayout, ViewBuilder.getViewIdForTableId((String)tableId));
    }

    protected void addTablePlaceHolder(IPlaceholderFolderLayout folderLayout, String tableId) {
        this.addPlaceHolder(folderLayout, ViewBuilder.getViewIdForTableId((String)tableId));
    }

    protected void addView(IFolderLayout folderLayout, String viewId) {
        folderLayout.addView(viewId);
        this.viewsAdded.add(viewId);
    }

    protected void addPlaceHolder(IPlaceholderFolderLayout folderLayout, String viewId) {
        folderLayout.addPlaceholder(viewId);
        this.viewsAdded.add(viewId);
    }

    protected void addRemainingResourceViewPlaceholders() {
        IObservableList tables = TablesPlugin.getDefault().getDefaultRegistry().getTables();
        for (Table table : tables) {
            String viewId = ViewBuilder.getViewIdForTable((Table)table);
            if (this.viewsAdded.contains(viewId)) continue;
            this.addPlaceHolder((IPlaceholderFolderLayout)this.resourcesFolder, viewId);
        }
    }
}

