/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.model.CICSRelease;
import com.ibm.cics.model.IRepository;
import com.ibm.cics.sm.comm.AbstractCICSAction;
import com.ibm.cics.sm.comm.AbstractFilteredContext;
import com.ibm.cics.sm.comm.AbstractSystemManagerConnection;
import com.ibm.cics.sm.comm.Context;
import com.ibm.cics.sm.comm.ContextHelper;
import com.ibm.cics.sm.comm.ErrorCodes;
import com.ibm.cics.sm.comm.ICICSAction;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IDefinitionContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IMutableSMConnectionRecord;
import com.ibm.cics.sm.comm.IParameterisedContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.IResourceTables;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import com.ibm.cics.sm.comm.ISystemManagerConnection2;
import com.ibm.cics.sm.comm.ISystemManagerResponseValues;
import com.ibm.cics.sm.comm.InstallException;
import com.ibm.cics.sm.comm.InvalidFilterException;
import com.ibm.cics.sm.comm.RepositoryDiscoverer;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.ScopedContext;
import com.ibm.cics.sm.comm.SystemManagerActions;
import com.ibm.cics.sm.comm.SystemManagerAuthenticationException;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.TypeNotFoundException;
import com.ibm.cics.sm.comm.WarningCountExceededException;
import com.ibm.cics.sm.comm.actions.InstallAction;
import com.ibm.cics.sm.comm.context.IAssociationContext;
import com.ibm.cics.sm.comm.context.IGroupContext;
import com.ibm.cics.sm.comm.sm.Activator;
import com.ibm.cics.sm.comm.sm.DebugOptions;
import com.ibm.cics.sm.comm.sm.IModelNames;
import com.ibm.cics.sm.comm.sm.SMConnectionCreateException;
import com.ibm.cics.sm.comm.sm.SMConnectionException;
import com.ibm.cics.sm.comm.sm.SMResponse;
import com.ibm.cics.sm.comm.sm.internal.ComplexFilterOperatorRule;
import com.ibm.cics.sm.comm.sm.internal.GetCapableRule;
import com.ibm.cics.sm.comm.sm.internal.IOperationRule;
import com.ibm.cics.sm.comm.sm.internal.Messages;
import com.ibm.cics.sm.comm.sm.internal.OrderedGetRule;
import com.ibm.cics.sm.comm.sm.internal.RequestBuilder;
import com.ibm.cics.sm.comm.sm.internal.ResourceAvailableRule;
import com.ibm.cics.sm.comm.sm.internal.SMResponseHandler;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SMCPSMConnection
extends AbstractSystemManagerConnection
implements ISystemManagerConnection2,
IModelNames,
IResourceTables,
ISystemManagerResponseValues {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String USER_AGENT_PROPERTY = "User-Agent";
    private static final String USER_AGENT;
    private static final String CMAS_ATTRIBUTE_SYSID = "SYSID";
    private static final String CMAS_ATTRIBUTE_CPSMVER = "CPSMVER";
    public static final String FILE = "/CICSSystemManagement/";
    public static final String DATA_ENCODING_CHARSET = "UTF-8";
    public static final String PROPERTY_DEFAULTWARNCNT = "com.ibm.cics.sm.comm.DEFAULTWARNINGCOUNT";
    public static final String DEFAULT_WARNINGCOUNT = "700";
    private static final String CICS_RESOURCE_SCHEMA_PATTERN_TEMPLATE = "http://[^/]*/CICSSystemManagement/schema/(CICS[A-Za-z0-9]+)\\.xsd";
    private static final String CICS_SECURE_RESOURCE_SCHEMA_PATTERN_TEMPLATE = "https://[^/]*/CICSSystemManagement/schema/(CICS[A-Za-z0-9]+)\\.xsd";
    private static final String SCHEMA_LOCATION = "schemaLocation";
    private static final String XSD_INCLUDE = "xsd:include";
    boolean connected;
    private String currentLtpaToken;
    protected Map<String, SMResponse> stubs = new HashMap<String, SMResponse>();
    private String cmasName;
    private String version;
    protected int readTimeout = 120000;
    private static final Debug debug;
    private final List<String> supportedResources = new ArrayList<String>(0);
    private String lastUrl;
    private final ComplexFilterOperatorRule complexFilterOperatorRule = new ComplexFilterOperatorRule();

    static {
        debug = new Debug(SMCPSMConnection.class);
        USER_AGENT = Activator.getUserAgentString();
    }

    public SMCPSMConnection() {
        super(true);
        debug.event("<init>", (Object)this);
    }

    public void setConfiguration(ConnectionConfiguration connectionConfiguration) {
        super.setConfiguration(connectionConfiguration);
        if (connectionConfiguration != null) {
            String readTimeoutStr = connectionConfiguration.getExtendedAttribute("READ_TIMEOUT");
            try {
                this.readTimeout = Integer.parseInt(readTimeoutStr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        debug.event("setConfiguration", (Object)this, (Object)connectionConfiguration);
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection connection = super.openConnection(url);
        connection.setReadTimeout(this.readTimeout);
        connection.setConnectTimeout(this.readTimeout);
        return connection;
    }

    public String getActions(String resourceType, IContext context) {
        debug.enter("getActions", (Object)this, (Object)resourceType, (Object)context);
        String actions = String.valueOf(super.getActions(resourceType, context)) + "," + "update";
        if (IResourceTables.Helper.isCICSDefinition((String)resourceType) || IResourceTables.Helper.isCICSResource((String)resourceType)) {
            actions = String.valueOf(actions) + ",delete,perform";
        }
        if (IResourceTables.Helper.isCPSMManager((String)resourceType)) {
            actions = String.valueOf(actions) + ",delete,perform";
        } else if (IResourceTables.Helper.isCPSMDefinition((String)resourceType)) {
            actions = String.valueOf(actions) + ",create,install,delete";
        } else if (resourceType.equals("CSDGROUP") || resourceType.equals("CSDLIST")) {
            actions = String.valueOf(actions) + ",install,perform";
        }
        if (resourceType.equals("CSDGROUP")) {
            actions = String.valueOf(actions) + ",delete";
        }
        if (IResourceTables.Helper.isCICSDefinition((String)resourceType)) {
            actions = String.valueOf(actions) + ",create,remove,install";
        }
        if (resourceType.equalsIgnoreCase("MAS")) {
            actions = String.valueOf(actions) + ",EventProcessing";
        }
        if (resourceType.equals("CSDGROUP") || resourceType.equals("RESGROUP")) {
            actions = String.valueOf(actions) + ",remove,perform";
        }
        if (resourceType.equals("CPLEXDEF")) {
            actions = String.valueOf(actions) + ",delete,create";
        }
        if (resourceType.equals("CMTCMDEF")) {
            actions = String.valueOf(actions) + ",delete,create";
        }
        if (resourceType.equals("CSYSDEF") || resourceType.equals("CSYSGRP")) {
            actions = String.valueOf(actions) + ",perform";
        }
        debug.exit("getActions", (Object)actions);
        return actions;
    }

    protected boolean checkRules(String resourceType, IContext context, ICICSOperation operation, IOperationRule ... rules) {
        IOperationRule[] iOperationRuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            IOperationRule rule = iOperationRuleArray[n2];
            if (rule.matches(resourceType, context, operation) && !rule.passes(resourceType, context, operation)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean checkOperation(String resourceType, IContext context, ICICSOperation operation) {
        boolean supported;
        debug.enter("checkOperation", (Object)this, (Object)resourceType, (Object)context, (Object)operation);
        String actions = this.getActions(resourceType, context);
        switch (operation.getOperationType()) {
            case CREATE: {
                boolean bl = supported = actions.indexOf("create") != -1;
                if (!supported || !IResourceTables.Helper.isCPSMDefinition((String)resourceType)) break;
                supported = !this.isScopedContext(context);
                break;
            }
            case GET: {
                supported = this.checkRules(resourceType, context, operation, new GetCapableRule(actions), new OrderedGetRule(this.getCPSMRelease()), new ResourceAvailableRule(this.supportedResources), this.complexFilterOperatorRule);
                break;
            }
            case UPDATE: {
                supported = actions.indexOf("update") != -1;
                break;
            }
            case DELETE: {
                supported = actions.indexOf("delete") != -1;
                break;
            }
            case PERFORM: {
                if (operation instanceof ICICSAction) {
                    ICICSAction action = (ICICSAction)operation;
                    if (action.getActionName().equals("INSTALL")) {
                        IScopedContext target;
                        boolean bl = supported = actions.indexOf("install") != -1;
                        if (!supported || !(operation instanceof InstallAction) || (!(supported = (target = ((InstallAction)operation).getTarget()).getContext().equals(context.getContext())) || !IResourceTables.Helper.isCICSDefinition((String)resourceType)) && !IResourceTables.Helper.isCSDDefinition((String)resourceType) || !this.isScopedContext(context)) break;
                        String scope = this.getScopeFor(context);
                        supported = target.getScope().equals(scope);
                        break;
                    }
                    if (action.getActionName().equals("REMOVE")) {
                        if (actions.indexOf("remove") != -1) {
                            if (IResourceTables.Helper.isCICSDefinition((String)resourceType)) {
                                supported = !this.isScopedContext(context);
                                break;
                            }
                            if ("RESGROUP".equals(resourceType) && context instanceof IAssociationContext) {
                                supported = "RESDESC".equals(((IAssociationContext)context).getResourceType());
                                break;
                            }
                            if ("CSDGROUP".equals(resourceType) && context instanceof IAssociationContext) {
                                supported = "CSDLIST".equals(((IAssociationContext)context).getResourceType());
                                break;
                            }
                            supported = false;
                            break;
                        }
                        supported = false;
                        break;
                    }
                    if (action.getActionName().equals("EVENT_PROCESSING")) {
                        supported = actions.indexOf("EventProcessing") != -1;
                        break;
                    }
                    if (action.getActionName().equals("CSDCOPY")) {
                        supported = actions.indexOf("perform") != -1 && this.isScopedContext(context);
                        break;
                    }
                    if (action.getActionName().equals("CSDADD")) {
                        supported = actions.indexOf("perform") != -1 && this.isScopedContext(context) && resourceType.equals("CSDGROUP");
                        break;
                    }
                    if (action instanceof SystemManagerActions.AddToResourceDescriptionAction) {
                        supported = actions.indexOf("perform") != -1 && resourceType.equals("RESGROUP");
                        break;
                    }
                    if (action instanceof SystemManagerActions.CSDAddAction) {
                        supported = actions.indexOf("perform") != -1 && resourceType.equals("CSDGROUP");
                        break;
                    }
                    boolean bl = supported = actions.indexOf("perform") != -1;
                    if (!supported || !IResourceTables.Helper.isCICSDefinition((String)resourceType)) break;
                    supported = !this.isScopedContext(context);
                    break;
                }
                supported = actions.indexOf("perform") != -1;
                break;
            }
            default: {
                supported = false;
            }
        }
        debug.exit("checkOperation", (Object)supported);
        return supported;
    }

    protected final boolean isScopedContext(IContext context) {
        return this.getScopeFor(context) != null;
    }

    protected final String getScopeFor(IContext context) {
        String scope;
        if (context instanceof IScopedContext) {
            IScopedContext scopedContext = (IScopedContext)context;
            scope = scopedContext.getScope();
        } else {
            scope = null;
        }
        return scope;
    }

    protected CICSRelease getCPSMRelease() {
        return CICSRelease.fromVersion((String)this.getVersion());
    }

    public void connect() throws ConnectionException {
        debug.enter("connect", (Object)this, (Object)this.getConfiguration().getHost(), (Object)this.getConfiguration().getPort(), (Object)this.getConfiguration().getUserID());
        SMConnectionRecord cmasRecord = this.getCMASRecord();
        this.cmasName = cmasRecord.get(CMAS_ATTRIBUTE_SYSID);
        String cpsmver = cmasRecord.get(CMAS_ATTRIBUTE_CPSMVER);
        this.version = SMCPSMConnection.formatVersionAsCICSTSLevel((String)cpsmver);
        this.connected = true;
        this.checkVersion();
        this.getSupportedResources();
        debug.exit("connect", (Object)("connected=" + Boolean.toString(this.connected) + " version=" + this.version));
    }

    protected void checkVersion() throws ConnectionException {
        CICSRelease release = CICSRelease.fromVersion((String)this.getVersion());
        if (!this.isCICSVersionSupported(release)) {
            this.disconnect();
            throw new SystemManagerConnectionException(Messages.SMConnection_unsupportedCICSRelease);
        }
    }

    protected void getSupportedResources() throws ConnectionException {
        block15: {
            if (DebugOptions.DEBUG_SCHEMA) {
                debug.enter("getSupportedTables", (Object)this);
            }
            this.clearSupportedResources();
            HttpURLConnection connection = null;
            try {
                try {
                    URL url = this.createURL("/CICSSystemManagement/schema/CICSSystemManagement.xsd");
                    this.lastUrl = url.toString();
                    if (DebugOptions.DEBUG_SCHEMA) {
                        debug.event("get", (Object)url);
                    }
                    connection = this.tryConnection(url, "GET");
                    int responseCode = connection.getResponseCode();
                    debug.event("get", (Object)connection.getResponseCode(), (Object)connection.getResponseMessage(), (Object)connection.getContentType());
                    if (responseCode == 200) {
                        String contentType = connection.getContentType();
                        if (contentType.startsWith("text/html")) {
                            throw new SystemManagerConnectionException(contentType);
                        }
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        InputStream stream = connection.getInputStream();
                        Document document = documentBuilder.parse(stream);
                        NodeList childNodes = document.getDocumentElement().getChildNodes();
                        String patternTemplate = this.isSecure() ? CICS_SECURE_RESOURCE_SCHEMA_PATTERN_TEMPLATE : CICS_RESOURCE_SCHEMA_PATTERN_TEMPLATE;
                        String myPattern = String.format(patternTemplate, this.getConfiguration().getHost(), this.getConfiguration().getPort());
                        Pattern p = Pattern.compile(myPattern);
                        int i = 0;
                        while (i < childNodes.getLength()) {
                            String schemaLocation;
                            Matcher m;
                            Element element;
                            Node n = childNodes.item(i);
                            if (n.getNodeType() == 1 && (element = (Element)n).getTagName().equals(XSD_INCLUDE) && (m = p.matcher(schemaLocation = element.getAttribute(SCHEMA_LOCATION))).matches()) {
                                String resource = m.group(1);
                                if (DebugOptions.DEBUG_SCHEMA) {
                                    debug.event("Found supported resource", resource);
                                }
                                this.addSupportedResource(resource);
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception ex) {
                    debug.event("getSupportedResources exception", (Object)ex);
                    this.closeConnection(connection);
                    if (DebugOptions.DEBUG_SCHEMA) {
                        debug.exit("getSupportedTables");
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(connection);
                if (DebugOptions.DEBUG_SCHEMA) {
                    debug.exit("getSupportedTables");
                }
                throw throwable;
            }
            this.closeConnection(connection);
            if (DebugOptions.DEBUG_SCHEMA) {
                debug.exit("getSupportedTables");
            }
        }
    }

    private SMConnectionRecord getCMASRecord() throws ConnectionException {
        SMResponse response = this.getResources("CMAS", IContext.NULL_CONTEXT);
        if (response.getRecordCount() > 0) {
            return response.getRecord(0);
        }
        throw new SystemManagerConnectionException("Missing CMAS Record ");
    }

    public void disconnect() throws ConnectionException {
        debug.enter("disconnect", (Object)this);
        this.discardAll();
        this.connected = false;
        debug.exit("disconnect", (Object)Boolean.toString(this.connected));
    }

    public boolean isConnected() {
        return this.connected;
    }

    private void discardAll() {
        debug.enter("discardAll", (Object)this, this.stubs);
        Iterator<String> iterator = new ArrayList<String>(this.stubs.keySet()).iterator();
        while (iterator.hasNext()) {
            String string;
            String stub = string = iterator.next();
            try {
                this.discard(stub);
            }
            catch (ConnectionException ex) {
                debug.warning("discardAll", stub, (Throwable)ex);
            }
        }
        debug.exit("discardAll");
    }

    public String getServerApplID() {
        return this.cmasName;
    }

    public String getVersion() {
        return this.version;
    }

    public SMResponse create(String resourceType, IContext context, SMConnectionRecord record) throws ConnectionException {
        SMResponse smResponse;
        debug.enter("create", (Object)this, (Object)resourceType, (Object)context, (Object)record);
        HttpURLConnection connection = null;
        String modelName = IModelNames.ModelNamesHelper.getModelName(resourceType);
        try {
            try {
                String request = RequestBuilder.buildCREATERequest(context);
                URL url = this.createURL(FILE + modelName + request);
                debug.event("create", (Object)url);
                String payload = this.buildCreatePayload(resourceType, context, (IMutableSMConnectionRecord)record);
                connection = this.tryConnection(url, "POST", payload);
                int responseCode = connection.getResponseCode();
                debug.event("create", new Object[]{String.valueOf(connection.getResponseCode()), connection.getResponseMessage()});
                if (responseCode != 200) {
                    throw new SMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
                }
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                SMResponseHandler handler = new SMResponseHandler(resourceType, modelName, context, connection.getInputStream(), connection.getURL());
                parser.parse(handler.getInputStream(), (DefaultHandler)handler);
                smResponse = handler.getResponse();
            }
            catch (IOException ex) {
                debug.warning("create", (Object)ex);
                throw new SMConnectionException(ex);
            }
            catch (ParserConfigurationException ex) {
                debug.warning("create", (Object)ex);
                throw new SMConnectionException(ex);
            }
            catch (SAXException ex) {
                debug.warning("create", (Object)ex);
                throw new SMConnectionException(ex);
            }
        }
        catch (Throwable throwable) {
            this.closeConnection(connection);
            throw throwable;
        }
        this.closeConnection(connection);
        debug.exit("create", (Object)smResponse);
        return smResponse;
    }

    private String escapeXmlPayload(String xmlPayload) {
        return xmlPayload.replace("\"", "&quot;");
    }

    private String buildCreatePayload(String resourceType, IContext context, IMutableSMConnectionRecord mutableRecord) throws ConnectionException {
        IDefinitionContext definitionContext;
        String resourceGroup;
        String payload = "<request><create>";
        String csdGroupName = null;
        if (IResourceTables.Helper.isCICSDefinition((String)resourceType) && context instanceof IDefinitionContext && (resourceGroup = (definitionContext = (IDefinitionContext)context).getResourceGroup()) != null && resourceGroup.trim().length() > 0) {
            if (definitionContext instanceof IGroupContext && ((IGroupContext)definitionContext).getParentContext() instanceof IScopedContext) {
                csdGroupName = resourceGroup;
                payload = String.valueOf(payload) + "<parameter name=\"CSD\"/>";
            } else {
                payload = String.valueOf(payload) + "<parameter name=\"RESGROUP\" value=\"" + this.escapeXmlPayload(definitionContext.getResourceGroup()) + "\"/>";
            }
        }
        if (context instanceof IParameterisedContext) {
            payload = this.appendParameters((IParameterisedContext)context, payload);
        }
        payload = String.valueOf(payload) + "<attributes";
        for (String name : mutableRecord) {
            String value = mutableRecord.get(name);
            if ("DEFVER".equals(name) && "0".equals(value)) {
                if (csdGroupName != null) continue;
                value = this.getNextAvailableVersion(resourceType, context, mutableRecord.get("NAME"));
            }
            payload = String.valueOf(payload) + " " + this.escapeXmlPayload(name) + "=" + "\"" + this.escapeXmlPayload(value) + "\"";
        }
        if (csdGroupName != null) {
            payload = String.valueOf(payload) + " csdgroup=\"" + this.escapeXmlPayload(csdGroupName) + "\"";
        }
        payload = String.valueOf(payload) + "/></create></request>";
        return payload;
    }

    private String appendParameters(IParameterisedContext parameterisedContext, String payload) {
        for (String name : parameterisedContext.getParameterNames()) {
            String value = parameterisedContext.getParameterValue(name);
            payload = String.valueOf(payload) + "<parameter name=\"" + this.escapeXmlPayload(name) + "\" ";
            if (value != null) {
                payload = String.valueOf(payload) + "value=\"" + this.escapeXmlPayload(value) + "\"";
            }
            payload = String.valueOf(payload) + "/>";
        }
        return payload;
    }

    private void setAuthorization(HttpURLConnection connection) {
        if (this.currentLtpaToken != null) {
            debug.event("setAuthorization", this.currentLtpaToken);
            connection.setRequestProperty("Cookie", this.currentLtpaToken);
        } else if (this.getConfiguration().getCertificateDetails() == null) {
            String base64String;
            byte[] credentialsBytes;
            String property = String.valueOf(this.getConfiguration().getUserID()) + ":" + this.getConfiguration().getPassword();
            try {
                credentialsBytes = property.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException ex) {
                String defaultEncoding = System.getProperty("file.encoding");
                debug.warning("setAuthorization", "Couldn't decode header as ISO-8859-1, attempting to use default encoding: " + defaultEncoding, (Throwable)ex);
                credentialsBytes = property.getBytes();
            }
            byte[] base64Bytes = Base64.encodeBase64((byte[])credentialsBytes, (boolean)false);
            try {
                base64String = new String(base64Bytes, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException ex) {
                String defaultEncoding = System.getProperty("file.encoding");
                debug.warning("setAuthorization", "Couldn't encode header as ISO-8859-1, attempting to use default encoding: " + defaultEncoding, (Throwable)ex);
                base64String = new String(base64Bytes);
            }
            debug.event("setAuthorization", (Object)this, (Object)"Authorization", (Object)this.getConfiguration().getUserID());
            connection.setRequestProperty("Authorization", "Basic " + base64String);
            Authenticator.setDefault(null);
        }
    }

    private String getNextAvailableVersion(String resourceType, final IContext context, String name) throws ConnectionException {
        debug.enter("getNextAvailableVersion", (Object)this, (Object)resourceType, (Object)context, (Object)name);
        String version = null;
        final HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("NAME", name);
        IFilteredContext filteredContext = new IFilteredContext(){

            public String getContext() {
                return this.getParentContext().getContext();
            }

            public String getScope() {
                return null;
            }

            public IContext getParentContext() {
                return new IContext(){

                    public String getContext() {
                        return context.getContext();
                    }
                };
            }

            public String getAttributeValue(String attributeName) {
                return (String)attributes.get(attributeName);
            }

            public Set<String> getAttributeNames() {
                return attributes.keySet();
            }

            public String toString() {
                return String.valueOf(this.getClass().getName()) + "[" + this.getContext() + "/" + attributes + "]";
            }
        };
        debug.event("getNextAvailableVersion", (Object)filteredContext);
        SMResponse response = this.getResources(resourceType, (IContext)filteredContext);
        int index = 0;
        if (response.getRecordCount() < 15) {
            int i = 1;
            while (i <= 15 && version == null) {
                if (index < response.getRecordTotal()) {
                    SMConnectionRecord record = response.getRecord(index);
                    int usedVersion = Integer.valueOf(record.get("DEFVER"));
                    if (usedVersion != i) {
                        version = String.valueOf(i);
                    } else {
                        ++index;
                    }
                } else {
                    version = String.valueOf(i);
                }
                ++i;
            }
        } else {
            throw new SMConnectionCreateException("NAME");
        }
        debug.exit("getNextAvailableVersion", version);
        return version;
    }

    public String getLastUrl() {
        return this.lastUrl;
    }

    public final SMResponse get(String resourceType, IContext context) throws ConnectionException {
        return this.get(resourceType, context, true);
    }

    private final SMResponse get(String resourceType, IContext context, boolean useCache) throws ConnectionException {
        SMResponse response = SMCPSMConnection.isCSDGroupsInList(resourceType, context) ? this.getCSDGroupsInList(context) : this.doGet(resourceType, context, useCache);
        if (useCache) {
            this.stubs.put(response.getStub(), response);
        }
        return response;
    }

    private static boolean isCSDGroupsInList(String resourceType, IContext context) {
        return "CSDGROUP".equals(resourceType) && ContextHelper.getContextFrom((IContext)context, IAssociationContext.class) != null;
    }

    private SMResponse getCSDGroupsInList(IContext context) throws ConnectionException {
        SMResponse groups = this.doGet("CSDGROUP", context, false);
        IAssociationContext associationContext = (IAssociationContext)ContextHelper.getContextFrom((IContext)context, IAssociationContext.class);
        GroupsInListFilteredContext inListContext = new GroupsInListFilteredContext(associationContext);
        debug.event("getWithAssociation", (Object)inListContext);
        SMResponse listEntriesResponse = this.getResources("CSDINLST", (IContext)inListContext);
        LinkedHashMap<String, SMConnectionRecord> orderedGroupsByName = new LinkedHashMap<String, SMConnectionRecord>();
        Iterator iterator = listEntriesResponse.iterator();
        while (iterator.hasNext()) {
            SMConnectionRecord listEntry = (SMConnectionRecord)iterator.next();
            orderedGroupsByName.put(listEntry.get("CSDGROUP"), null);
        }
        iterator = groups.iterator();
        while (iterator.hasNext()) {
            SMConnectionRecord group = (SMConnectionRecord)iterator.next();
            String groupName = group.get("NAME");
            if (!orderedGroupsByName.containsKey(groupName)) continue;
            orderedGroupsByName.put(groupName, group);
        }
        Iterator iterator2 = orderedGroupsByName.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            if (entry.getValue() != null) continue;
            iterator2.remove();
        }
        return this.createLocalResponse("CSDLIST", orderedGroupsByName.values().toArray(new SMConnectionRecord[orderedGroupsByName.size()]), context);
    }

    private HttpURLConnection tryConnection(URL url, String method) throws IOException, AuthenticationException {
        return this.tryConnection(url, method, null, new HashMap<String, String>());
    }

    private HttpURLConnection tryConnection(URL url, String method, String payload) throws IOException, AuthenticationException {
        return this.tryConnection(url, method, payload, new HashMap<String, String>());
    }

    private HttpURLConnection tryConnection(URL url, String method, String payload, Map<String, String> requestProperties) throws IOException, AuthenticationException {
        int responseCode;
        HttpURLConnection connection = this.prepareConnection(url, method, requestProperties);
        if (payload != null) {
            debug.event("tryConnection", payload);
            Throwable throwable = null;
            Object var7_9 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), DATA_ENCODING_CHARSET);){
                writer.write(payload);
                writer.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if ((responseCode = connection.getResponseCode()) == 401) {
            if (this.getConfiguration().isOneTimePassword()) {
                this.connected = false;
                this.currentLtpaToken = null;
                throw new AuthenticationException("Multi-Factor Credential has expired");
            }
            if (this.currentLtpaToken != null) {
                debug.event("doGet", "Got 401 with an LTPA token - retrying without LTPA");
                this.currentLtpaToken = null;
                this.closeConnection(connection);
                connection = this.tryConnection(url, method, payload, requestProperties);
                if (connection.getResponseCode() == 401) {
                    this.connected = false;
                    throw new AuthenticationException("Invalid password");
                }
            }
        } else if (connection.getResponseCode() == 200) {
            this.findAndStoreAnyLtpaToken(connection.getHeaderField("Set-Cookie"));
        }
        return connection;
    }

    private HttpURLConnection prepareConnection(URL url, String method, Map<String, String> requestProperties) throws IOException {
        HttpURLConnection connection = this.openConnection(url);
        this.setAuthorization(connection);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod(method);
        requestProperties.forEach((key, value) -> connection.setRequestProperty((String)key, (String)value));
        connection.setRequestProperty(USER_AGENT_PROPERTY, USER_AGENT);
        return connection;
    }

    protected SMResponse doGet(String resourceType, IContext context, boolean useCache) throws ConnectionException {
        String message;
        String contentType;
        int responseCode;
        URL url;
        HttpURLConnection connection;
        block12: {
            String request;
            debug.enter("get", (Object)this, (Object)resourceType, (Object)context);
            SMResponse smResponse = null;
            String modelName = IModelNames.ModelNamesHelper.getModelName(resourceType);
            connection = null;
            try {
                request = this.buildGETRequest(resourceType, context, useCache);
            }
            catch (InvalidFilterException e) {
                debug.warning("buildGETRequest", (Object)context, (Object)e);
                throw new SMConnectionException((Exception)((Object)e));
            }
            url = this.createURL(FILE + modelName + request);
            debug.event("get", (Object)url);
            connection = this.tryConnection(url, "GET");
            responseCode = connection.getResponseCode();
            contentType = connection.getContentType();
            message = connection.getResponseMessage();
            debug.event("get", (Object)responseCode, (Object)message, (Object)contentType);
            if (responseCode != 200 || !this.isXML(contentType)) break block12;
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            SMResponseHandler handler = new SMResponseHandler(resourceType, modelName, context, connection.getInputStream(), connection.getURL()){

                @Override
                protected boolean isOK(int response) {
                    return response == 1024 || response == 1027;
                }
            };
            parser.parse(handler.getInputStream(), (DefaultHandler)handler);
            smResponse = handler.getResponse();
            debug.exit("get", (Object)smResponse);
            SMResponse sMResponse = smResponse;
            this.closeConnection(connection);
            return sMResponse;
        }
        try {
            try {
                message = message == null ? "Unrecognized response" : message;
                Document errorDocument = this.getErrorDocument(connection);
                this.handleContentType(contentType, responseCode, message);
                this.handleTypeNotFound(responseCode, url, message, resourceType);
                this.handleAuthentication(contentType, responseCode, message);
                this.handleWarningCount(responseCode, errorDocument);
                String messageId = this.getMessageId(errorDocument);
                String fullmessage = this.getFullMessage(errorDocument);
                if (messageId != null) {
                    message = String.valueOf(message) + ": " + messageId;
                }
                if (fullmessage != null) {
                    message = String.valueOf(message) + " (" + fullmessage + ")";
                }
                throw new SMConnectionException(url, responseCode, message);
            }
            catch (IOException ex) {
                debug.warning("get", (Object)ex);
                throw new SMConnectionException(ex);
            }
            catch (ParserConfigurationException ex) {
                debug.warning("get", (Object)ex);
                throw new SMConnectionException(ex);
            }
            catch (SAXException ex) {
                debug.warning("get", (Object)ex);
                throw new SMConnectionException(ex);
            }
            catch (InvalidContentTypeException ex) {
                this.handleAuthentication(ex.getContentType(), ex.getResponseCode(), ex.getResponseMessage());
                throw ex;
            }
        }
        catch (Throwable throwable) {
            this.closeConnection(connection);
            throw throwable;
        }
    }

    private void findAndStoreAnyLtpaToken(String headerField) {
        String token = SMCPSMConnection.findAnyLtpaToken(headerField);
        if (token != null) {
            this.currentLtpaToken = token.length() == 0 ? null : token;
        }
    }

    static String findAnyLtpaToken(String headerField) {
        String token = null;
        if (headerField != null && headerField.contains("LtpaToken") && headerField.contains("=")) {
            int ltpaTokenName = headerField.indexOf("LtpaToken");
            int firstSemicolon = headerField.indexOf(";", ltpaTokenName);
            token = firstSemicolon == -1 ? headerField.substring(ltpaTokenName) : headerField.substring(ltpaTokenName, firstSemicolon);
        }
        return token;
    }

    private void handleContentType(String contentType, int responseCode, String message) throws InvalidContentTypeException {
        if (!this.isXML(contentType) && !this.canContentBeHtml(responseCode)) {
            throw new InvalidContentTypeException(contentType, responseCode, message);
        }
    }

    private boolean canContentBeHtml(int responseCode) {
        return responseCode == 403;
    }

    private Document getErrorDocument(HttpURLConnection connection) {
        if (connection.getErrorStream() != null && this.isXML(connection.getContentType())) {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(connection.getErrorStream()));
            }
            catch (SAXException e) {
                debug.warning("getErrorDocument", "Exception parsing error document", (Throwable)e);
            }
            catch (IOException e) {
                debug.warning("getErrorDocument", "Exception parsing error document", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                debug.warning("getErrorDocument", "Exception parsing error document", (Throwable)e);
            }
        }
        return null;
    }

    private String getMessageId(Document errorDocument) {
        Element element;
        if (errorDocument != null && (element = errorDocument.getDocumentElement()) != null) {
            String messageId = element.getAttribute("message_id");
            return "".equals(messageId) ? null : messageId;
        }
        return null;
    }

    private String getFullMessage(Document d) {
        Element root;
        if (d != null && (root = d.getDocumentElement()) != null && "error".equals(root.getTagName())) {
            NodeList childNodes = root.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node item = childNodes.item(i);
                if (item.getNodeName().equals("full")) {
                    return item.getTextContent().replace("\n", "");
                }
                ++i;
            }
        }
        return null;
    }

    private void handleTypeNotFound(int responseCode, URL url, String responseMessage, String resourceType) throws TypeNotFoundException {
        if (responseCode == 404 && this.isConnected()) {
            throw new TypeNotFoundException(url, responseCode, responseMessage, resourceType);
        }
    }

    private void handleAuthentication(String contentType, int responseCode, String responseMessage) throws AuthenticationException {
        if (responseCode == 200 && contentType.startsWith("text/html") && !this.connected) {
            throw new AuthenticationException("Password expired");
        }
        if (responseCode == 401) {
            throw new AuthenticationException(responseMessage);
        }
    }

    private void handleWarningCount(int responseCode, Document d) throws WarningCountExceededException {
        try {
            Element root;
            if (responseCode == 403 && d != null && (root = d.getDocumentElement()) != null && "error".equals(root.getTagName())) {
                int currentRecordCount = -1;
                int defaultWarningCount = -1;
                boolean overrideable = false;
                NodeList childNodes = root.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node item = childNodes.item(i);
                    if (item instanceof Element && "errorInfo".equals(((Element)item).getTagName())) {
                        Element errorInfo = (Element)item;
                        String errorInfoName = errorInfo.getAttribute("name");
                        if ("current_record_count".equals(errorInfoName)) {
                            currentRecordCount = Integer.parseInt(errorInfo.getTextContent());
                        } else if ("default_warning_count".equals(errorInfoName)) {
                            defaultWarningCount = Integer.parseInt(errorInfo.getTextContent());
                        } else if ("override_warning_count_allowed".equals(errorInfoName)) {
                            overrideable = "yes".equalsIgnoreCase(errorInfo.getTextContent());
                        }
                    }
                    ++i;
                }
                if (currentRecordCount >= 0) {
                    throw new WarningCountExceededException(currentRecordCount, defaultWarningCount, overrideable);
                }
            }
        }
        catch (NumberFormatException e) {
            debug.warning("handleWarningCount", "Error parsing default warning count exceeded error document", (Throwable)e);
        }
    }

    protected SMResponse createLocalResponse(String resourceType, SMConnectionRecord[] records, IContext context) {
        SMResponse localResponse = SMResponse.records(this.generateLocalStub(), resourceType, Arrays.asList(records), context);
        return localResponse;
    }

    private boolean isXML(String contentType) {
        return contentType != null && (contentType.contains("application/xml") || contentType.contains("text/xml"));
    }

    private String generateLocalStub() {
        return "local@" + UUID.randomUUID();
    }

    protected String buildGETRequest(String resourceType, IContext context, boolean useCache) throws TypeNotFoundException, InvalidFilterException {
        return RequestBuilder.buildRequest(resourceType, context, true, useCache, true, true, true);
    }

    public SMResponse getResources(String resourceName, IContext context) throws ConnectionException {
        debug.enter("getResources", (Object)this, (Object)resourceName, (Object)context);
        SMResponse response = this.get(resourceName, context, false);
        debug.exit("getResources", (Object)response);
        return response;
    }

    public SMResponse fetch(String stub, int position, int count) throws ConnectionException {
        SMResponse smResponse;
        debug.enter("fetch", (Object)this, (Object)stub, (Object)position, (Object)count);
        SMResponse smRequest = this.stubs.get(stub);
        String resourceType = smRequest.getResourceType();
        String modelName = IModelNames.ModelNamesHelper.getModelName(resourceType);
        debug.event("fetch", (Object)smRequest, (Object)resourceType, (Object)modelName);
        HttpURLConnection connection = null;
        if (smRequest.getResponse().equals("NODATA")) {
            smResponse = SMResponse.noRecords(stub, resourceType, smRequest.getContext());
        } else if (this.isLocal(stub)) {
            smResponse = smRequest.subResponse(position - 1, count);
        } else if (smRequest.getRecordTotal() == 0) {
            debug.event("fetch", (Object)smRequest);
            smResponse = SMResponse.noRecords(stub, resourceType, null);
        } else {
            block15: {
                try {
                    try {
                        String request = "/" + stub + "/" + position + "/" + count;
                        request = String.valueOf(request) + "?NODISCARD=NODISCARD";
                        URL url = this.createURL("/CICSSystemManagement/CICSResultCache" + request);
                        debug.event("fetch", (Object)url);
                        connection = this.tryConnection(url, "GET");
                        int responseCode = connection.getResponseCode();
                        debug.event("fetch", (Object)connection.getResponseCode(), (Object)connection.getResponseMessage());
                        if (responseCode == 200) {
                            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                            SMResponseHandler handler = new SMResponseHandler(resourceType, modelName, smRequest.getContext(), connection.getInputStream(), connection.getURL());
                            parser.parse(handler.getInputStream(), (DefaultHandler)handler);
                            smResponse = handler.getResponse();
                            this.stubs.put(smRequest.getStub(), smRequest);
                            break block15;
                        }
                        if (responseCode == 404) {
                            this.stubs.remove(smRequest.getStub());
                            SMResponse getResponse = this.get(smRequest.getResourceType(), smRequest.getContext());
                            if (getResponse.getRecordTotal() <= position) {
                                throw new SMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
                            }
                            smResponse = this.fetch(getResponse.getStub(), position, count);
                            break block15;
                        }
                        throw new SMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
                    }
                    catch (IOException ex) {
                        debug.warning("fetch", (Object)ex);
                        throw new SMConnectionException(ex);
                    }
                    catch (ParserConfigurationException ex) {
                        debug.warning("fetch", (Object)ex);
                        throw new SMConnectionException(ex);
                    }
                    catch (SAXException ex) {
                        debug.warning("fetch", (Object)ex);
                        throw new SMConnectionException(ex);
                    }
                }
                catch (Throwable throwable) {
                    this.closeConnection(connection);
                    throw throwable;
                }
            }
            this.closeConnection(connection);
        }
        debug.exit("fetch", (Object)smResponse);
        return smResponse;
    }

    private boolean isLocal(String stub) {
        return stub.startsWith("local@");
    }

    public void discard(String stub) throws ConnectionException {
        debug.enter("discard", (Object)this, (Object)stub);
        SMResponse smResponse = this.stubs.remove(stub);
        debug.event("discard", (Object)smResponse);
        HttpURLConnection connection = null;
        if (smResponse != null && smResponse.getRecordTotal() != 0 && !this.isLocal(stub)) {
            block7: {
                try {
                    try {
                        String resourceType = smResponse.getResourceType();
                        String request = "/" + stub + "/?SUMMONLY";
                        URL url = this.createURL("/CICSSystemManagement/CICSResultCache" + request);
                        debug.event("discard", (Object)url);
                        connection = this.tryConnection(url, "GET");
                        int responseCode = connection.getResponseCode();
                        debug.event("discard", new Object[]{String.valueOf(connection.getResponseCode()), connection.getResponseMessage()});
                        if (responseCode == 200) {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), DATA_ENCODING_CHARSET));
                            String declaration = reader.readLine();
                            String response = reader.readLine();
                            String resultSummary = reader.readLine();
                            debug.event("discard", (Object)declaration, (Object)response, (Object)resultSummary);
                            reader.close();
                            smResponse = SMResponse.noRecords(resourceType, "OK", smResponse.getContext());
                            break block7;
                        }
                        if (responseCode == 404) {
                            smResponse = SMResponse.noRecords(resourceType, "OK", smResponse.getContext());
                            break block7;
                        }
                        throw new SMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
                    }
                    catch (IOException ex) {
                        debug.warning("discard", (Object)ex);
                        throw new SMConnectionException(ex);
                    }
                }
                catch (Throwable throwable) {
                    this.closeConnection(connection);
                    throw throwable;
                }
            }
            this.closeConnection(connection);
        }
        debug.exit("discard", (Object)String.valueOf(this.stubs.size()));
    }

    public SMResponse update(String resourceType, IContext context, SMConnectionRecord record) throws ConnectionException {
        SMResponse smResponse;
        debug.enter("update", (Object)resourceType, (Object)context, (Object)record);
        HttpURLConnection connection = null;
        String modelName = IModelNames.ModelNamesHelper.getModelName(resourceType);
        try {
            try {
                String request = RequestBuilder.buildRequest(resourceType, context, false, false, false, false, false);
                URL url = this.createURL(FILE + modelName + request);
                debug.event("update", (Object)url);
                String payload = this.buildUpdatePayload(resourceType, request.indexOf("CSDGROUP") != -1, (IMutableSMConnectionRecord)record);
                connection = this.tryConnection(url, "PUT", payload);
                int responseCode = connection.getResponseCode();
                debug.event("update", new Object[]{String.valueOf(connection.getResponseCode()), connection.getResponseMessage()});
                if (responseCode != 200) {
                    throw new SMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
                }
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                SMResponseHandler handler = new SMResponseHandler(resourceType, modelName, context, connection.getInputStream(), connection.getURL());
                parser.parse(handler.getInputStream(), (DefaultHandler)handler);
                smResponse = handler.getResponse();
            }
            catch (IOException ex) {
                debug.warning("update", (Object)ex);
                throw new SMConnectionException(ex);
            }
            catch (ParserConfigurationException ex) {
                debug.warning("update", (Object)ex);
                throw new SMConnectionException(ex);
            }
            catch (SAXException ex) {
                debug.warning("update", (Object)ex);
                throw new SMConnectionException(ex);
            }
        }
        catch (Throwable throwable) {
            this.closeConnection(connection);
            throw throwable;
        }
        this.closeConnection(connection);
        debug.exit("update", (Object)smResponse);
        return smResponse;
    }

    protected String buildUpdatePayload(String resourceType, boolean isCSD, IMutableSMConnectionRecord mutableRecord) {
        String payload = "<request><update>";
        if (isCSD) {
            payload = String.valueOf(payload) + "<parameter name=\"CSD\"/>";
        }
        payload = String.valueOf(payload) + "<attributes";
        for (String name : mutableRecord) {
            String value = mutableRecord.get(name);
            payload = String.valueOf(payload) + " " + this.escapeXmlPayload(name) + "=" + "\"" + this.escapeXmlPayload(value) + "\"";
        }
        payload = String.valueOf(payload) + " /></update></request>";
        return payload;
    }

    /*
     * Exception decompiling
     */
    private SMResponse delete(String resourceType, IContext context, boolean useMethodOverride) throws SystemManagerConnectionException, AuthenticationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SMResponse delete(String resourceType, IContext context) throws SystemManagerConnectionException {
        try {
            return this.delete(resourceType, context, false);
        }
        catch (AuthenticationException e) {
            throw new SystemManagerAuthenticationException(e);
        }
    }

    private String buildDeletePayload(String resourceType, IContext context) {
        IContext parentContext;
        boolean hasPayload = false;
        String payload = "<request><delete>";
        if (context instanceof IParameterisedContext) {
            hasPayload = true;
            payload = this.appendParameters((IParameterisedContext)context, payload);
        } else if (context instanceof IFilteredContext && (parentContext = ((IFilteredContext)context).getParentContext()) instanceof IParameterisedContext) {
            hasPayload = true;
            payload = this.appendParameters((IParameterisedContext)parentContext, payload);
        }
        payload = String.valueOf(payload) + "</delete></request>";
        return hasPayload ? payload : "";
    }

    public SMResponse add(String resourceType, IFilteredContext definition, IFilteredContext group) throws ConnectionException {
        debug.enter("add", (Object)this, (Object)resourceType, (Object)definition, (Object)group);
        String groupName = group.getAttributeValue("RESGROUP");
        AbstractCICSAction addToGroupAction = new AbstractCICSAction("ADDTOGRP", new String[][]{{"RESGROUP", groupName}}){};
        debug.event("add", (Object)resourceType, (Object)definition, (Object)addToGroupAction);
        SMResponse response = this.perform(resourceType, (IContext)definition, (ICICSAction)addToGroupAction);
        debug.exit("add", (Object)response);
        return response;
    }

    public SMResponse remove(String resourceType, IFilteredContext child, IFilteredContext parent) throws SystemManagerConnectionException {
        SMResponse response;
        debug.enter("remove", (Object)this, (Object)resourceType, (Object)child, (Object)parent);
        String modelName = IModelNames.ModelNamesHelper.getModelName(resourceType);
        debug.event("remove", modelName);
        if (modelName == "CICSCSDGroup") {
            GroupInListPrimaryKey context = new GroupInListPrimaryKey(parent, child);
            debug.event("remove", (Object)context);
            response = this.delete("CSDINLST", (IContext)context);
        } else if (modelName == "CICSResourceGroup") {
            ResourceGroupInResourceDescriptionPrimaryKey context = new ResourceGroupInResourceDescriptionPrimaryKey(parent, child);
            debug.event("remove", (Object)context);
            response = this.delete("RESINDSC", (IContext)context);
        } else if (modelName == "CICSRegionDefinition") {
            RegionInRegionGroupPrimaryKey context = new RegionInRegionGroupPrimaryKey(parent, child);
            debug.event("remove", (Object)context);
            response = this.delete("CSGLCGCS", (IContext)context);
        } else if (modelName == "CICSRegionGroup") {
            RegionGroupInRegionGroupPrimaryKey context = new RegionGroupInRegionGroupPrimaryKey(parent, child);
            debug.event("remove", (Object)context);
            response = this.delete("CSGLCGCG", (IContext)context);
        } else if (IResourceTables.Helper.isCICSDefinition((String)resourceType)) {
            ResourcePrimaryKey resourceContext = new ResourcePrimaryKey(parent, resourceType, child);
            debug.event("remove", (Object)resourceContext);
            response = this.delete("RESINGRP", (IContext)resourceContext);
        } else {
            throw new UnsupportedOperationException(resourceType);
        }
        debug.exit("remove", (Object)response);
        return response;
    }

    public SMResponse install(String resourceType, IFilteredContext definition, IScopedContext target) throws ConnectionException {
        SMResponse response;
        debug.enter("install", (Object)this, (Object)resourceType, (Object)definition, (Object)target);
        if (resourceType == "RESGROUP") {
            response = this.installGroup(definition, target);
        } else {
            InstallAction action;
            if (this.isDefinitionFromCSD(definition)) {
                if (!target.getScope().equals(definition.getScope())) {
                    throw new InstallException("INSTALL", 1038, 1361, ErrorCodes.findErrorCodeByMnemonic((String)resourceType, (String)"INV_TSCOPE"), "NAME");
                }
                action = new InstallAction("CSDINSTALL", target);
            } else {
                action = new InstallAction(target);
            }
            response = this.perform(resourceType, (IContext)definition, (ICICSAction)action);
        }
        debug.exit("install", (Object)response);
        return response;
    }

    private boolean isDefinitionFromCSD(IFilteredContext definition) {
        return definition.getScope() != null;
    }

    public SMResponse installGroup(IFilteredContext group, IScopedContext target) throws ConnectionException {
        debug.enter("installGroup", (Object)this, (Object)group, (Object)target);
        SMResponse response = null;
        HashSet<String> resourceTypes = new HashSet<String>();
        SMResponse getResponse = this.getResources("RESINGRP", (IContext)group);
        int i = 0;
        while (i < getResponse.getRecordTotal()) {
            SMConnectionRecord record = getResponse.getRecord(i);
            String resourceType = record.get("DEFTYPE");
            resourceTypes.add(resourceType);
            ++i;
        }
        debug.event("installGroup", resourceTypes);
        if (resourceTypes.isEmpty()) {
            InstallAction action = new InstallAction(target);
            response = this.perform("RESGROUP", (IContext)group, (ICICSAction)action);
        } else {
            for (String resourceType : resourceTypes) {
                InstallAction action = new InstallAction(target, resourceType);
                response = this.perform("RESGROUP", (IContext)group, (ICICSAction)action);
            }
        }
        debug.exit("installGroup", (Object)response);
        return response;
    }

    public SMResponse perform(String resourceType, IContext context, ICICSAction action) throws ConnectionException {
        SMResponse smResponse;
        debug.enter("perform", (Object)this, (Object)resourceType, (Object)context, (Object)action);
        HttpURLConnection connection = null;
        String modelName = IModelNames.ModelNamesHelper.getModelName(resourceType);
        if (resourceType.equals("TSQNAME") | resourceType.equals("TSQSHR") && action == SystemManagerActions.Delete) {
            debug.enter("perform", (Object)this, (Object)resourceType, (Object)action);
            smResponse = this.getResources(resourceType, context);
            this.delete(resourceType, context);
        } else {
            try {
                try {
                    String request = RequestBuilder.buildRequest(resourceType, context, false, false, false, false, false);
                    URL url = this.createURL(FILE + modelName + request);
                    debug.event("perform", (Object)url);
                    String payload = this.buildActionPayload(action);
                    connection = this.tryConnection(url, "PUT", payload);
                    int responseCode = connection.getResponseCode();
                    debug.event("perform", new Object[]{String.valueOf(connection.getResponseCode()), connection.getResponseMessage()});
                    if (responseCode != 200) {
                        throw new SMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
                    }
                    SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                    SMResponseHandler handler = new SMResponseHandler(resourceType, modelName, context, connection.getInputStream(), connection.getURL());
                    parser.parse(handler.getInputStream(), (DefaultHandler)handler);
                    smResponse = handler.getResponse();
                }
                catch (IOException ex) {
                    debug.warning("perform", (Object)ex);
                    throw new SMConnectionException(ex);
                }
                catch (ParserConfigurationException ex) {
                    debug.warning("perform", (Object)ex);
                    throw new SMConnectionException(ex);
                }
                catch (SAXException ex) {
                    debug.warning("perform", (Object)ex);
                    throw new SMConnectionException(ex);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(connection);
                throw throwable;
            }
            this.closeConnection(connection);
        }
        debug.exit("perform", (Object)smResponse);
        return smResponse;
    }

    private String buildActionPayload(ICICSAction action) {
        debug.enter("buildActionPayload", (Object)this, (Object)action);
        String payload = "<request><action name=\"" + action.getActionName() + "\">";
        for (String parameterName : action) {
            String parameterValue = action.getParameterValue(parameterName);
            payload = String.valueOf(payload) + "<parameter name=\"" + this.escapeXmlPayload(parameterName);
            if (parameterValue != null) {
                payload = String.valueOf(payload) + "\" value=\"" + this.escapeXmlPayload(parameterValue);
            }
            payload = String.valueOf(payload) + "\"/>";
        }
        payload = String.valueOf(payload) + "</action></request>";
        debug.exit("buildActionPayload", (Object)payload);
        return payload;
    }

    protected void clearSupportedResources() {
        this.supportedResources.clear();
    }

    protected void addSupportedResource(String resource) {
        this.supportedResources.add(resource);
    }

    public List<IRepository> getRepositories() {
        return RepositoryDiscoverer.getRepositories((ISystemManagerConnection)this);
    }

    private void closeConnection(HttpURLConnection connection) {
        if (connection != null) {
            Closeable stream;
            try {
                stream = connection.getInputStream();
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException e) {
                debug.event("closeConnection", (Object)"input stream", (Object)e);
            }
            try {
                stream = connection.getOutputStream();
                if (stream != null) {
                    ((OutputStream)stream).close();
                }
            }
            catch (IOException e) {
                debug.event("closeConnection", (Object)"output stream", (Object)e);
            }
            try {
                stream = connection.getErrorStream();
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException e) {
                debug.event("closeConnection", (Object)"error stream", (Object)e);
            }
        }
    }

    private static /* synthetic */ String lambda$1(AbstractMap.SimpleEntry e) {
        return (String)e.getKey();
    }

    private static /* synthetic */ String lambda$2(AbstractMap.SimpleEntry e) {
        return (String)e.getValue();
    }

    private static final class GroupInListPrimaryKey
    extends AbstractFilteredContext
    implements IPrimaryKey {
        private static final String CSDINLIST_ATTRIBUTE_CSDLIST = "CSDLIST";
        private static final String CSDINLIST_ATTRIBUTE_CSDGROUP = "CSDGROUP";
        private final HashMap<String, String> attributes = new HashMap();

        public GroupInListPrimaryKey(IFilteredContext list, IFilteredContext group) {
            super(GroupInListPrimaryKey.getParentContext((IContext)list));
            String listName = list.getAttributeValue("NAME");
            if (listName == null || "".equals(listName)) {
                throw new IllegalArgumentException("Couldn't find attribute \"NAME\" on the parent context");
            }
            String groupName = group.getAttributeValue("NAME");
            if (groupName == null || "".equals(groupName)) {
                throw new IllegalArgumentException("Couldn't find attribute \"NAME\" on the child context");
            }
            this.attributes.put(CSDINLIST_ATTRIBUTE_CSDLIST, listName);
            this.attributes.put(CSDINLIST_ATTRIBUTE_CSDGROUP, groupName);
        }

        private static IContext getParentContext(IContext parent) {
            IScopedContext csd = (IScopedContext)ContextHelper.getContextFrom((IContext)parent, IScopedContext.class);
            if (csd == null || csd.getScope() == null || "".equals(csd.getScope())) {
                throw new IllegalArgumentException("Parent context did not specify a scope");
            }
            return new ScopedContext(csd.getContext(), csd.getScope());
        }

        public Set<String> getAttributeNames() {
            return this.attributes.keySet();
        }

        public String getAttributeValue(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.getContext() + "/" + this.attributes.values() + "]";
        }

        public boolean matches(IPrimaryKey other) {
            return false;
        }
    }

    private static final class GroupsInListFilteredContext
    implements IFilteredContext {
        private static final String CSDINLIST_ATTRIBUTE_CSDLIST = "CSDLIST";
        private final IScopedContext parentContext;
        private final HashMap<String, String> attributes = new HashMap();

        public GroupsInListFilteredContext(IAssociationContext list) {
            final IScopedContext scopedContext = (IScopedContext)list;
            this.parentContext = new IScopedContext(){

                public String getContext() {
                    return scopedContext.getContext();
                }

                public String getScope() {
                    return scopedContext.getScope();
                }
            };
            this.attributes.put(CSDINLIST_ATTRIBUTE_CSDLIST, list.getResourceName());
        }

        public Set<String> getAttributeNames() {
            return this.attributes.keySet();
        }

        public String getAttributeValue(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[" + this.getContext() + "/" + this.attributes.values() + "]";
        }

        public IContext getParentContext() {
            return this.parentContext;
        }

        public String getScope() {
            return this.parentContext.getScope();
        }

        public String getContext() {
            return this.parentContext.getContext();
        }
    }

    private static class InvalidContentTypeException
    extends SMConnectionException {
        private static final long serialVersionUID = 1L;
        private int responseCode;
        private String responseMessage;
        private String contentType;

        public InvalidContentTypeException(String contentType, int responseCode, String responseMessage) {
            super("Unexpected content type: " + contentType + ", " + responseMessage);
            this.contentType = contentType;
            this.responseCode = responseCode;
            this.responseMessage = responseMessage;
        }

        public String getContentType() {
            return this.contentType;
        }

        @Override
        public int getResponseCode() {
            return this.responseCode;
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }
    }

    private static final class RegionGroupInRegionGroupPrimaryKey
    extends AbstractFilteredContext {
        private static final String CSGLCGCG_ATTRIBUTE_GROUP = "GROUP";
        private static final String CSGLCGCG_ATTRIBUTE_TOGROUP = "TOGROUP";
        private final HashMap<String, String> attributes = new HashMap();

        public RegionGroupInRegionGroupPrimaryKey(IFilteredContext parentRegionGroup, IFilteredContext regionGroup) {
            super((IContext)new Context(parentRegionGroup.getContext()));
            String parentName = parentRegionGroup.getAttributeValue(CSGLCGCG_ATTRIBUTE_GROUP);
            if (parentName == null) {
                throw new IllegalArgumentException("Couldn't find attribute \"GROUP\" on the parent group context");
            }
            this.attributes.put(CSGLCGCG_ATTRIBUTE_TOGROUP, parentName);
            String childName = regionGroup.getAttributeValue(CSGLCGCG_ATTRIBUTE_GROUP);
            if (childName == null) {
                throw new IllegalArgumentException("Couldn't find attribute \"GROUP\" on the child group context");
            }
            this.attributes.put(CSGLCGCG_ATTRIBUTE_GROUP, childName);
        }

        public Set<String> getAttributeNames() {
            return this.attributes.keySet();
        }

        public String getAttributeValue(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.getContext() + "/" + this.attributes.values() + "]";
        }
    }

    private static final class RegionInRegionGroupPrimaryKey
    extends AbstractFilteredContext {
        private static final String CSGLCGCS_ATTRIBUTE_GROUP = "GROUP";
        private static final String CSGLCGCS_ATTRIBUTE_CICSNAME = "CICSNAME";
        private final HashMap<String, String> attributes = new HashMap();

        public RegionInRegionGroupPrimaryKey(IFilteredContext regionGroup, IFilteredContext region) {
            super((IContext)new Context(regionGroup.getContext()));
            String groupName = regionGroup.getAttributeValue(CSGLCGCS_ATTRIBUTE_GROUP);
            if (groupName == null) {
                throw new IllegalArgumentException("Couldn't find attribute \"GROUP\" on the group context");
            }
            this.attributes.put(CSGLCGCS_ATTRIBUTE_GROUP, groupName);
            String regionName = region.getAttributeValue("NAME");
            if (regionName == null) {
                throw new IllegalArgumentException("Couldn't find attribute \"NAME\" on the region context");
            }
            this.attributes.put(CSGLCGCS_ATTRIBUTE_CICSNAME, regionName);
        }

        public Set<String> getAttributeNames() {
            return this.attributes.keySet();
        }

        public String getAttributeValue(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.getContext() + "/" + this.attributes.values() + "]";
        }
    }

    private static final class ResourceGroupInResourceDescriptionPrimaryKey
    extends AbstractFilteredContext {
        private static final String RESINDSC_ATTRIBUTE_RESGROUP = "RESGROUP";
        private static final String RESINDSC_ATTRIBUTE_RESDESC = "RESDESC";
        private final HashMap<String, String> attributes = new HashMap();

        public ResourceGroupInResourceDescriptionPrimaryKey(IFilteredContext list, IFilteredContext group) {
            super((IContext)new Context(list.getContext()));
            String listName = list.getAttributeValue(RESINDSC_ATTRIBUTE_RESDESC);
            if (listName == null || "".equals(listName)) {
                throw new IllegalArgumentException("Couldn't find attribute \"RESDESC\" on the list context");
            }
            String groupName = group.getAttributeValue(RESINDSC_ATTRIBUTE_RESGROUP);
            if (groupName == null || "".equals(groupName)) {
                throw new IllegalArgumentException("Couldn't find attribute \"RESGROUP\" on the group context");
            }
            this.attributes.put(RESINDSC_ATTRIBUTE_RESDESC, listName);
            this.attributes.put(RESINDSC_ATTRIBUTE_RESGROUP, groupName);
        }

        public Set<String> getAttributeNames() {
            return this.attributes.keySet();
        }

        public String getAttributeValue(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.getContext() + "/" + this.attributes.values() + "]";
        }
    }

    private static final class ResourcePrimaryKey
    extends AbstractFilteredContext {
        private static final String RESINGRP_ATTRIBUTE_RESGROUP = "RESGROUP";
        private final HashMap<String, String> attributes = new HashMap();

        public ResourcePrimaryKey(IFilteredContext group, String definitionType, IFilteredContext definition) {
            super((IContext)new Context(group.getContext()));
            String groupName = group.getAttributeValue(RESINGRP_ATTRIBUTE_RESGROUP);
            if (groupName == null) {
                throw new IllegalArgumentException("Couldn't find attribute \"RESGROUP\" on the group context");
            }
            String definitionName = definition.getAttributeValue("NAME");
            if (definitionName == null) {
                throw new IllegalArgumentException("Couldn't find attribute \"NAME\" on the definition context");
            }
            String definitionVersion = definition.getAttributeValue("DEFVER");
            if (definitionVersion == null) {
                throw new IllegalArgumentException("Couldn't find attribute \"DEFVER\" on the definition context");
            }
            this.attributes.put(RESINGRP_ATTRIBUTE_RESGROUP, groupName);
            this.attributes.put("DEFTYPE", definitionType);
            this.attributes.put("DEFNAME", definitionName);
            this.attributes.put("DEFVER", definitionVersion);
        }

        public Set<String> getAttributeNames() {
            return this.attributes.keySet();
        }

        public String getAttributeValue(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.getContext() + "/" + this.attributes.values() + "]";
        }
    }
}

