/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.cpsm;

import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CPSMConnectionException
extends SystemManagerConnectionException {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CPSMConnectionException.class.getPackage().getName());
    private static final long serialVersionUID = 1L;

    public CPSMConnectionException(Exception ex) {
        super(ex);
    }

    public CPSMConnectionException(URL url, String request, String response, String reason) {
        super(url + "?" + request + ": " + response + ", " + reason);
        this.setResponseAndReason(response, reason);
    }

    public CPSMConnectionException(URL url, String status) {
        super(status);
    }

    public CPSMConnectionException(URL url, String response, String reason) {
        super(String.valueOf(response) + ", " + reason);
        this.setResponseAndReason(response, reason);
    }

    private void setResponseAndReason(String response, String reason) {
        try {
            this.response = CPSMConnectionException.getResponseCode((String)response);
            this.reason = CPSMConnectionException.getReasonCode((String)reason);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "CPSMConnectionException", "setResponseAndReason", e.getLocalizedMessage(), e);
        }
    }

    public CPSMConnectionException(URL url, int responseCode, String responseMessage) {
        super(responseCode, responseMessage);
    }

    public CPSMConnectionException(URL url, String request, int responseCode, String responseMessage) {
        super("url=" + url.toString() + ", request=" + request + ", code=" + responseCode + ", message=" + responseMessage);
    }

    public CPSMConnectionException(String message, URL url, String request) {
        super(String.valueOf(message) + " url=" + url.toString() + ", request=" + request);
    }
}

