/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.model.ICICSType;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class TableDescriptions {
    private static final String TABLE_PREFIX = "Table.";
    private static final String NAME_SUFFIX = ".name";
    private static final String LOWERCASE_SUFFIX = ".name.lowercase";
    private static final String PLURALS_SUFFIX = ".names";
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String BUNDLE_NAME = "com.ibm.cics.core.model.tableDescriptions";
    private static TableDescriptions myInstance;
    static ResourceBundle RESOURCE_BUNDLE;
    private Set<String> pluralTableDescriptions = new HashSet<String>();

    static {
        RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
    }

    private TableDescriptions() {
        this.loadPluralTableDescriptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TableDescriptions getInstance() {
        Class<TableDescriptions> clazz = TableDescriptions.class;
        synchronized (TableDescriptions.class) {
            if (myInstance == null) {
                myInstance = new TableDescriptions();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return myInstance;
        }
    }

    public static String getTableDescription(ICICSType<?> type) {
        return TableDescriptions.getTableDescription(type.getResourceTableName());
    }

    public static String getTableDescriptionInLowercase(ICICSType<?> type) {
        return TableDescriptions.getTableDescriptionInLowercase(type.getResourceTableName());
    }

    public static String getPluralTableDescription(ICICSType<?> type) {
        return TableDescriptions.getPluralTableDescription(type.getResourceTableName());
    }

    public static String getTableDescription(String tableName) {
        return TableDescriptions.getString(TableDescriptions.getNameKey(tableName), tableName);
    }

    public static String getTableDescriptionInLowercase(String tableName) {
        return TableDescriptions.getString(TableDescriptions.getLowerCaseKey(tableName), tableName);
    }

    public static String getPluralTableDescription(String tableName) {
        return TableDescriptions.getString(TableDescriptions.getPluralKey(tableName), tableName);
    }

    public static boolean isPluralTableDescription(String candidate) {
        return TableDescriptions.getInstance().pluralTableDescriptions.contains(candidate);
    }

    static String getNameKey(String tableName) {
        return TABLE_PREFIX + tableName + NAME_SUFFIX;
    }

    static String getLowerCaseKey(String tableName) {
        return TABLE_PREFIX + tableName + LOWERCASE_SUFFIX;
    }

    static String getPluralKey(String tableName) {
        return TABLE_PREFIX + tableName + PLURALS_SUFFIX;
    }

    private static String getString(String key, String tableName) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return tableName;
        }
    }

    private void loadPluralTableDescriptions() {
        try {
            for (String key : RESOURCE_BUNDLE.keySet()) {
                String messageId = key;
                if (!messageId.endsWith(PLURALS_SUFFIX)) continue;
                String message = RESOURCE_BUNDLE.getString(messageId);
                this.pluralTableDescriptions.add(message);
            }
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("Message could not be found", e);
        }
    }
}

