/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.atom;

import com.ibm.cics.common.util.SimpleValidationHelper;
import com.ibm.cics.core.model.atom.IAtomConfiguration;
import com.ibm.cics.core.model.atom.Messages;
import com.ibm.cics.model.meta.Attribute;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.meta.IType;
import com.ibm.cics.model.meta.ITypedObject;
import com.ibm.cics.model.meta.IllegalAttributeException;

public class AtomConfigurationType
implements IType {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final AtomConfigurationType instance = new AtomConfigurationType();
    public static final IAttribute SERVICE_TYPE = new Attribute("serviceType", IAtomConfiguration.ServiceTypeValue.class, "basic");
    public static final IAttribute RESBIND_XML_TRANSFORM_NAME = new Attribute("resbindXmlTransformName", String.class, "basic"){

        public void validate(Object value) throws IllegalAttributeException {
            if (value instanceof String) {
                try {
                    SimpleValidationHelper.validateMaxLength((String)((String)value), (int)32, null);
                    SimpleValidationHelper.validateHfsFilenameChars((String)((String)value), null);
                }
                catch (RuntimeException ex) {
                    throw new IllegalAttributeException(ex.getMessage(), (IAttribute)this, value);
                }
            } else {
                throw new IllegalAttributeException("Should have been a string", (IAttribute)this, value);
            }
        }
    };
    public static final IAttribute RESBIND_ROOT = new Attribute("resbindRoot", String.class, "basic"){

        public void validate(Object value) throws IllegalAttributeException {
            if (value instanceof String) {
                try {
                    SimpleValidationHelper.validateLatin1CharsOnly((String)((String)value), null);
                }
                catch (RuntimeException ex) {
                    throw new IllegalAttributeException(ex.getMessage(), (IAttribute)this, value);
                }
            } else {
                throw new IllegalAttributeException("Should have been a string", (IAttribute)this, value);
            }
        }
    };
    public static final IAttribute URIMAP_URI = new Attribute("urimapUri", String.class, "urimap"){

        public void validate(Object value) throws IllegalAttributeException {
            if (value instanceof String) {
                try {
                    String valueString = (String)value;
                    if (valueString.isEmpty()) {
                        throw new IllegalAttributeException(Messages.getString("AtomConfigurationEditor.Field.Required"), (IAttribute)this, value);
                    }
                    SimpleValidationHelper.validateURLChars((String)valueString, null);
                }
                catch (RuntimeException ex) {
                    throw new IllegalAttributeException(ex.getMessage(), (IAttribute)this, value);
                }
            } else {
                throw new IllegalAttributeException("Should have been a string", (IAttribute)this, value);
            }
        }
    };
    public static final IAttribute URIMAP_USERID = new Attribute("urimapUserid", String.class, "urimap"){

        public void validate(Object value) throws IllegalAttributeException {
            if (value instanceof String) {
                try {
                    SimpleValidationHelper.validateLatin1CharsOnly((String)((String)value), null);
                    SimpleValidationHelper.validateUseridChars((String)((String)value), null);
                }
                catch (RuntimeException ex) {
                    throw new IllegalAttributeException(ex.getMessage(), (IAttribute)this, value);
                }
            } else {
                throw new IllegalAttributeException("Should have been a string", (IAttribute)this, value);
            }
        }
    };
    public static final IAttribute URIMAP_TRANSID = new Attribute("urimapTransid", String.class, "urimap"){

        public void validate(Object value) throws IllegalAttributeException {
            if (value instanceof String) {
                try {
                    SimpleValidationHelper.validateLatin1CharsOnly((String)((String)value), null);
                    SimpleValidationHelper.validateTransactionChars((String)((String)value), null);
                }
                catch (RuntimeException ex) {
                    throw new IllegalAttributeException(ex.getMessage(), (IAttribute)this, value);
                }
            } else {
                throw new IllegalAttributeException("Should have been a string", (IAttribute)this, value);
            }
        }
    };
    public static final IAttribute ENTRY_TITLE = new Attribute("entryTitle", String.class, "entry"){

        public void validate(Object value) throws IllegalAttributeException {
            if (value instanceof String) {
                try {
                    SimpleValidationHelper.validateLatin1CharsOnly((String)((String)value), null);
                }
                catch (RuntimeException ex) {
                    throw new IllegalAttributeException(ex.getMessage(), (IAttribute)this, value);
                }
            } else {
                throw new IllegalAttributeException("Should have been a string", (IAttribute)this, value);
            }
        }
    };
    public static final IAttribute ENTRY_LINK_URI = new Attribute("entryLinkUri", String.class, "entry"){

        public void validate(Object value) throws IllegalAttributeException {
            if (value instanceof String) {
                try {
                    String valueString = (String)value;
                    if (valueString.isEmpty()) {
                        throw new IllegalAttributeException(Messages.getString("AtomConfigurationEditor.Field.Required"), (IAttribute)this, value);
                    }
                    SimpleValidationHelper.validateLatin1CharsOnly((String)valueString, null);
                }
                catch (RuntimeException ex) {
                    throw new IllegalAttributeException(ex.getMessage(), (IAttribute)this, value);
                }
            } else {
                throw new IllegalAttributeException("Should have been a string", (IAttribute)this, value);
            }
        }
    };
    public static final IAttribute FEED_RESOURCE_TYPE = new Attribute("feedResourceType", IAtomConfiguration.ResourceTypeValue.class, "feed");
    public static final IAttribute FEED_RESOURCE_NAME = new Attribute("feedResourceName", String.class, "feed"){

        public void validate(Object value) throws IllegalAttributeException {
            if (value instanceof String) {
                try {
                    String valueString = (String)value;
                    if (valueString.isEmpty()) {
                        throw new IllegalAttributeException(Messages.getString("AtomConfigurationEditor.Field.Required"), (IAttribute)this, value);
                    }
                    SimpleValidationHelper.validateCicsAllowableCharsForLength((String)((String)value), (int)16, null);
                }
                catch (RuntimeException ex) {
                    throw new IllegalAttributeException(ex.getMessage(), (IAttribute)this, value);
                }
            } else {
                throw new IllegalAttributeException("Should have been a string", (IAttribute)this, value);
            }
        }
    };
    public static final IAttribute FEED_TITLE = new Attribute("feedTitle", String.class, "feed"){

        public void validate(Object value) throws IllegalAttributeException {
            if (value instanceof String) {
                try {
                    SimpleValidationHelper.validateLatin1CharsOnly((String)((String)value), null);
                }
                catch (RuntimeException ex) {
                    throw new IllegalAttributeException(ex.getMessage(), (IAttribute)this, value);
                }
            } else {
                throw new IllegalAttributeException("Should have been a string", (IAttribute)this, value);
            }
        }
    };
    public static final IAttribute FEED_LINK_URI = new Attribute("feedLinkUri", String.class, "feed"){

        public void validate(Object value) throws IllegalAttributeException {
            if (value instanceof String) {
                try {
                    String valueString = (String)value;
                    if (valueString.isEmpty()) {
                        throw new IllegalAttributeException(Messages.getString("AtomConfigurationEditor.Field.Required"), (IAttribute)this, value);
                    }
                    SimpleValidationHelper.validateLatin1CharsOnly((String)valueString, null);
                }
                catch (RuntimeException ex) {
                    throw new IllegalAttributeException(ex.getMessage(), (IAttribute)this, value);
                }
            } else {
                throw new IllegalAttributeException("Should have been a string", (IAttribute)this, value);
            }
        }
    };
    public static final IAttribute FEED_WINDOW = new Attribute("feedWindow", Long.class, "feed"){

        public void validate(Object value) throws IllegalAttributeException {
            if (value instanceof Long) {
                try {
                    SimpleValidationHelper.validateMinMaxInclusive((Long)((Long)value), (long)1L, (long)Integer.MAX_VALUE);
                }
                catch (RuntimeException ex) {
                    throw new IllegalAttributeException(ex.getMessage(), (IAttribute)this, value);
                }
            } else {
                throw new IllegalAttributeException("Should have been a long", (IAttribute)this, value);
            }
        }
    };

    public static AtomConfigurationType getInstance() {
        return instance;
    }

    public IAttribute[] attributes() {
        return new IAttribute[]{ENTRY_LINK_URI, ENTRY_TITLE, FEED_LINK_URI, FEED_RESOURCE_NAME, FEED_RESOURCE_TYPE, FEED_TITLE, FEED_WINDOW, RESBIND_ROOT, RESBIND_XML_TRANSFORM_NAME, SERVICE_TYPE, URIMAP_TRANSID, URIMAP_URI, URIMAP_USERID};
    }

    public IAttribute findAttributeByID(String propertyId) {
        return null;
    }

    public Class<? extends ITypedObject> getInterfaceType() {
        return IAtomConfiguration.class;
    }
}

