/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.builders;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.DB2TransactionDefinitionType;
import com.ibm.cics.core.model.DefinitionBuilder;
import com.ibm.cics.core.model.builders.BuilderHelper;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSDefinitionContainer;
import com.ibm.cics.model.ICICSDefinitionReference;
import com.ibm.cics.model.IDB2TransactionDefinition;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableDB2TransactionDefinition;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class DB2TransactionDefinitionBuilder
extends DefinitionBuilder
implements IMutableDB2TransactionDefinition {
    private MutableSMRecord record = new MutableSMRecord("DB2TDEF");

    public DB2TransactionDefinitionBuilder(String _name, Long _version, String _DB2Entry, String _transaction) {
        this.setName(_name);
        this.setVersion(_version);
        this.setDB2Entry(_DB2Entry);
        this.setTransaction(_transaction);
    }

    public DB2TransactionDefinitionBuilder(String _name, Long _version, String _DB2Entry, String _transaction, IDB2TransactionDefinition anotherDef) throws Exception {
        this(_name, _version, _DB2Entry, _transaction);
        BuilderHelper.copyAttributes((IDefinition)anotherDef, this);
    }

    public ICICSDefinitionContainer getCICSContainer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SMConnectionRecord getRecord() {
        return this.record;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getRecord() + "]";
    }

    public void setVersion(Long _version) {
        String connectionSpecificExternalValue = null;
        if (_version != null && _version != DB2TransactionDefinitionType.VERSION.getUnsupportedValue()) {
            DB2TransactionDefinitionType.VERSION.validate((Object)_version);
            connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.VERSION).set(_version, this.record.getNormalizers());
        }
        this.record.set("DEFVER", connectionSpecificExternalValue);
    }

    public void setName(String _name) {
        String connectionSpecificExternalValue = null;
        if (_name != null && _name != DB2TransactionDefinitionType.NAME.getUnsupportedValue()) {
            DB2TransactionDefinitionType.NAME.validate((Object)_name);
            connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.NAME).set(_name, this.record.getNormalizers());
        }
        this.record.set("NAME", connectionSpecificExternalValue);
    }

    public void setDB2Entry(String _DB2Entry) {
        String connectionSpecificExternalValue = null;
        if (_DB2Entry != null && _DB2Entry != DB2TransactionDefinitionType.DB2_ENTRY.getUnsupportedValue()) {
            DB2TransactionDefinitionType.DB2_ENTRY.validate((Object)_DB2Entry);
            connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.DB2_ENTRY).set(_DB2Entry, this.record.getNormalizers());
        }
        this.record.set("ENTRY", connectionSpecificExternalValue);
    }

    public void setTransaction(String _transaction) {
        String connectionSpecificExternalValue = null;
        if (_transaction != null && _transaction != DB2TransactionDefinitionType.TRANSACTION.getUnsupportedValue()) {
            DB2TransactionDefinitionType.TRANSACTION.validate((Object)_transaction);
            connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.TRANSACTION).set(_transaction, this.record.getNormalizers());
        }
        this.record.set("TRANSID", connectionSpecificExternalValue);
    }

    public void setUserdata1(String _userdata1) {
        String connectionSpecificExternalValue = null;
        if (_userdata1 != null && _userdata1 != DB2TransactionDefinitionType.USERDATA_1.getUnsupportedValue()) {
            DB2TransactionDefinitionType.USERDATA_1.validate((Object)_userdata1);
            connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.USERDATA_1).set(_userdata1, this.record.getNormalizers());
        }
        this.record.set("USERDATA1", connectionSpecificExternalValue);
    }

    public void setUserdata2(String _userdata2) {
        String connectionSpecificExternalValue = null;
        if (_userdata2 != null && _userdata2 != DB2TransactionDefinitionType.USERDATA_2.getUnsupportedValue()) {
            DB2TransactionDefinitionType.USERDATA_2.validate((Object)_userdata2);
            connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.USERDATA_2).set(_userdata2, this.record.getNormalizers());
        }
        this.record.set("USERDATA2", connectionSpecificExternalValue);
    }

    public void setUserdata3(String _userdata3) {
        String connectionSpecificExternalValue = null;
        if (_userdata3 != null && _userdata3 != DB2TransactionDefinitionType.USERDATA_3.getUnsupportedValue()) {
            DB2TransactionDefinitionType.USERDATA_3.validate((Object)_userdata3);
            connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.USERDATA_3).set(_userdata3, this.record.getNormalizers());
        }
        this.record.set("USERDATA3", connectionSpecificExternalValue);
    }

    public void setDescription(String _description) {
        String connectionSpecificExternalValue = null;
        if (_description != null && _description != DB2TransactionDefinitionType.DESCRIPTION.getUnsupportedValue()) {
            DB2TransactionDefinitionType.DESCRIPTION.validate((Object)_description);
            connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.DESCRIPTION).set(_description, this.record.getNormalizers());
        }
        this.record.set("DESCRIPTION", connectionSpecificExternalValue);
    }

    public String getDB2Entry() {
        String result = this.record.get("ENTRY");
        return result == null ? null : (String)((CICSAttribute)DB2TransactionDefinitionType.DB2_ENTRY).get(result, this.record.getNormalizers());
    }

    public String getTransaction() {
        String result = this.record.get("TRANSID");
        return result == null ? null : (String)((CICSAttribute)DB2TransactionDefinitionType.TRANSACTION).get(result, this.record.getNormalizers());
    }

    public String getUserdata1() {
        String result = this.record.get("USERDATA1");
        return result == null ? null : (String)((CICSAttribute)DB2TransactionDefinitionType.USERDATA_1).get(result, this.record.getNormalizers());
    }

    public String getUserdata2() {
        String result = this.record.get("USERDATA2");
        return result == null ? null : (String)((CICSAttribute)DB2TransactionDefinitionType.USERDATA_2).get(result, this.record.getNormalizers());
    }

    public String getUserdata3() {
        String result = this.record.get("USERDATA3");
        return result == null ? null : (String)((CICSAttribute)DB2TransactionDefinitionType.USERDATA_3).get(result, this.record.getNormalizers());
    }

    @Override
    public String getDescription() {
        String result = this.record.get("DESCRIPTION");
        return result == null ? null : (String)((CICSAttribute)DB2TransactionDefinitionType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    @Override
    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == DB2TransactionDefinitionType.VERSION) {
            return (V)this.getVersion();
        }
        if (attribute == DB2TransactionDefinitionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == DB2TransactionDefinitionType.DB2_ENTRY) {
            return (V)this.getDB2Entry();
        }
        if (attribute == DB2TransactionDefinitionType.TRANSACTION) {
            return (V)this.getTransaction();
        }
        if (attribute == DB2TransactionDefinitionType.USERDATA_1) {
            return (V)this.getUserdata1();
        }
        if (attribute == DB2TransactionDefinitionType.USERDATA_2) {
            return (V)this.getUserdata2();
        }
        if (attribute == DB2TransactionDefinitionType.USERDATA_3) {
            return (V)this.getUserdata3();
        }
        throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not a valid attribute for type " + DB2TransactionDefinitionType.getInstance());
    }

    @Override
    public <V> void setAttributeValue(IAttribute<V> attribute, V value) {
        if (attribute == DB2TransactionDefinitionType.VERSION) {
            this.setVersion((Long)DB2TransactionDefinitionType.VERSION.getType().cast(value));
        } else if (attribute == DB2TransactionDefinitionType.NAME) {
            this.setName((String)DB2TransactionDefinitionType.NAME.getType().cast(value));
        } else if (attribute == DB2TransactionDefinitionType.DB2_ENTRY) {
            this.setDB2Entry((String)DB2TransactionDefinitionType.DB2_ENTRY.getType().cast(value));
        } else if (attribute == DB2TransactionDefinitionType.TRANSACTION) {
            this.setTransaction((String)DB2TransactionDefinitionType.TRANSACTION.getType().cast(value));
        } else if (attribute == DB2TransactionDefinitionType.USERDATA_1) {
            this.setUserdata1((String)DB2TransactionDefinitionType.USERDATA_1.getType().cast(value));
        } else if (attribute == DB2TransactionDefinitionType.USERDATA_2) {
            this.setUserdata2((String)DB2TransactionDefinitionType.USERDATA_2.getType().cast(value));
        } else if (attribute == DB2TransactionDefinitionType.USERDATA_3) {
            this.setUserdata3((String)DB2TransactionDefinitionType.USERDATA_3.getType().cast(value));
        } else if (attribute == DB2TransactionDefinitionType.DESCRIPTION) {
            this.setDescription((String)DB2TransactionDefinitionType.DESCRIPTION.getType().cast(value));
        } else {
            throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not settable for type " + DB2TransactionDefinitionType.getInstance());
        }
    }

    public DB2TransactionDefinitionType getObjectType() {
        return DB2TransactionDefinitionType.getInstance();
    }

    public ICICSDefinitionReference<IDB2TransactionDefinition> getCICSObjectReference() {
        return null;
    }
}

