/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.AbstractCICSResourceType;
import com.ibm.cics.core.model.CICSResourceReference;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CICSObject;
import com.ibm.cics.core.model.internal.CICSResourceContainer;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public abstract class CICSResource
extends CICSObject
implements ICICSResource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String REGION_NAME = "EYU_CICSNAME";
    private static final String CICS_RELEASE = "EYU_CICSREL";
    private final String regionName;
    private final String cicsRelease;
    private final ICICSResourceContainer container;

    public CICSResource(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context);
        this.container = new CICSResourceContainer(cpsm, context);
        this.regionName = record.get(REGION_NAME);
        this.cicsRelease = record.get(CICS_RELEASE);
    }

    public ICICSResourceContainer getCICSContainer() {
        return this.container;
    }

    @Override
    public abstract CICSResourceReference<? extends ICICSResource> getCICSObjectReference();

    public String getRegionName() {
        return this.regionName;
    }

    public String getCICSRelease() {
        return this.cicsRelease;
    }

    @Override
    public <T> T getAttributeValue(IAttribute<T> attribute) {
        if (AbstractCICSResourceType.REGION_NAME == attribute) {
            return (T)this.getRegionName();
        }
        if (AbstractCICSResourceType.CICS_RELEASE == attribute) {
            return (T)this.getCICSRelease();
        }
        throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not a valid attribute for type " + this);
    }
}

