/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.LibraryDSNameReference;
import com.ibm.cics.core.model.LibraryDSNameType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.ILibraryDSName;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class LibraryDSName
extends CICSResource
implements ILibraryDSName {
    private String _library;
    private Long _dsnum;
    private String _dsname;
    private Long _dsnsearchpos;
    private Long _searchpos;

    public LibraryDSName(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("LIBRARY");
        this._library = (String)((CICSAttribute)LibraryDSNameType.NAME).get(stringValue, normalizers);
        stringValue = record.get("DSNUM");
        this._dsnum = (Long)((CICSAttribute)LibraryDSNameType.DS_NUMBER).get(stringValue, normalizers);
        stringValue = record.get("DSNAME");
        this._dsname = (String)((CICSAttribute)LibraryDSNameType.DS_NAME).get(stringValue, normalizers);
        stringValue = record.get("DSNSEARCHPOS");
        this._dsnsearchpos = (Long)((CICSAttribute)LibraryDSNameType.DS_NAME_SEARCH_POSITION).get(stringValue, normalizers);
        stringValue = record.get("SEARCHPOS");
        this._searchpos = (Long)((CICSAttribute)LibraryDSNameType.SEARCH_POSITION).get(stringValue, normalizers);
    }

    public String getName() {
        return this._library;
    }

    public Long getDSNumber() {
        return this._dsnum;
    }

    public String getDSName() {
        return this._dsname;
    }

    public Long getDSNameSearchPosition() {
        return this._dsnsearchpos;
    }

    public Long getSearchPosition() {
        return this._searchpos;
    }

    public LibraryDSNameType getObjectType() {
        return LibraryDSNameType.getInstance();
    }

    @Override
    public LibraryDSNameReference getCICSObjectReference() {
        return new LibraryDSNameReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == LibraryDSNameType.NAME) {
            return (V)this.getName();
        }
        if (attribute == LibraryDSNameType.DS_NUMBER) {
            return (V)this.getDSNumber();
        }
        if (attribute == LibraryDSNameType.DS_NAME) {
            return (V)this.getDSName();
        }
        if (attribute == LibraryDSNameType.DS_NAME_SEARCH_POSITION) {
            return (V)this.getDSNameSearchPosition();
        }
        if (attribute == LibraryDSNameType.SEARCH_POSITION) {
            return (V)this.getSearchPosition();
        }
        return super.getAttributeValue(attribute);
    }
}

