/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.OSGiBundleReference;
import com.ibm.cics.core.model.OSGiBundleType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.IOSGiBundle;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;
import java.util.Map;

public class OSGiBundle
extends CICSResource
implements IOSGiBundle {
    private String _osgibund;
    private IOSGiBundle.ChangeAgentValue _changeagent;
    private String _changeagrel;
    private String _changeusrid;
    private String _definesource;
    private IOSGiBundle.InstallAgentValue _installagent;
    private String _installusrid;
    private IOSGiBundle.OsgiStateValue _osgistatus;
    private Date _definetime;
    private Date _changetime;
    private Date _installtime;
    private Long _osgibundleid;
    private String _bundlepart;
    private String _jvmserver;
    private String _bundle;
    private String _osgiversion;

    public OSGiBundle(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("OSGIBUND");
        this._osgibund = (String)((CICSAttribute)OSGiBundleType.SYMBOLIC_NAME).get(stringValue, normalizers);
        stringValue = record.get("CHANGEAGENT");
        this._changeagent = (IOSGiBundle.ChangeAgentValue)((CICSAttribute)OSGiBundleType.CHANGE_AGENT).get(stringValue, normalizers);
        stringValue = record.get("CHANGEAGREL");
        this._changeagrel = (String)((CICSAttribute)OSGiBundleType.CHANGE_AGENT_RELEASE).get(stringValue, normalizers);
        stringValue = record.get("CHANGEUSRID");
        this._changeusrid = (String)((CICSAttribute)OSGiBundleType.CHANGE_USER_ID).get(stringValue, normalizers);
        stringValue = record.get("DEFINESOURCE");
        this._definesource = (String)((CICSAttribute)OSGiBundleType.DEFINE_SOURCE).get(stringValue, normalizers);
        stringValue = record.get("INSTALLAGENT");
        this._installagent = (IOSGiBundle.InstallAgentValue)((CICSAttribute)OSGiBundleType.INSTALL_AGENT).get(stringValue, normalizers);
        stringValue = record.get("INSTALLUSRID");
        this._installusrid = (String)((CICSAttribute)OSGiBundleType.INSTALL_USER_ID).get(stringValue, normalizers);
        stringValue = record.get("OSGISTATUS");
        this._osgistatus = (IOSGiBundle.OsgiStateValue)((CICSAttribute)OSGiBundleType.OSGI_STATE).get(stringValue, normalizers);
        stringValue = record.get("DEFINETIME");
        this._definetime = (Date)((CICSAttribute)OSGiBundleType.DEFINE_TIME).get(stringValue, normalizers);
        stringValue = record.get("CHANGETIME");
        this._changetime = (Date)((CICSAttribute)OSGiBundleType.CHANGE_TIME).get(stringValue, normalizers);
        stringValue = record.get("INSTALLTIME");
        this._installtime = (Date)((CICSAttribute)OSGiBundleType.INSTALL_TIME).get(stringValue, normalizers);
        stringValue = record.get("OSGIBUNDLEID");
        this._osgibundleid = (Long)((CICSAttribute)OSGiBundleType.BUNDLE_ID).get(stringValue, normalizers);
        stringValue = record.get("BUNDLEPART");
        this._bundlepart = (String)((CICSAttribute)OSGiBundleType.BUNDLE_PART).get(stringValue, normalizers);
        stringValue = record.get("JVMSERVER");
        this._jvmserver = (String)((CICSAttribute)OSGiBundleType.JVM_SERVER).get(stringValue, normalizers);
        stringValue = record.get("BUNDLE");
        this._bundle = (String)((CICSAttribute)OSGiBundleType.BUNDLE).get(stringValue, normalizers);
        stringValue = record.get("OSGIVERSION");
        this._osgiversion = (String)((CICSAttribute)OSGiBundleType.OSGI_VERSION).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return OSGiBundleType.SYMBOLIC_NAME.internalToExternal((Object)this.getSymbolicName());
        }
        catch (IllegalCICSAttributeException illegalCICSAttributeException) {
            return "";
        }
    }

    public String getSymbolicName() {
        return this._osgibund;
    }

    public IOSGiBundle.ChangeAgentValue getChangeAgent() {
        return this._changeagent;
    }

    public String getChangeAgentRelease() {
        return this._changeagrel;
    }

    public String getChangeUserID() {
        return this._changeusrid;
    }

    public String getDefineSource() {
        return this._definesource;
    }

    public IOSGiBundle.InstallAgentValue getInstallAgent() {
        return this._installagent;
    }

    public String getInstallUserID() {
        return this._installusrid;
    }

    public IOSGiBundle.OsgiStateValue getOsgiState() {
        return this._osgistatus;
    }

    public Date getDefineTime() {
        return this._definetime;
    }

    public Date getChangeTime() {
        return this._changetime;
    }

    public Date getInstallTime() {
        return this._installtime;
    }

    public Long getBundleId() {
        return this._osgibundleid;
    }

    public String getBundlePart() {
        return this._bundlepart;
    }

    public String getJvmServer() {
        return this._jvmserver;
    }

    public String getBundle() {
        return this._bundle;
    }

    public String getOsgiVersion() {
        return this._osgiversion;
    }

    public OSGiBundleType getObjectType() {
        return OSGiBundleType.getInstance();
    }

    @Override
    public OSGiBundleReference getCICSObjectReference() {
        return new OSGiBundleReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == OSGiBundleType.SYMBOLIC_NAME) {
            return (V)this.getSymbolicName();
        }
        if (attribute == OSGiBundleType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == OSGiBundleType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == OSGiBundleType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == OSGiBundleType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == OSGiBundleType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == OSGiBundleType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == OSGiBundleType.OSGI_STATE) {
            return (V)this.getOsgiState();
        }
        if (attribute == OSGiBundleType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == OSGiBundleType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == OSGiBundleType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == OSGiBundleType.BUNDLE_ID) {
            return (V)this.getBundleId();
        }
        if (attribute == OSGiBundleType.BUNDLE_PART) {
            return (V)this.getBundlePart();
        }
        if (attribute == OSGiBundleType.JVM_SERVER) {
            return (V)this.getJvmServer();
        }
        if (attribute == OSGiBundleType.BUNDLE) {
            return (V)this.getBundle();
        }
        if (attribute == OSGiBundleType.OSGI_VERSION) {
            return (V)this.getOsgiVersion();
        }
        return super.getAttributeValue(attribute);
    }
}

