/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.OSGiServiceReference;
import com.ibm.cics.core.model.OSGiServiceType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.IOSGiService;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class OSGiService
extends CICSResource
implements IOSGiService {
    private Long _osgiservice;
    private IOSGiService.ServiceStatusValue _srvcstatus;
    private String _jvmserver;
    private String _bundle;
    private String _bundlepart;
    private String _osgiversion;
    private String _osgibundle;
    private String _srvcname;

    public OSGiService(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("OSGISERVICE");
        this._osgiservice = (Long)((CICSAttribute)OSGiServiceType.SERVICE_ID).get(stringValue, normalizers);
        stringValue = record.get("SRVCSTATUS");
        this._srvcstatus = (IOSGiService.ServiceStatusValue)((CICSAttribute)OSGiServiceType.SERVICE_STATUS).get(stringValue, normalizers);
        stringValue = record.get("JVMSERVER");
        this._jvmserver = (String)((CICSAttribute)OSGiServiceType.JVM_SERVER).get(stringValue, normalizers);
        stringValue = record.get("BUNDLE");
        this._bundle = (String)((CICSAttribute)OSGiServiceType.BUNDLE).get(stringValue, normalizers);
        stringValue = record.get("BUNDLEPART");
        this._bundlepart = (String)((CICSAttribute)OSGiServiceType.BUNDLE_PART).get(stringValue, normalizers);
        stringValue = record.get("OSGIVERSION");
        this._osgiversion = (String)((CICSAttribute)OSGiServiceType.OSGI_VERSION).get(stringValue, normalizers);
        stringValue = record.get("OSGIBUNDLE");
        this._osgibundle = (String)((CICSAttribute)OSGiServiceType.OSGI_BUNDLE).get(stringValue, normalizers);
        stringValue = record.get("SRVCNAME");
        this._srvcname = (String)((CICSAttribute)OSGiServiceType.SERVICE_NAME).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return OSGiServiceType.SERVICE_NAME.internalToExternal((Object)this.getServiceName());
        }
        catch (IllegalCICSAttributeException illegalCICSAttributeException) {
            return "";
        }
    }

    public Long getServiceId() {
        return this._osgiservice;
    }

    public IOSGiService.ServiceStatusValue getServiceStatus() {
        return this._srvcstatus;
    }

    public String getJvmServer() {
        return this._jvmserver;
    }

    public String getBundle() {
        return this._bundle;
    }

    public String getBundlePart() {
        return this._bundlepart;
    }

    public String getOsgiVersion() {
        return this._osgiversion;
    }

    public String getOsgiBundle() {
        return this._osgibundle;
    }

    public String getServiceName() {
        return this._srvcname;
    }

    public OSGiServiceType getObjectType() {
        return OSGiServiceType.getInstance();
    }

    @Override
    public OSGiServiceReference getCICSObjectReference() {
        return new OSGiServiceReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == OSGiServiceType.SERVICE_ID) {
            return (V)this.getServiceId();
        }
        if (attribute == OSGiServiceType.SERVICE_STATUS) {
            return (V)this.getServiceStatus();
        }
        if (attribute == OSGiServiceType.JVM_SERVER) {
            return (V)this.getJvmServer();
        }
        if (attribute == OSGiServiceType.BUNDLE) {
            return (V)this.getBundle();
        }
        if (attribute == OSGiServiceType.BUNDLE_PART) {
            return (V)this.getBundlePart();
        }
        if (attribute == OSGiServiceType.OSGI_VERSION) {
            return (V)this.getOsgiVersion();
        }
        if (attribute == OSGiServiceType.OSGI_BUNDLE) {
            return (V)this.getOsgiBundle();
        }
        if (attribute == OSGiServiceType.SERVICE_NAME) {
            return (V)this.getServiceName();
        }
        return super.getAttributeValue(attribute);
    }
}

