/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.RPLListReference;
import com.ibm.cics.core.model.RPLListType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.IRPLList;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class RPLList
extends CICSResource
implements IRPLList {
    private Long _rplnum;
    private String _dsname;

    public RPLList(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("RPLNUM");
        this._rplnum = (Long)((CICSAttribute)RPLListType.RPL_NUMBER).get(stringValue, normalizers);
        stringValue = record.get("DSNAME");
        this._dsname = (String)((CICSAttribute)RPLListType.DS_NAME).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return RPLListType.RPL_NUMBER.internalToExternal((Object)this.getRPLNumber());
        }
        catch (IllegalCICSAttributeException illegalCICSAttributeException) {
            return "";
        }
    }

    public Long getRPLNumber() {
        return this._rplnum;
    }

    public String getDSName() {
        return this._dsname;
    }

    public RPLListType getObjectType() {
        return RPLListType.getInstance();
    }

    @Override
    public RPLListReference getCICSObjectReference() {
        return new RPLListReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == RPLListType.RPL_NUMBER) {
            return (V)this.getRPLNumber();
        }
        if (attribute == RPLListType.DS_NAME) {
            return (V)this.getDSName();
        }
        return super.getAttributeValue(attribute);
    }
}

