/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WorkloadTargetReference;
import com.ibm.cics.core.model.WorkloadTargetType;
import com.ibm.cics.core.model.internal.CPSMManager;
import com.ibm.cics.model.IWorkloadTarget;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public abstract class WorkloadTargetGen
extends CPSMManager
implements IWorkloadTarget {
    private String _workload;
    private String _aor;
    private IWorkloadTarget.StatusValue _status;
    private IWorkloadTarget.ContactStatusValue _con_status;
    private String _wrklowner;
    private Long _readrs;
    private Long _updaters;
    private Long _wlmthrsh;
    private IWorkloadTarget.TaskLoadQueueModeValue _wlmqmode;
    private Long _taskinc;
    private Long _taskload;
    private IWorkloadTarget.OptimizationStatusValue _owstate;
    private IWorkloadTarget.HealthShortOnStorageValue _hlthsos;
    private IWorkloadTarget.HealthStallValue _hlthstall;
    private IWorkloadTarget.HealthDumpValue _hlthdump;
    private IWorkloadTarget.HealthMaxtasksValue _hlthmaxt;
    private Long _routingload;
    private Long _maxtasks;
    private Long _routewght;
    private Long _cfupdcnt;
    private IWorkloadTarget.EventsValue _events;
    private String _rspoolid;
    private IWorkloadTarget.HealthMasNonresponsiveValue _hlthnrm;
    private String _cpsmver;
    private String _rptcmas;
    private Long _wlmhlth;

    public WorkloadTargetGen(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("WORKLOAD");
        this._workload = (String)((CICSAttribute)WorkloadTargetType.WORKLOAD).get(stringValue, normalizers);
        stringValue = record.get("AOR");
        this._aor = (String)((CICSAttribute)WorkloadTargetType.TARGET_REGION).get(stringValue, normalizers);
        stringValue = record.get("STATUS");
        this._status = (IWorkloadTarget.StatusValue)((CICSAttribute)WorkloadTargetType.STATUS).get(stringValue, normalizers);
        stringValue = record.get("CON_STATUS");
        this._con_status = (IWorkloadTarget.ContactStatusValue)((CICSAttribute)WorkloadTargetType.CONTACT_STATUS).get(stringValue, normalizers);
        stringValue = record.get("WRKLOWNER");
        this._wrklowner = (String)((CICSAttribute)WorkloadTargetType.WORKLOAD_OWNER).get(stringValue, normalizers);
        stringValue = record.get("READRS");
        this._readrs = (Long)((CICSAttribute)WorkloadTargetType.RS_SERVER_READ_INTERVAL).get(stringValue, normalizers);
        stringValue = record.get("UPDATERS");
        this._updaters = (Long)((CICSAttribute)WorkloadTargetType.RS_SERVER_UPDATE_FREQ).get(stringValue, normalizers);
        stringValue = record.get("WLMTHRSH");
        this._wlmthrsh = (Long)((CICSAttribute)WorkloadTargetType.TASK_LOAD_HEALTH_THRESHOLD).get(stringValue, normalizers);
        stringValue = record.get("WLMQMODE");
        this._wlmqmode = (IWorkloadTarget.TaskLoadQueueModeValue)((CICSAttribute)WorkloadTargetType.TASK_LOAD_QUEUE_MODE).get(stringValue, normalizers);
        stringValue = record.get("TASKINC");
        this._taskinc = (Long)((CICSAttribute)WorkloadTargetType.TASK_COUNT_INCREMENT).get(stringValue, normalizers);
        stringValue = record.get("TASKLOAD");
        this._taskload = (Long)((CICSAttribute)WorkloadTargetType.TASK_LOAD).get(stringValue, normalizers);
        stringValue = record.get("OWSTATE");
        this._owstate = (IWorkloadTarget.OptimizationStatusValue)((CICSAttribute)WorkloadTargetType.OPTIMIZATION_STATUS).get(stringValue, normalizers);
        stringValue = record.get("HLTHSOS");
        this._hlthsos = (IWorkloadTarget.HealthShortOnStorageValue)((CICSAttribute)WorkloadTargetType.HEALTH_SHORT_ON_STORAGE).get(stringValue, normalizers);
        stringValue = record.get("HLTHSTALL");
        this._hlthstall = (IWorkloadTarget.HealthStallValue)((CICSAttribute)WorkloadTargetType.HEALTH_STALL).get(stringValue, normalizers);
        stringValue = record.get("HLTHDUMP");
        this._hlthdump = (IWorkloadTarget.HealthDumpValue)((CICSAttribute)WorkloadTargetType.HEALTH_DUMP).get(stringValue, normalizers);
        stringValue = record.get("HLTHMAXT");
        this._hlthmaxt = (IWorkloadTarget.HealthMaxtasksValue)((CICSAttribute)WorkloadTargetType.HEALTH_MAXTASKS).get(stringValue, normalizers);
        stringValue = record.get("ROUTINGLOAD");
        this._routingload = (Long)((CICSAttribute)WorkloadTargetType.ROUTING_LOAD).get(stringValue, normalizers);
        stringValue = record.get("MAXTASKS");
        this._maxtasks = (Long)((CICSAttribute)WorkloadTargetType.MAXTASKS).get(stringValue, normalizers);
        stringValue = record.get("ROUTEWGHT");
        this._routewght = (Long)((CICSAttribute)WorkloadTargetType.ROUTING_WEIGHT).get(stringValue, normalizers);
        stringValue = record.get("CFUPDCNT");
        this._cfupdcnt = (Long)((CICSAttribute)WorkloadTargetType.CF_UPDATE_COUNT).get(stringValue, normalizers);
        stringValue = record.get("EVENTS");
        this._events = (IWorkloadTarget.EventsValue)((CICSAttribute)WorkloadTargetType.EVENTS).get(stringValue, normalizers);
        stringValue = record.get("RSPOOLID");
        this._rspoolid = (String)((CICSAttribute)WorkloadTargetType.RS_SERVER_POOL_ID).get(stringValue, normalizers);
        stringValue = record.get("HLTHNRM");
        this._hlthnrm = (IWorkloadTarget.HealthMasNonresponsiveValue)((CICSAttribute)WorkloadTargetType.HEALTH_MAS_NONRESPONSIVE).get(stringValue, normalizers);
        stringValue = record.get("CPSMVER");
        this._cpsmver = (String)((CICSAttribute)WorkloadTargetType.CPSMVER).get(stringValue, normalizers);
        stringValue = record.get("RPTCMAS");
        this._rptcmas = (String)((CICSAttribute)WorkloadTargetType.RPTCMAS).get(stringValue, normalizers);
        stringValue = record.get("WLMHLTH");
        this._wlmhlth = (Long)((CICSAttribute)WorkloadTargetType.HEALTH_INDICATOR).get(stringValue, normalizers);
    }

    public String getWorkload() {
        return this._workload;
    }

    public String getTargetRegion() {
        return this._aor;
    }

    public IWorkloadTarget.StatusValue getStatus() {
        return this._status;
    }

    public IWorkloadTarget.ContactStatusValue getContactStatus() {
        return this._con_status;
    }

    public String getWorkloadOwner() {
        return this._wrklowner;
    }

    public Long getRsServerReadInterval() {
        return this._readrs;
    }

    public Long getRsServerUpdateFreq() {
        return this._updaters;
    }

    public Long getTaskLoadHealthThreshold() {
        return this._wlmthrsh;
    }

    public IWorkloadTarget.TaskLoadQueueModeValue getTaskLoadQueueMode() {
        return this._wlmqmode;
    }

    public Long getTaskCountIncrement() {
        return this._taskinc;
    }

    public Long getTaskLoad() {
        return this._taskload;
    }

    public IWorkloadTarget.OptimizationStatusValue getOptimizationStatus() {
        return this._owstate;
    }

    public IWorkloadTarget.HealthShortOnStorageValue getHealthShortOnStorage() {
        return this._hlthsos;
    }

    public IWorkloadTarget.HealthStallValue getHealthStall() {
        return this._hlthstall;
    }

    public IWorkloadTarget.HealthDumpValue getHealthDump() {
        return this._hlthdump;
    }

    public IWorkloadTarget.HealthMaxtasksValue getHealthMaxtasks() {
        return this._hlthmaxt;
    }

    public Long getRoutingLoad() {
        return this._routingload;
    }

    public Long getMaxtasks() {
        return this._maxtasks;
    }

    public Long getRoutingWeight() {
        return this._routewght;
    }

    public Long getCfUpdateCount() {
        return this._cfupdcnt;
    }

    public IWorkloadTarget.EventsValue getEvents() {
        return this._events;
    }

    public String getRsServerPoolId() {
        return this._rspoolid;
    }

    public IWorkloadTarget.HealthMasNonresponsiveValue getHealthMasNonresponsive() {
        return this._hlthnrm;
    }

    public String getCpsmver() {
        return this._cpsmver;
    }

    public String getRptcmas() {
        return this._rptcmas;
    }

    public Long getHealthIndicator() {
        return this._wlmhlth;
    }

    public WorkloadTargetType getObjectType() {
        return WorkloadTargetType.getInstance();
    }

    @Override
    public WorkloadTargetReference getCICSObjectReference() {
        return new WorkloadTargetReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WorkloadTargetType.WORKLOAD) {
            return (V)this.getWorkload();
        }
        if (attribute == WorkloadTargetType.TARGET_REGION) {
            return (V)this.getTargetRegion();
        }
        if (attribute == WorkloadTargetType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == WorkloadTargetType.CONTACT_STATUS) {
            return (V)this.getContactStatus();
        }
        if (attribute == WorkloadTargetType.WORKLOAD_OWNER) {
            return (V)this.getWorkloadOwner();
        }
        if (attribute == WorkloadTargetType.RS_SERVER_READ_INTERVAL) {
            return (V)this.getRsServerReadInterval();
        }
        if (attribute == WorkloadTargetType.RS_SERVER_UPDATE_FREQ) {
            return (V)this.getRsServerUpdateFreq();
        }
        if (attribute == WorkloadTargetType.TASK_LOAD_HEALTH_THRESHOLD) {
            return (V)this.getTaskLoadHealthThreshold();
        }
        if (attribute == WorkloadTargetType.TASK_LOAD_QUEUE_MODE) {
            return (V)this.getTaskLoadQueueMode();
        }
        if (attribute == WorkloadTargetType.TASK_COUNT_INCREMENT) {
            return (V)this.getTaskCountIncrement();
        }
        if (attribute == WorkloadTargetType.TASK_LOAD) {
            return (V)this.getTaskLoad();
        }
        if (attribute == WorkloadTargetType.OPTIMIZATION_STATUS) {
            return (V)this.getOptimizationStatus();
        }
        if (attribute == WorkloadTargetType.HEALTH_SHORT_ON_STORAGE) {
            return (V)this.getHealthShortOnStorage();
        }
        if (attribute == WorkloadTargetType.HEALTH_STALL) {
            return (V)this.getHealthStall();
        }
        if (attribute == WorkloadTargetType.HEALTH_DUMP) {
            return (V)this.getHealthDump();
        }
        if (attribute == WorkloadTargetType.HEALTH_MAXTASKS) {
            return (V)this.getHealthMaxtasks();
        }
        if (attribute == WorkloadTargetType.ROUTING_LOAD) {
            return (V)this.getRoutingLoad();
        }
        if (attribute == WorkloadTargetType.MAXTASKS) {
            return (V)this.getMaxtasks();
        }
        if (attribute == WorkloadTargetType.ROUTING_WEIGHT) {
            return (V)this.getRoutingWeight();
        }
        if (attribute == WorkloadTargetType.CF_UPDATE_COUNT) {
            return (V)this.getCfUpdateCount();
        }
        if (attribute == WorkloadTargetType.EVENTS) {
            return (V)this.getEvents();
        }
        if (attribute == WorkloadTargetType.RS_SERVER_POOL_ID) {
            return (V)this.getRsServerPoolId();
        }
        if (attribute == WorkloadTargetType.HEALTH_MAS_NONRESPONSIVE) {
            return (V)this.getHealthMasNonresponsive();
        }
        if (attribute == WorkloadTargetType.CPSMVER) {
            return (V)this.getCpsmver();
        }
        if (attribute == WorkloadTargetType.RPTCMAS) {
            return (V)this.getRptcmas();
        }
        if (attribute == WorkloadTargetType.HEALTH_INDICATOR) {
            return (V)this.getHealthIndicator();
        }
        return super.getAttributeValue(attribute);
    }
}

