/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IActiveConnectionCategoryListener;
import com.ibm.cics.core.connections.IActiveConnectionCategoryService;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.IConnectionStateViewer;
import com.ibm.cics.core.connections.internal.ConnectedState;
import com.ibm.cics.core.connections.internal.ConnectionService;
import com.ibm.cics.core.connections.internal.DisconnectedState;
import com.ibm.cics.core.connections.internal.FilteredConnectionRegistry;
import com.ibm.cics.core.connections.internal.IConnectionStatusController;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.core.connections.internal.NoConnection;
import com.ibm.cics.core.connections.internal.views.CreateConnectionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

@Deprecated
public class ConnectionWidgetManager
implements IActiveConnectionCategoryService {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2011, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug debug = new Debug(ConnectionWidgetManager.class);
    private boolean dialogMode;
    private ConnectionManagerListener connectionManagerListener = new ConnectionManagerListener(){

        public void event(ConnectionManagerListener.ConnectionManagerEvent event) {
            ConnectionWidgetManager.this.update(event.getConnectionProfile().getConnectionDescriptor().getCategory().getId());
        }
    };
    private ConnectionServiceListener connectionServiceListener = new ConnectionServiceListener(){

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            debug.enter("event", (Object)event);
            IConnectionState newState = ConnectionWidgetManager.this.connectionService.getConnectionState(ConnectionWidgetManager.this.currentCategory);
            ConnectionWidgetManager.this.setState(event.getConnectionCategoryId(), newState);
            debug.exit("event", (Object)event);
        }
    };
    private SelectionListener connectionItemSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MenuItem menuItem = (MenuItem)e.getSource();
            IConnectionState state = ConnectionWidgetManager.this.connectionService.getConnectionState(ConnectionWidgetManager.this.currentCategory);
            if (menuItem.getData(IConnectionState.class.getName()) instanceof ConnectedState) {
                boolean sameConnectedStateSelected;
                ConnectedState menuConnectedState = (ConnectedState)menuItem.getData(IConnectionState.class.getName());
                boolean bl = sameConnectedStateSelected = state instanceof ConnectedState && ((ConnectedState)state).getConnection().getConfiguration().equals((Object)menuConnectedState.getConnection().getConfiguration());
                if (!sameConnectedStateSelected && ConnectionWidgetManager.this.connectionService instanceof ConnectionService) {
                    ((ConnectionService)ConnectionWidgetManager.this.connectionService).switchToAlreadyConnected(menuConnectedState.getConnection(), (ConnectionProfile)menuItem.getData(ConnectionProfile.class.getName()));
                }
            } else if (menuItem.getData(ConnectionProfile.class.getName()) instanceof ConnectionProfile) {
                ConnectionProfile config = (ConnectionProfile)menuItem.getData(ConnectionProfile.class.getName());
                ConnectionWidgetManager.this.connectionService.connectAsync(config.getId());
            }
        }
    };
    private String currentCategory = "com.ibm.cics.sm.connection";
    private ListenerList activeConnectionCategoryListeners = new ListenerList();
    private Map<String, Map<String, IConnectionState>> additionalConnectedStates = new HashMap<String, Map<String, IConnectionState>>();
    private IConnectionService connectionService;
    private IConnectionStateViewer connectionStateViewer;
    private IConnectionStatusController connectionStatusController;
    private Comparator<IConnectionDescriptor> descriptorComparator = new Comparator<IConnectionDescriptor>(){

        @Override
        public int compare(IConnectionDescriptor d1, IConnectionDescriptor d2) {
            return d1.getName().compareTo(d2.getName());
        }
    };
    private Comparator<ConnectionProfile> configurationComparator = new Comparator<ConnectionProfile>(){

        @Override
        public int compare(ConnectionProfile c1, ConnectionProfile c2) {
            return c1.getName().compareTo(c2.getName());
        }
    };

    public ConnectionWidgetManager(IConnectionService connectionService) {
        this(connectionService, false);
    }

    public ConnectionWidgetManager(IConnectionService connectionService, boolean isInDialog) {
        this.connectionService = connectionService;
        connectionService.addConnectionServiceListener(this.connectionServiceListener);
        connectionService.getConnectionManager().addListener(this.connectionManagerListener);
        this.dialogMode = isInDialog;
        this.initializeStates();
    }

    public void dispose() {
        this.connectionServiceListener.makeStale();
        this.connectionManagerListener.makeStale();
    }

    @Override
    public void addActiveConnectionCategoryListener(IActiveConnectionCategoryListener listener) {
        this.activeConnectionCategoryListeners.add((Object)listener);
    }

    @Override
    public void removeActiveConnectionCategoryListener(IActiveConnectionCategoryListener listener) {
        this.activeConnectionCategoryListeners.add((Object)listener);
    }

    private void notifyActiveConnectionCategoryListeners(final String newConnectionCategory) {
        Object[] objectArray = this.activeConnectionCategoryListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IActiveConnectionCategoryListener)listener).currentConnectionCategory(newConnectionCategory);
                }

                public void handleException(Throwable exception) {
                    debug.warning("notifyActiveConnectionCategoryListener", "Listener \"" + listener + "\" threw an exception and was disabled", exception);
                    ConnectionWidgetManager.this.activeConnectionCategoryListeners.remove(listener);
                }
            });
            ++n2;
        }
    }

    private void initializeStates() {
        debug.enter("initializeStates");
        for (IConnectionCategory category : this.connectionService.getConnectionCategories()) {
            this.additionalConnectedStates.put(category.getId(), new HashMap());
        }
        debug.exit("initializeStates");
    }

    public void setConnectionStateViewer(IConnectionStateViewer connectionStateViewer) {
        this.connectionStateViewer = connectionStateViewer;
        this.update();
    }

    private void setState(String connectionCategoryId, IConnectionState newConnectionState) {
        debug.enter("setState", (Object)newConnectionState);
        if (connectionCategoryId.equals(this.currentCategory)) {
            this.update();
        }
        if (newConnectionState.getConnectionProfile() != null) {
            Map<String, IConnectionState> multipleConnectedStates = this.additionalConnectedStates.get(connectionCategoryId);
            if (newConnectionState instanceof ConnectedState) {
                multipleConnectedStates.put(newConnectionState.getID(), newConnectionState);
            } else if (newConnectionState instanceof DisconnectedState) {
                multipleConnectedStates.remove(newConnectionState.getID());
            }
        }
        debug.exit("setState", (Object)newConnectionState);
    }

    private void update(String connectionCategory) {
        debug.enter("update", (Object)connectionCategory);
        if (connectionCategory.equals(this.currentCategory)) {
            (Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault()).asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ConnectionWidgetManager.this.connectionStateViewer != null) {
                        ConnectionWidgetManager.this.connectionStateViewer.showState(ConnectionWidgetManager.this.connectionService.getConnectionState(ConnectionWidgetManager.this.currentCategory));
                        ConnectionWidgetManager.this.connectionStateViewer.setConnectionCategory(ConnectionWidgetManager.this.currentCategory);
                    }
                }
            });
        }
        debug.exit("update", (Object)connectionCategory);
    }

    private void update() {
        (Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault()).asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ConnectionWidgetManager.this.connectionStateViewer != null) {
                    ConnectionWidgetManager.this.connectionStateViewer.showState(ConnectionWidgetManager.this.connectionService.getConnectionState(ConnectionWidgetManager.this.currentCategory));
                    ConnectionWidgetManager.this.connectionStateViewer.setConnectionCategory(ConnectionWidgetManager.this.currentCategory);
                }
            }
        });
    }

    public IConnectionStatusController getConnectionStatusController() {
        if (this.connectionStatusController == null) {
            this.connectionStatusController = new ConnectionStatusController();
        }
        return this.connectionStatusController;
    }

    public void setCurrentCategory(String aCategory) {
        this.currentCategory = aCategory;
        this.update();
        this.notifyActiveConnectionCategoryListeners(this.currentCategory);
    }

    private Map<IConnectionDescriptor, List<ConnectionProfile>> sort(Map<IConnectionDescriptor, List<ConnectionProfile>> unsortedMap) {
        TreeMap<IConnectionDescriptor, List<ConnectionProfile>> sortedResult = new TreeMap<IConnectionDescriptor, List<ConnectionProfile>>(this.descriptorComparator);
        for (IConnectionDescriptor key : unsortedMap.keySet()) {
            List<ConnectionProfile> unsortedConfigs = unsortedMap.get(key);
            ArrayList<ConnectionProfile> sortedConfigs = new ArrayList<ConnectionProfile>();
            sortedConfigs.addAll(unsortedConfigs);
            Collections.sort(sortedConfigs, this.configurationComparator);
            sortedResult.put(key, sortedConfigs);
        }
        return sortedResult;
    }

    @Override
    public String getActiveConnectionCategory() {
        return this.currentCategory;
    }

    public boolean isDialogMode() {
        return this.dialogMode;
    }

    public void setDialogMode(boolean dialogMode) {
        this.dialogMode = dialogMode;
    }

    private class ConnectionStatusController
    implements IConnectionStatusController {
        private ConnectionStatusController() {
        }

        @Override
        public void toggleSelectionState() {
            IConnectionState currentState = ConnectionWidgetManager.this.connectionService.getConnectionState(ConnectionWidgetManager.this.currentCategory);
            debug.enter("toggleSelectionState", (Object)currentState);
            if (!(currentState instanceof NoConnection)) {
                if (currentState instanceof ConnectedState) {
                    ConnectionWidgetManager.this.connectionService.disconnectAsync(ConnectionWidgetManager.this.currentCategory);
                } else {
                    ConnectionWidgetManager.this.connectionService.connectAsync(currentState.getID());
                }
            }
            debug.exit("toggleSelectionState", (Object)("currentState: " + currentState));
        }

        @Override
        public void fillConnectionsMenu(Menu connectionsMenu) {
            MenuItem[] items;
            debug.enter("fillConnectionsMenu", (Object)connectionsMenu);
            MenuItem[] menuItemArray = items = connectionsMenu.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                item.dispose();
                ++n2;
            }
            if (!ConnectionWidgetManager.this.isDialogMode()) {
                MenuItem createMenuItem = new MenuItem(connectionsMenu, 0);
                createMenuItem.setImage(ConnectionsImages.getImage("MANAGE_CONNECTIONS"));
                createMenuItem.setText(Messages.ManageConnections_dsc);
                createMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ConnectionsPlugin.getDefault().getConnectionUserInterfaceService().manageConnections();
                    }
                });
            }
            Map<IConnectionDescriptor, List<ConnectionProfile>> connections = new HashMap();
            FilteredConnectionRegistry filteredRegistry = new FilteredConnectionRegistry(ConnectionRegistry.getConnectionRegistry());
            IConnectionCategory connectionCategory = ConnectionRegistry.getConnectionRegistry().getConnectionCategory(ConnectionWidgetManager.this.currentCategory);
            IConnectionDescriptor[] iConnectionDescriptorArray = connectionCategory.getConnections();
            int n3 = iConnectionDescriptorArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConnectionDescriptor connectionDescriptor = iConnectionDescriptorArray[n4];
                if (filteredRegistry.find(connectionDescriptor.getId()) != null) {
                    connections.put(connectionDescriptor, ConnectionWidgetManager.this.connectionService.getConnectionManager().getConnectionProfiles(connectionDescriptor.getId()));
                }
                ++n4;
            }
            int descriptorCount = 0;
            connections = ConnectionWidgetManager.this.sort(connections);
            for (Map.Entry entry : connections.entrySet()) {
                String activeConfigurationId;
                IConnectionDescriptor connectionDescriptor = (IConnectionDescriptor)entry.getKey();
                if (!ConnectionWidgetManager.this.isDialogMode() && descriptorCount == 0) {
                    new MenuItem(connectionsMenu, 2);
                }
                List configurations = (List)entry.getValue();
                if (descriptorCount > 0 && !configurations.isEmpty() && descriptorCount < connections.keySet().size()) {
                    new MenuItem(connectionsMenu, 2);
                }
                ++descriptorCount;
                IConnectionState currentState = ConnectionWidgetManager.this.connectionService.getConnectionState(ConnectionWidgetManager.this.currentCategory);
                String string = activeConfigurationId = currentState != null ? currentState.getID() : null;
                if (!connectionDescriptor.isTransient() || connectionDescriptor.isFactory()) {
                    MenuItem createDescriptorMenuItem = new MenuItem(connectionsMenu, 0);
                    final CreateConnectionAction createConnectionAction = new CreateConnectionAction(connectionDescriptor);
                    createDescriptorMenuItem.setText(createConnectionAction.getText());
                    createDescriptorMenuItem.setImage(ConnectionsImages.getCreateConnectionImage(connectionDescriptor.getCategory()));
                    createDescriptorMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            createConnectionAction.run();
                        }
                    });
                }
                for (ConnectionProfile connectionConfiguration : configurations) {
                    Map connectedStates;
                    MenuItem menuItem = new MenuItem(connectionsMenu, 0);
                    menuItem.setText(connectionConfiguration.getName());
                    debug.event("fillConnectionsMenu", "connection: " + connectionConfiguration.getName());
                    menuItem.setData(ConnectionProfile.class.getName(), (Object)connectionConfiguration);
                    menuItem.setData(IConnectionDescriptor.class.getName(), (Object)connectionDescriptor);
                    if (connectionConfiguration.getId().equals(activeConfigurationId)) {
                        menuItem.setImage(currentState.getImage());
                        menuItem.setData(IConnectionState.class.getName(), (Object)currentState);
                    }
                    if ((connectedStates = (Map)ConnectionWidgetManager.this.additionalConnectedStates.get(connectionDescriptor.getCategory())) != null) {
                        for (Map.Entry mapEntry : connectedStates.entrySet()) {
                            IConnectionState connectionState;
                            if (!((String)mapEntry.getKey()).equals(connectionConfiguration.getId()) || (connectionState = (IConnectionState)mapEntry.getValue()) == null) continue;
                            menuItem.setImage(connectionState.getImage());
                            menuItem.setData(IConnectionState.class.getName(), (Object)connectionState);
                            break;
                        }
                    }
                    menuItem.addSelectionListener(ConnectionWidgetManager.this.connectionItemSelectionListener);
                }
            }
            debug.exit("fillConnectionsMenu");
        }
    }
}

