/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.EventManager;
import com.ibm.cics.common.util.IStaleableEventListener;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.comm.ConnectionCancelledException;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.DisconnectVetoedException;
import com.ibm.cics.core.comm.EnhancedConnectionException;
import com.ibm.cics.core.comm.ExplorerSecurityHelper;
import com.ibm.cics.core.comm.ICompositeConnection;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnectable2;
import com.ibm.cics.core.comm.IConnectableListener;
import com.ibm.cics.core.comm.IConnectableListener2;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.comm.IMultiConnectable;
import com.ibm.cics.core.comm.IParentConnectable;
import com.ibm.cics.core.comm.SecureCertificateException;
import com.ibm.cics.core.connections.ConfigurationUtils;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.AcceptCertificateDialog;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.ConnectablesRegistry;
import com.ibm.cics.core.connections.internal.ConnectedState;
import com.ibm.cics.core.connections.internal.ConnectingState;
import com.ibm.cics.core.connections.internal.ConnectionManager;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.DebugOptions;
import com.ibm.cics.core.connections.internal.DefaultConnectionService;
import com.ibm.cics.core.connections.internal.DisconnectedState;
import com.ibm.cics.core.connections.internal.ExceptionState;
import com.ibm.cics.core.connections.internal.Function;
import com.ibm.cics.core.connections.internal.IConnectionAuthenticationProvider;
import com.ibm.cics.core.connections.internal.IConnectionParameters;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.core.connections.internal.MisconfiguredSecurityResolver;
import com.ibm.cics.core.connections.internal.NoConnection;
import com.ibm.cics.core.connections.internal.WarningState;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ConnectionService
implements IConnectionService {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Object CONNECTION_JOB_FAMILY = "com.ibm.cics.core.connections";
    private static final Debug debug = new Debug(ConnectionService.class);
    private final ConnectionManager connectionManager;
    private final ConnectionRegistry connectionRegistry;
    private final IConnectionAuthenticationProvider authenticationProvider;
    private MisconfiguredSecurityResolver securityResolver;
    private EventManager<ConnectionServiceListener.ConnectionServiceEvent> eventManager = new EventManager();
    private Map<String, IConnectable> connectables = new HashMap<String, IConnectable>();
    private Map<IConnectable, Object> registeredListeners = new HashMap<IConnectable, Object>();
    private Map<String, IConnectionState> categoriesToState = new HashMap<String, IConnectionState>();
    private Map<String, IConnectionState> configurationIDsToState = new HashMap<String, IConnectionState>();
    private Map<String, ConnectionProfile> lastConfigurationsByCategory = new HashMap<String, ConnectionProfile>();
    private ICredentialsManager credentialsManager;
    private DefaultConnectionService defaultConnectionService;
    private Map<String, ConnectionException> connectionExceptions = new HashMap<String, ConnectionException>();
    private ConnectablesRegistry connectablesRegistry;
    private static final ISchedulingRule connectionSchedulingRule = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return connectionSchedulingRule == rule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return connectionSchedulingRule == rule;
        }
    };

    public ConnectionService(ConnectionManager connectionManager, ICredentialsManager credentialsManager, ConnectionRegistry connectionRegistry, IConnectionAuthenticationProvider authenticationProvider, MisconfiguredSecurityResolver securityResolver, Map<String, String> initialState, DefaultConnectionService defaultConnectionService, ConnectablesRegistry connectablesRegistry) {
        this.connectionManager = connectionManager;
        this.credentialsManager = credentialsManager;
        this.connectionRegistry = connectionRegistry;
        this.authenticationProvider = authenticationProvider;
        this.securityResolver = securityResolver;
        this.defaultConnectionService = defaultConnectionService;
        this.connectablesRegistry = connectablesRegistry;
        connectionManager.addListener(new ConnectionManagerListener(){

            public void event(ConnectionManagerListener.ConnectionManagerEvent event) {
                ConnectionProfile newConfiguration;
                if (event instanceof ConnectionManagerListener.ConnectionProfileUpdatedEvent && this.isInUse(newConfiguration = ((ConnectionManagerListener.ConnectionProfileUpdatedEvent)event).getConnectionProfile())) {
                    ConnectionService.this.connectAsync(newConfiguration.getId());
                }
                if (event instanceof ConnectionManagerListener.ConnectionProfileRemovedEvent) {
                    final ConnectionProfile configuration = ((ConnectionManagerListener.ConnectionProfileRemovedEvent)event).getConnectionProfile();
                    final String categoryId = ConnectionService.this.getCategoryId(configuration);
                    if (this.isInUse(configuration)) {
                        new DisconnectJob(ConnectionService.this, categoryId){

                            @Override
                            protected IStatus runSub(IProgressMonitor monitor) {
                                IStatus status = Status.OK_STATUS;
                                status = super.runSub(monitor);
                                ConnectionService.this.lastConfigurationsByCategory.remove(categoryId);
                                ConnectionService.this.configurationIDsToState.remove(configuration.getId());
                                return status;
                            }
                        }.schedule();
                    } else {
                        ConnectionProfile profile;
                        ConnectionService.this.configurationIDsToState.remove(configuration.getId());
                        IConnectionState state = (IConnectionState)ConnectionService.this.categoriesToState.get(categoryId);
                        if (state != null && state.getID().equals(configuration.getId())) {
                            ConnectionService.this.categoriesToState.remove(categoryId);
                        }
                        if ((profile = (ConnectionProfile)ConnectionService.this.lastConfigurationsByCategory.get(categoryId)) != null && profile.getId().equals(configuration.getId())) {
                            ConnectionService.this.lastConfigurationsByCategory.remove(categoryId);
                        }
                    }
                }
            }

            private boolean isInUse(ConnectionProfile config) {
                return this.categoryIsConnected(config) && this.isLastConfiguration(config);
            }

            private boolean isLastConfiguration(ConnectionProfile newConfiguration) {
                ConnectionProfile lastConfiguration = (ConnectionProfile)ConnectionService.this.lastConfigurationsByCategory.get(ConnectionService.this.getCategoryId(newConfiguration));
                return lastConfiguration != null && lastConfiguration.getId().equals(newConfiguration.getId());
            }

            private boolean categoryIsConnected(ConnectionProfile config) {
                IConnectable connectable = ConnectionService.this.getConnectable(ConnectionService.this.getCategoryId(config));
                return connectable != null && connectable.isConnected();
            }
        });
        this.prepopulateStateMap(initialState);
    }

    private void prepopulateStateMap(Map<String, String> initialState) {
        for (Map.Entry<String, String> entry : initialState.entrySet()) {
            ConnectionProfile configuration;
            if (entry.getValue() == null || (configuration = this.connectionManager.getConnectionProfile(entry.getValue())) == null) continue;
            this.lastConfigurationsByCategory.put(entry.getKey(), configuration);
        }
    }

    public Map<String, String> getLastUsedConfigs() {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        for (Map.Entry<String, ConnectionProfile> entry : this.lastConfigurationsByCategory.entrySet()) {
            if (entry.getValue() == null) continue;
            toReturn.put(entry.getKey(), entry.getValue().getId());
        }
        return toReturn;
    }

    private void addConnectableListener(final String connectionCategoryId, final IConnectable connectable) {
        Object listener;
        final IConnectionCategory category = this.connectionRegistry.getConnectionCategory(connectionCategoryId);
        if (connectable instanceof IConnectable2) {
            IConnectableListener2 connectableListener = new IConnectableListener2(){

                public void exception(IConnectable connectable, Exception ex) {
                    ConnectionService.this.notifyException(category, connectable, ex, (ConnectionProfile)ConnectionService.this.lastConfigurationsByCategory.get(connectionCategoryId));
                }
            };
            ((IConnectable2)connectable).addListener(connectableListener);
            listener = connectableListener;
        } else {
            KillableConnectableListener connectableListener = new KillableConnectableListener(new IConnectableListener(){

                public void disconnected() {
                }

                public void exception(Exception ex) {
                    ConnectionService.this.notifyException(category, connectable, ex, (ConnectionProfile)ConnectionService.this.lastConfigurationsByCategory.get(connectionCategoryId));
                }
            });
            connectable.addListener((IConnectableListener)connectableListener);
            listener = connectableListener;
        }
        this.registeredListeners.put(connectable, listener);
    }

    @Override
    public ConnectionException getConnectionException(String connectionCategoryID) {
        return this.connectionExceptions.get(connectionCategoryID);
    }

    private void setConnectionException(IConnectionCategory category, ConnectionException anException) {
        this.connectionExceptions.put(category.getId(), anException);
    }

    @Override
    public void addConnectionServiceListener(ConnectionServiceListener listener) {
        this.eventManager.addListener((IStaleableEventListener)listener);
    }

    @Override
    public IConnectable getConnectable(String connectionCategoryId) {
        IConnectable connectable = this.connectables.get(connectionCategoryId);
        if (connectable == null) {
            connectable = this.connectablesRegistry.loadConnectable(connectionCategoryId);
            this.setConnectable(connectionCategoryId, connectable);
        }
        return connectable;
    }

    private boolean notifyDisconnecting(IConnectionCategory category, IConnectable connectable) {
        debug.enter("notifyDisconnecting", (Object)category, (Object)("connectable=" + connectable));
        ConnectionProfile connectionConfiguration = this.lastConfigurationsByCategory.get(category.getId());
        ConnectionServiceListener.DisconnectingEvent event = new ConnectionServiceListener.DisconnectingEvent(category, connectable, connectionConfiguration);
        this.notifyListeners(event);
        debug.exit("notifyDisconnecting", (Object)("vetoed=" + event.isVetoed()));
        return event.isVetoed();
    }

    private void notifyConnected(IConnectionCategory category, IConnectable connectable, ConnectionProfile configuration) {
        debug.enter("notifyConnected", (Object)("connectable=" + connectable), (Object)("configuration=" + configuration));
        ConnectionServiceListener.ConnectedEvent event = new ConnectionServiceListener.ConnectedEvent(category, connectable, configuration);
        this.notifyListeners(event);
        debug.exit("notifyConnected");
    }

    private void notifyConnecting(IConnectionCategory category, IConnectable connectable, ConnectionProfile connectionConfiguration) {
        debug.enter("notifyConnecting", (Object)("connectable=" + connectable));
        ConnectionServiceListener.ConnectingEvent event = new ConnectionServiceListener.ConnectingEvent(category, connectable, connectionConfiguration);
        this.notifyListeners(event);
        debug.exit("notifyConnecting");
    }

    private void notifyDisconnected(IConnectionCategory category, IConnectable connectable, ConnectionProfile configuration) {
        debug.enter("notifyDisconnected", (Object)category, (Object)("connectable=" + connectable), (Object)("configuration=" + configuration));
        ConnectionServiceListener.DisconnectedEvent event = new ConnectionServiceListener.DisconnectedEvent(category, connectable, configuration);
        this.notifyListeners(event);
        debug.exit("notifyDisconnected");
    }

    private void notifyException(IConnectionCategory category, IConnectable connectable, Exception exception, ConnectionProfile configuration) {
        debug.enter("notifyException", (Object)category, (Object)("connectable=" + connectable), (Object)("exception=" + exception));
        ConnectionServiceListener.ExceptionEvent event = new ConnectionServiceListener.ExceptionEvent(category, connectable, configuration, exception);
        this.notifyListeners(event);
        if (exception instanceof AuthenticationException) {
            this.forceImmediateDisconnection(event.getConnectionCategoryId(), true);
        }
        debug.exit("notifyException");
    }

    private void notifyListeners(ConnectionServiceListener.ConnectionServiceEvent event) {
        debug.enter("notifyListeners", (Object)("event=" + event));
        if (event.getConnectionProfile() != null) {
            String category = event.getConnectionCategoryId();
            IConnectionState state = this.toConnectionState(event);
            this.categoriesToState.put(category, state);
            if (event.getConnectionProfile() != null) {
                this.configurationIDsToState.put(event.getConnectionProfile().getId(), state);
            }
            this.eventManager.notifyListeners((Object)event);
        }
        debug.exit("notifyListeners");
    }

    private IConnectionState toConnectionState(ConnectionServiceListener.ConnectionServiceEvent event) {
        IConnectable connectable = event.getConnectable();
        ConnectionProfile configuration = event.getConnectionProfile();
        if (event instanceof ConnectionServiceListener.ConnectedEvent || event instanceof ConnectionServiceListener.DisconnectingEvent) {
            return new ConnectedState(connectable.getConnection(), configuration);
        }
        if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
            ConnectionException connectionException = this.getConnectionException(event.getConnectionCategoryId());
            debug.event("disconnected", (Object)connectionException);
            if (connectionException == null) {
                return null;
            }
            return new ExceptionState((Exception)((Object)connectionException), configuration);
        }
        if (event instanceof ConnectionServiceListener.ExceptionEvent) {
            Exception exception = ((ConnectionServiceListener.ExceptionEvent)event).getException();
            if (connectable != null) {
                IConnectionCategory category = event.getConnectionProfile().getConnectionDescriptor().getCategory();
                IConnectionState currentState = this.categoriesToState.get(category.getId());
                if (currentState instanceof ConnectedState) {
                    if (exception == null) {
                        return new ConnectedState(connectable.getConnection(), configuration);
                    }
                    return new WarningState(connectable.getConnection(), exception, configuration);
                }
                if (currentState instanceof ExceptionState) {
                    if (exception == null) {
                        return new ConnectedState(connectable.getConnection(), configuration);
                    }
                    return new ExceptionState(exception, configuration);
                }
                if (exception == null) {
                    return currentState;
                }
                return new ExceptionState(exception, configuration);
            }
            return new ExceptionState(exception, configuration);
        }
        if (event instanceof ConnectionServiceListener.ConnectingEvent) {
            return new ConnectingState(configuration);
        }
        return null;
    }

    private void removeConnectableListener(IConnectable connectable) {
        Object listener = this.registeredListeners.get(connectable);
        if (connectable instanceof IConnectable2 && listener instanceof IConnectableListener2) {
            ((IConnectable2)connectable).removeListener((IConnectableListener2)listener);
        } else if (listener instanceof KillableConnectableListener) {
            ((KillableConnectableListener)listener).kill();
        }
    }

    @Override
    public void setConnectable(String connectionCategoryId, IConnectable newConnectable) {
        IConnectable oldConnectable = this.connectables.put(connectionCategoryId, newConnectable);
        if (newConnectable != null) {
            this.addConnectableListener(connectionCategoryId, newConnectable);
        }
        if (oldConnectable != null && oldConnectable != newConnectable) {
            this.removeConnectableListener(oldConnectable);
        }
    }

    private void childrenDisconnect(IParentConnectable connectableParent) {
        String[] cats;
        String[] stringArray = cats = connectableParent.getChildCategories();
        int n = cats.length;
        int n2 = 0;
        while (n2 < n) {
            String childCategory = stringArray[n2];
            try {
                this.disconnect(childCategory);
            }
            catch (DisconnectVetoedException disconnectVetoedException) {
                debug.warning("childrenDisconnect", (Object)("disconnect vetoed for child category: " + childCategory));
            }
            ++n2;
        }
    }

    private void childrenConnect(ConnectionProfile parentProfile, final String parentConnectionCategory, final IParentConnectable parentConnectable) throws ConnectionException {
        String[] stringArray = parentConnectable.getChildCategories();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            final String childCategory = stringArray[n2];
            IConnection connection = parentConnectable.getChildConnection(childCategory);
            ConnectionConfiguration configuration = connection.getConfiguration();
            if (configuration != null) {
                ConnectionProfile hC = this.connectionManager.getConnectionProfile(configuration.getID());
                if (hC == null) {
                    hC = parentProfile;
                }
                IConnectable childConnectable = this.getConnectable(childCategory);
                if (connection != null && childConnectable != null) {
                    if (childConnectable.isConnected()) {
                        this.disconnect(childCategory);
                    }
                    this.lastConfigurationsByCategory.put(childCategory, hC);
                    IConnectionCategory connectionCategory = this.connectionRegistry.getConnectionCategory(childCategory);
                    this.notifyConnecting(connectionCategory, childConnectable, hC);
                    childConnectable.setConnection(connection);
                    this.notifyConnected(connectionCategory, childConnectable, hC);
                }
                this.addConnectionServiceListener(new ConnectionServiceListener(){

                    public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                        if (event.getConnectionCategoryId().equals(childCategory) && (event instanceof ConnectionServiceListener.DisconnectingEvent || event instanceof ConnectionServiceListener.DisconnectedEvent)) {
                            this.makeStale();
                            if (event instanceof ConnectionServiceListener.DisconnectingEvent && parentConnectable.isConnected()) {
                                ((ConnectionServiceListener.DisconnectingEvent)event).veto();
                                try {
                                    ConnectionService.this.disconnect(parentConnectionCategory);
                                }
                                catch (DisconnectVetoedException disconnectVetoedException) {
                                    debug.warning("event", (Object)"attempted to disconnect parent category, but it was vetoed");
                                }
                            }
                        }
                    }
                });
            }
            ++n2;
        }
    }

    @Override
    public void signOff() {
        for (Map.Entry<String, IConnectable> entry : this.connectables.entrySet()) {
            if (!entry.getValue().isConnected()) continue;
            String aConnectionCategory = entry.getKey();
            this.disconnectAsync(aConnectionCategory);
        }
        this.credentialsManager.clearAuthenticated();
    }

    public void switchToAlreadyConnected(IConnection connection, ConnectionProfile configuration) {
        debug.enter("switchToAlreadyConnected", (Object)connection.getConfiguration());
        if (!connection.isConnected() || connection.getConfiguration() == null) {
            debug.event("switchToAlreadyConnected", (Object)"Connection not already connected ", (Object)connection.getConfiguration());
            return;
        }
        IConnectionCategory category = configuration.getConnectionDescriptor().getCategory();
        IConnectable connectable = this.getConnectable(category.getId());
        debug.event("switchToAlreadyConnected", (Object)category, (Object)connectable);
        this.notifyConnecting(category, connectable, configuration);
        connectable.setConnection(connection);
        this.lastConfigurationsByCategory.put(category.getId(), configuration);
        this.notifyConnected(category, connectable, configuration);
        debug.exit("switchToAlreadyConnected", (Object)connection.getConfiguration());
    }

    @Override
    public void connect(String configurationId) {
        debug.enter("connect", (Object)("configurationId=" + configurationId));
        ConnectionProfile config = this.connectionManager.getConnectionProfile(configurationId);
        if (config == null) {
            throw new IllegalArgumentException("No configuration found with id: " + configurationId);
        }
        IConnectionCategory category = config.getConnectionDescriptor().getCategory();
        IConnectable connectable = this.getConnectable(category.getId());
        if (connectable == null) {
            throw new IllegalArgumentException("No connectable set for connection category '" + category.getId() + "'");
        }
        this.setConnectionException(category, null);
        boolean supportsMultipleConnections = ConnectionUtils.supportsMultipleConnections(config.getConnectionDescriptor());
        if (connectable.isConnected()) {
            ConnectionProfile connectionProfile;
            boolean existingConnectionSupportsMultiple = false;
            if (connectable.getConnection() != null && !(existingConnectionSupportsMultiple = ConnectionUtils.supportsMultipleConnections((connectionProfile = this.connectionManager.getConnectionProfile(connectable.getConnection().getConfiguration().getID())).getConnectionDescriptor()))) {
                try {
                    this.disconnect(category.getId());
                }
                catch (ConnectionException ex) {
                    this.setConnectionException(category, ex);
                    this.notifyException(category, connectable, (Exception)((Object)ex), this.lastConfigurationsByCategory.get(category.getId()));
                }
            }
        }
        try {
            this.notifyConnecting(category, connectable, config);
            this.lastConfigurationsByCategory.put(this.getCategoryId(config), config);
            IConnection newConnection = this.doConnect(configurationId);
            this.markAsConnected(connectable, newConnection, category, configurationId);
        }
        catch (ConnectionCancelledException ex) {
            debug.event("doConnect", (Object)ex);
            this.notifyDisconnected(category, connectable, config);
        }
        catch (ConnectionException ex) {
            this.setConnectionException(category, ex);
            this.notifyException(category, connectable, (Exception)((Object)ex), config);
        }
    }

    private void markAsConnected(IConnectable connectable, IConnection newConnection, IConnectionCategory category, String configurationId) throws ConnectionException {
        ConnectionProfile config = this.connectionManager.getConnectionProfile(configurationId);
        this.lastConfigurationsByCategory.put(this.getCategoryId(config), config);
        connectable.setConnection(newConnection);
        if (connectable instanceof IParentConnectable) {
            this.childrenConnect(config, category.getId(), (IParentConnectable)connectable);
        }
        this.notifyConnected(category, connectable, config);
    }

    private List<String> getComponentIds(IConnectionDescriptor descriptor, ConnectionConfiguration configuration) {
        ArrayList<String> componentIds = new ArrayList<String>();
        for (IConnectionDescriptor.ExtendedAttribute attribute : descriptor.getExtendedAttributes()) {
            List<ConnectionProfile> configurationsForType;
            List<ConnectionProfile> matchingConfigurations;
            if (IConnectionDescriptor.ExtendedAttributeType.CONNECTION_ID != attribute.getType()) continue;
            String componentId = configuration.getExtendedAttribute(attribute.getKey());
            if (StringUtil.hasContent((String)componentId)) {
                componentIds.add(componentId);
                continue;
            }
            if (!"com.ibm.cics.cm.comm.connection".equals(descriptor.getId()) || !"SM_CONFIGURATION_ID".equals(attribute.getKey())) continue;
            String connectionTypeId = configuration.getExtendedAttribute("ID");
            final String connectionName = configuration.getExtendedAttribute("NAME");
            if (!StringUtil.hasContent((String)connectionTypeId) || !StringUtil.hasContent((String)connectionName) || (matchingConfigurations = CollectionUtils.filter(configurationsForType = this.connectionManager.getConnectionProfiles(connectionTypeId), new Function<ConnectionProfile, Boolean>(){

                @Override
                public Boolean evaluate(ConnectionProfile v) {
                    return connectionName.equals(v.getName());
                }
            })).size() != 1) continue;
            componentIds.add(matchingConfigurations.get(0).getId());
        }
        return componentIds;
    }

    private IConnection doConnect(String configurationId) throws ConnectionException {
        debug.enter("doConnect", (Object)("configurationId=" + configurationId));
        ConnectionProfile configuration = this.connectionManager.getConnectionProfile(configurationId);
        if (configuration == null) {
            throw new ConnectionException("Unknown configuration id: " + configurationId);
        }
        for (CredentialsConfiguration config : this.credentialsManager.getAllCredentials()) {
            if (!config.isOneTimePassword()) continue;
            this.credentialsManager.clearAuthenticated(config.getID());
        }
        if (!this.updateCredentialsForConfiguration(configurationId)) {
            throw new ConnectionCancelledException();
        }
        configuration = this.connectionManager.getConnectionProfile(configurationId);
        IConnection connection = configuration.getConnectionDescriptor().createConnection();
        ConnectionConfiguration connectionConfiguration = configuration.getConnectionConfiguration();
        if (connection instanceof ICompositeConnection) {
            List<String> componentConfigurationIds = this.getComponentIds(configuration.getConnectionDescriptor(), connectionConfiguration);
            HashMap<String, IConnection> componentConnections = new HashMap<String, IConnection>();
            for (String componentConfigurationId : componentConfigurationIds) {
                componentConnections.put(componentConfigurationId, this.doConnect(componentConfigurationId));
            }
            ((ICompositeConnection)connection).setConfiguration(connectionConfiguration, componentConnections);
        } else {
            connection.setConfiguration(connectionConfiguration);
        }
        try {
            connection.connect();
            return connection;
        }
        catch (AuthenticationException ex) {
            debug.event("connect", (Object)configuration, (Object)ex);
            this.updateCredentialAsBad(configuration);
            throw ex;
        }
        catch (ConnectionCancelledException ex) {
            throw ex;
        }
        catch (ConnectionException ex) {
            if (this.handleInvalidCertificate(ex, configuration)) {
                return this.doConnect(configurationId);
            }
            if (this.securityResolver.handleSecurityAmbiguity(ex, configuration.getConnectionParameters(), configuration.getConnectionProvider())) {
                return this.doConnect(configurationId);
            }
            throw ConnectionService.enhanceExceptionMessage((Exception)((Object)ex), configuration);
        }
        catch (Exception ex) {
            throw new ConnectionException(ex);
        }
    }

    private String getCategoryId(ConnectionProfile configuration) {
        return configuration.getConnectionDescriptor().getCategory().getId();
    }

    static ConnectionException enhanceExceptionMessage(Exception exception, IConnectionParameters configuration) {
        String msg = "";
        Throwable cause = exception;
        if (cause instanceof InvalidAlgorithmParameterException) {
            return new EnhancedConnectionException(Messages.Invalid_truststore_empty, cause);
        }
        if (exception.getCause() != null) {
            cause = exception.getCause();
        }
        if (cause instanceof UnknownHostException) {
            String unknownHost = cause.getMessage();
            msg = MessageFormat.format(Messages.ConnectionExceptionMessageHelper_IZE0104E_failedUnknownHost, unknownHost, configuration.getName());
        } else {
            msg = MessageFormat.format(Messages.ConnectionExceptionMessageHelper_IZE0106E_failedWithError, cause.getMessage(), configuration.getName());
        }
        return new EnhancedConnectionException(msg, cause);
    }

    private boolean handleInvalidCertificate(ConnectionException ex, ConnectionProfile configuration) throws ConnectionException {
        CertificateInfo certificateInfo = ConnectionService.locateRootCauseCertificate(ex);
        if (certificateInfo.chain != null) {
            debug.event("connect", (Object)configuration.getId(), (Object)certificateInfo.chain);
            String trustStoremessage = ExplorerSecurityHelper.validateTrustStoreDetail();
            if (!StringUtil.hasContent((String)trustStoremessage)) {
                debug.event("connect", "valid trust");
                if (ConnectionService.canAcceptCertificate(certificateInfo.chain, certificateInfo.name != null ? certificateInfo.name : configuration.getName(), certificateInfo.host != null ? certificateInfo.host : ConfigurationUtils.getHost(configuration))) {
                    debug.event("connect", "accept certificate");
                    return true;
                }
                throw ex;
            }
            throw new ConnectionException("Unable to import certificate into store: " + trustStoremessage, (Throwable)ex);
        }
        return false;
    }

    public static boolean canAcceptCertificate(X509Certificate[] chain, String name, String host) {
        return AcceptCertificateDialog.acceptCertificate(chain, name, host);
    }

    private static CertificateInfo locateRootCauseCertificate(ConnectionException ex) {
        Throwable rootCause = ex.getCause();
        int maxlaps = 5;
        CertificateInfo ci = new CertificateInfo();
        int i = 0;
        while (i < maxlaps) {
            if (rootCause != null) {
                if (rootCause instanceof CertPathValidatorException) {
                    List<? extends Certificate> certificates = ((CertPathValidatorException)rootCause).getCertPath().getCertificates();
                    ArrayList<X509Certificate> certArray = new ArrayList<X509Certificate>();
                    for (Certificate certificate : certificates) {
                        if (!(certificate instanceof X509Certificate)) continue;
                        certArray.add((X509Certificate)certificate);
                    }
                    ci.chain = certArray.toArray(new X509Certificate[certArray.size()]);
                    return ci;
                }
                if (rootCause instanceof SecureCertificateException) {
                    SecureCertificateException sce = (SecureCertificateException)rootCause;
                    ci.name = sce.getName();
                    ci.host = sce.getHost();
                    ci.chain = sce.getChain();
                    return ci;
                }
                if (rootCause.getCause() == rootCause) {
                    return ci;
                }
                rootCause = rootCause.getCause();
            }
            ++i;
        }
        return ci;
    }

    boolean updateCredentialsForConfiguration(String configurationId) {
        if (DebugOptions.DEBUG_CONNECTION) {
            debug.enter("authenticate", (Object)configurationId);
        }
        if (this.authenticationProvider != null) {
            return this.authenticationProvider.authenticate(configurationId);
        }
        if (DebugOptions.DEBUG_CONNECTION) {
            debug.exit("authenticate", (Object)true);
        }
        return true;
    }

    private void updateCredentialAsBad(ConnectionProfile config) {
        CredentialsConfiguration credentialsConfiguration = config.getCredentials();
        if (credentialsConfiguration != null) {
            this.credentialsManager.invalidate(credentialsConfiguration.getID());
        }
    }

    @Override
    public void connectAsync(final String configurationId) {
        debug.enter("connect", (Object)configurationId);
        ConnectionProfile configuration = this.connectionManager.getConnectionProfile(configurationId);
        if (configuration == null) {
            return;
        }
        final IConnectionCategory connectionCategory = configuration.getConnectionDescriptor().getCategory();
        JobWithCancelingSupport connectJob = new JobWithCancelingSupport(MessageFormat.format("Connect to {0}", connectionCategory.getAbbreviatedName())){

            public boolean belongsTo(Object family) {
                return family == CONNECTION_JOB_FAMILY;
            }

            protected void cancelingSub() {
                debug.enter("cancelingSub", (Object)this, (Object)Thread.currentThread().getName());
                try {
                    ConnectionService.this.disconnect(connectionCategory.getId());
                }
                catch (ConnectionException ex) {
                    debug.warning("cancelingSub", "Failure when attempting to disconnect on connect cancelled. Maybe the connection wasn't connected", (Throwable)ex);
                }
                debug.exit("cancelingSub");
            }

            protected IStatus runSub(final IProgressMonitor monitor) {
                ConnectionServiceListener jobListener = new ConnectionServiceListener(){

                    public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                        if (event.getConnectionCategoryId().equals(connectionCategory.getId()) && event instanceof ConnectionServiceListener.ConnectingEvent) {
                            this.setName(Messages.bind((String)Messages.ConnectionService_connecting, (Object)event.getConnectionProfile().getName()));
                            monitor.beginTask("IZE0102I " + Messages.ConnectionService_connecting, -1);
                        }
                    }
                };
                try {
                    ConnectionService.this.addConnectionServiceListener(jobListener);
                    ConnectionService.this.connect(configurationId);
                }
                finally {
                    jobListener.makeStale();
                }
                return Status.OK_STATUS;
            }
        };
        connectJob.setUser(true);
        connectJob.setRule(connectionSchedulingRule);
        connectJob.schedule();
    }

    @Override
    public void disconnect(String connectionCategoryId, String connectionID) throws DisconnectVetoedException {
        IConnectable connectable = this.getConnectable(connectionCategoryId);
        IConnectionCategory category = this.connectionRegistry.getConnectionCategory(connectionCategoryId);
        String currentConnectionId = connectable.getConnection().getConfiguration().getID();
        if (currentConnectionId.equals(connectionID)) {
            this.disconnect(connectionCategoryId);
        } else if (connectable instanceof IMultiConnectable) {
            ConnectionProfile disconnectedConfiguration = this.getConnectionManager().getConnectionProfile(connectionID);
            try {
                ((IMultiConnectable)connectable).disconnect(connectionID);
                this.notifyDisconnected(category, connectable, disconnectedConfiguration);
            }
            catch (ConnectionException ex) {
                this.setConnectionException(category, ex);
                this.notifyException(category, connectable, (Exception)((Object)ex), disconnectedConfiguration);
            }
        }
    }

    @Override
    public void forceImmediateDisconnection(String connectionCategoryId, boolean invalidateCredentials) {
        debug.enter("forceImmediateDisconnection", (Object)connectionCategoryId);
        IConnectable connectable = this.getConnectable(connectionCategoryId);
        IConnectionCategory category = this.connectionRegistry.getConnectionCategory(connectionCategoryId);
        if (connectable != null) {
            ConnectionProfile disconnectedConfiguration = this.lastConfigurationsByCategory.get(connectionCategoryId);
            if (connectable.isConnected()) {
                try {
                    connectable.disconnect();
                }
                catch (ConnectionException ex) {
                    this.setConnectionException(category, ex);
                    this.notifyException(category, connectable, (Exception)((Object)ex), disconnectedConfiguration);
                }
            }
            connectable.setConnection(null);
            if (connectable instanceof IParentConnectable) {
                this.childrenDisconnect((IParentConnectable)connectable);
            }
            this.notifyDisconnected(category, connectable, disconnectedConfiguration);
        }
        if (invalidateCredentials && connectable.getConnection() != null && connectable.getConnection().getConfiguration() != null) {
            this.updateCredentialAsBad(this.connectionManager.getConnectionProfile(connectable.getConnection().getConfiguration().getID()));
        }
    }

    @Override
    public void disconnect(String connectionCategoryId) throws DisconnectVetoedException {
        debug.enter("disconnect", (Object)connectionCategoryId);
        IConnectable connectable = this.getConnectable(connectionCategoryId);
        IConnectionCategory category = this.connectionRegistry.getConnectionCategory(connectionCategoryId);
        IConnection connectionToFallBackTo = null;
        if (connectable != null) {
            boolean veto = false;
            if (connectable.isConnected()) {
                veto = this.notifyDisconnecting(category, connectable);
            }
            debug.event("disconnect", (Object)veto);
            if (!veto) {
                ConnectionProfile disconnectedConfiguration = this.lastConfigurationsByCategory.get(connectionCategoryId);
                try {
                    connectable.disconnect();
                    if (connectable instanceof IMultiConnectable) {
                        connectionToFallBackTo = ((IMultiConnectable)connectable).getPreviousConnection();
                    }
                }
                catch (ConnectionException ex) {
                    this.setConnectionException(category, ex);
                    this.notifyException(category, connectable, (Exception)((Object)ex), disconnectedConfiguration);
                }
                connectable.setConnection(null);
                if (connectable instanceof IParentConnectable) {
                    this.childrenDisconnect((IParentConnectable)connectable);
                }
                this.notifyDisconnected(category, connectable, disconnectedConfiguration);
                if (connectionToFallBackTo != null) {
                    if (!connectionToFallBackTo.isConnected()) {
                        this.connect(connectionToFallBackTo.getName());
                    } else {
                        String configurationId = connectionToFallBackTo.getConfiguration().getID();
                        ConnectionProfile connectionProfile = this.connectionManager.getConnectionProfile(configurationId);
                        try {
                            this.markAsConnected(connectable, connectionToFallBackTo, category, configurationId);
                        }
                        catch (ConnectionException ex) {
                            this.setConnectionException(category, ex);
                            this.notifyException(category, connectable, (Exception)((Object)ex), connectionProfile);
                        }
                    }
                }
            } else {
                throw new DisconnectVetoedException(MessageFormat.format("Could not disconnect connection category \"{0}\", as disconnection was vetoed", connectionCategoryId));
            }
        }
    }

    @Override
    public void disconnectAsync(String connectionCategoryId) {
        DisconnectJob disconnectJob = new DisconnectJob(connectionCategoryId, null, null);
        disconnectJob.schedule();
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public IConnectionState getConnectionState(String connectionCategoryId) {
        IConnectionState state = this.categoriesToState.get(connectionCategoryId);
        if (state != null) {
            return state;
        }
        ConnectionProfile lastConfig = this.lastConfigurationsByCategory.get(connectionCategoryId);
        if (lastConfig == null || StringUtil.isEmpty((String)lastConfig.getId())) {
            return new NoConnection(connectionCategoryId);
        }
        return new DisconnectedState(lastConfig);
    }

    @Override
    public List<IConnectionCategory> getConnectionCategories() {
        return Arrays.asList(this.connectionRegistry.getConnectionCategories());
    }

    @Override
    public IConnectionState getConnectionState(ConnectionProfile configuration) {
        IConnectionState connectionState = this.configurationIDsToState.get(configuration.getId());
        return connectionState != null ? connectionState : new DisconnectedState(configuration);
    }

    public DefaultConnectionService getDefaultConnectionService() {
        return this.defaultConnectionService;
    }

    public void connectToDefaultConnections() {
        List<IConnectionCategory> connectionCategories = this.getConnectionCategories();
        for (IConnectionCategory connectionCategory : connectionCategories) {
            ConnectionProfile defaultConnection = this.defaultConnectionService.getDefaultConnectionProfile(connectionCategory);
            if (defaultConnection == null) continue;
            if (this.getConnectable(connectionCategory.getId()) != null) {
                this.connectAsync(defaultConnection.getId());
                continue;
            }
            debug.warning("connectToDefaultConnections", (Object)connectionCategory.getId(), (Object)"Couldn't connect because there's no connectable.");
        }
    }

    private static class CertificateInfo {
        private X509Certificate[] chain;
        private String name;
        private String host;

        private CertificateInfo() {
        }
    }

    private class DisconnectJob
    extends JobWithCancelingSupport {
        private final String connectionCategoryId;
        private String connectionId;

        private DisconnectJob(String connectionCategoryId) {
            super(Messages.ConnectionService_disconnecting);
            this.connectionCategoryId = connectionCategoryId;
            this.connectionId = null;
            this.setUser(true);
            this.setRule(connectionSchedulingRule);
        }

        private DisconnectJob(String connectionCategoryId, String connectionId) {
            this(connectionCategoryId);
            this.connectionId = connectionId;
            this.setUser(true);
            this.setRule(connectionSchedulingRule);
        }

        protected IStatus runSub(final IProgressMonitor monitor) {
            ConnectionServiceListener jobListener = new ConnectionServiceListener(){

                public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                    if (event.getConnectionCategoryId().equals(DisconnectJob.this.connectionCategoryId) && event instanceof ConnectionServiceListener.DisconnectingEvent) {
                        IConnection connection = event.getConnectable().getConnection();
                        String connectionName = connection != null ? connection.getName() : "";
                        DisconnectJob.this.setName(Messages.bind((String)(String.valueOf(Messages.ConnectionService_disconnecting) + " [{0}]"), (Object)connectionName));
                        monitor.beginTask(Messages.bind((String)("IZE0105I " + Messages.ConnectionService_disconnectingConnectionLabel), (Object)connectionName), -1);
                    }
                }
            };
            try {
                ConnectionService.this.addConnectionServiceListener(jobListener);
                ConnectionService.this.disconnect(this.connectionCategoryId);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (DisconnectVetoedException ex) {
                debug.warning("runSub", (Object)ex);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                jobListener.makeStale();
            }
        }

        protected void cancelingSub() {
        }

        public boolean belongsTo(Object family) {
            return family == CONNECTION_JOB_FAMILY;
        }

        /* synthetic */ DisconnectJob(String string, DisconnectJob disconnectJob, DisconnectJob disconnectJob2) {
            this(string);
        }
    }

    private static class KillableConnectableListener
    implements IConnectableListener {
        boolean dead = false;
        private final IConnectableListener delegate;

        public KillableConnectableListener(IConnectableListener delegate) {
            this.delegate = delegate;
        }

        public void disconnected() {
            if (!this.dead) {
                this.delegate.disconnected();
            }
        }

        public void exception(Exception ex) {
            if (!this.dead) {
                this.delegate.exception(ex);
            }
        }

        public void kill() {
            this.dead = true;
        }
    }
}

