/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.Messages;
import com.ibm.cics.model.CICSAttributeHint;
import com.ibm.cics.model.CICSRelease;
import com.ibm.cics.model.Debug;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeConstants;
import com.ibm.cics.model.ICICSAttributeHint;
import com.ibm.cics.model.ICICSLongAttributeHint;
import com.ibm.cics.model.IllegalCICSAttributeException;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;

public class CICSLongAttribute
extends CICSAttribute<Long> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public CICSLongAttribute(String propertyId, String categoryId, String cicsName, Long defaultValue, CICSRelease validFrom, CICSRelease validTo, CICSAttribute.HintInput<? super Long> hint) {
        super(propertyId, categoryId, cicsName, Long.class, defaultValue, ICICSAttributeConstants.UNEXPECTED_LONG, ICICSAttributeConstants.UNSUPPORTED_LONG, validFrom, validTo, hint, null, null);
    }

    @Override
    public String getNormalizerKey() {
        return "LONG_NORMALIZER_KEY";
    }

    @Override
    protected String internalToExternalImpl(Long modelValue) throws IllegalCICSAttributeException {
        ICICSAttributeHint hint = this.getValuesHint();
        if (hint != null && hint.hasSpecialValues()) {
            for (Map.Entry specialValuePair : hint.getSpecialValues().entrySet()) {
                if (specialValuePair.getValue() != modelValue) continue;
                if (Debug.DEBUG_ATTRIBUTES) {
                    Exception exc = new Exception("internalToExternalImpl:" + this.getCicsName() + ":" + modelValue + " > " + (String)specialValuePair.getKey());
                    logger.logp(Level.SEVERE, this.getClass().getName(), "internalToExternalImpl", exc.getLocalizedMessage(), exc);
                }
                return (String)specialValuePair.getKey();
            }
        }
        return modelValue.toString();
    }

    @Override
    public Long externalToInternal(String stringValue) throws IllegalCICSAttributeException {
        Long modelValue;
        ICICSAttributeHint hint = this.getValuesHint();
        stringValue = stringValue.trim();
        if (hint != null && hint.hasSpecialValues() && (modelValue = (Long)hint.getSpecialValues().get(stringValue)) != null) {
            if (Debug.DEBUG_ATTRIBUTES) {
                Exception exc = new Exception("externalToInternal:" + this.getCicsName() + ":" + stringValue + " > " + modelValue);
                logger.logp(Level.SEVERE, this.getClass().getName(), "externalToInternal", exc.getLocalizedMessage(), exc);
            }
            return modelValue;
        }
        try {
            return Long.parseLong(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            String message = this.getValuesHint().hasSpecialValues() ? NLS.bind((String)Messages.CICSAttribute_invalidValueGeneral, (Object[])new Object[]{stringValue}) : NLS.bind((String)Messages.CICSAttribute_invalidNumber, (Object[])new Object[]{stringValue});
            throw new IllegalCICSAttributeException(message, (ICICSAttribute)this, (Object)stringValue);
        }
    }

    public ICICSAttributeHint getValuesHint() {
        ICICSLongAttributeHint longHint = this.getHint(ICICSLongAttributeHint.class);
        return longHint == null ? CICSAttributeHint.NONE : (longHint.hasSpecialValues() ? CICSAttributeHint.rangeAndSpecial((long)longHint.getNumericRange()[0], (long)longHint.getNumericRange()[1], (Map)longHint.getSpecialValues(), (Long[])new Long[0]) : CICSAttributeHint.range((long)longHint.getNumericRange()[0], (long)longHint.getNumericRange()[1]));
    }
}

