/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.builders;

import com.ibm.cics.core.model.IDefinitionBuilder;
import com.ibm.cics.model.ICICSAttributeConstants;
import com.ibm.cics.model.ICICSEnum;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.model.IllegalCICSAttributeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BuilderHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final Logger logger = Logger.getLogger(BuilderHelper.class.getPackage().getName());

    public static void copyAttributes(IDefinition sourceObj, IDefinitionBuilder targetMutableObj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method[] targetObjMethods = targetMutableObj.getClass().getMethods();
        int i = 0;
        while (i < targetObjMethods.length) {
            Method sourceGetter;
            Method possibleSetter = targetObjMethods[i];
            if (BuilderHelper.isSetter(possibleSetter) && (sourceGetter = BuilderHelper.findGetter(sourceObj.getClass(), possibleSetter)) != null) {
                try {
                    BuilderHelper.copyAttribute(sourceObj, sourceGetter, targetMutableObj, possibleSetter);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof IllegalCICSAttributeException) {
                        logger.log(Level.FINE, "Failed to call " + targetMutableObj.getClass() + "." + possibleSetter, e.getCause());
                    }
                    throw e;
                }
            }
            ++i;
        }
    }

    private static void copyAttribute(IDefinition sourceObj, Method sourceGetter, IDefinitionBuilder targetMutableObj, Method targetSetter) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object newValue;
        Method targetGetter = BuilderHelper.findGetter(targetMutableObj.getClass(), targetSetter);
        Object oldTargetValue = targetGetter.invoke((Object)targetMutableObj, new Object[0]);
        if (oldTargetValue == null && (newValue = sourceGetter.invoke((Object)sourceObj, new Object[0])) != null && BuilderHelper.isSettableValue(newValue)) {
            targetSetter.invoke((Object)targetMutableObj, newValue);
        }
    }

    private static boolean isSettableValue(Object newValue) {
        return !(newValue instanceof String && newValue.equals(ICICSAttributeConstants.UNSUPPORTED_STRING) || newValue instanceof String && newValue.equals("_UNSUPPORTED") || newValue instanceof Long && newValue.equals(ICICSAttributeConstants.UNSUPPORTED_LONG) || newValue instanceof Date && newValue.equals(ICICSAttributeConstants.UNSUPPORTED_DATE) || newValue instanceof ICICSEnum && ((ICICSEnum)newValue).getDirection() == ICICSEnum.Direction.OUT);
    }

    private static Method findGetter(Class sourceType, Method setter) {
        Class<?> argType = setter.getParameterTypes()[0];
        String getterName = "get" + setter.getName().substring(3);
        try {
            Method maybeGetter = sourceType.getMethod(getterName, new Class[0]);
            if (maybeGetter.getReturnType().equals(argType)) {
                return maybeGetter;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return null;
    }

    private static boolean isSetter(Method aMethod) {
        return aMethod.getName().startsWith("set") && aMethod.getParameterTypes().length == 1 && aMethod.getReturnType().equals(Void.TYPE);
    }
}

