/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.LSRPoolBufferReference;
import com.ibm.cics.core.model.LSRPoolBufferType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.ILSRPoolBuffer;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class LSRPoolBuffer
extends CICSResource
implements ILSRPoolBuffer {
    private String _poolsizetype;
    private Long _hiperbuff;
    private Long _lookasides;
    private Long _reads;
    private Long _useriwrite;
    private Long _nonuwrite;
    private Long _creads;
    private Long _cwrites;
    private Long _failcreads;
    private Long _failcwrites;
    private Long _count;
    private Long _size;
    private ILSRPoolBuffer.BufferUsageValue _type;
    private Long _pool;

    public LSRPoolBuffer(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("POOLSIZETYPE");
        this._poolsizetype = (String)((CICSAttribute)LSRPoolBufferType.POOL_ID_BUFFER).get(stringValue, normalizers);
        stringValue = record.get("HIPERBUFF");
        this._hiperbuff = (Long)((CICSAttribute)LSRPoolBufferType.HIPERSPACE_BUFFERS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("LOOKASIDES");
        this._lookasides = (Long)((CICSAttribute)LSRPoolBufferType.LOOKASIDE_BUFFER_READS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("READS");
        this._reads = (Long)((CICSAttribute)LSRPoolBufferType.BUFFER_READS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("USERIWRITE");
        this._useriwrite = (Long)((CICSAttribute)LSRPoolBufferType.USER_WRITES).get(stringValue, normalizers);
        stringValue = record.get("NONUWRITE");
        this._nonuwrite = (Long)((CICSAttribute)LSRPoolBufferType.NON_USER_WRITES).get(stringValue, normalizers);
        stringValue = record.get("CREADS");
        this._creads = (Long)((CICSAttribute)LSRPoolBufferType.SUCCESSFUL_CREADS).get(stringValue, normalizers);
        stringValue = record.get("CWRITES");
        this._cwrites = (Long)((CICSAttribute)LSRPoolBufferType.SUCCESSFUL_CWRITES).get(stringValue, normalizers);
        stringValue = record.get("FAILCREADS");
        this._failcreads = (Long)((CICSAttribute)LSRPoolBufferType.FAILED_CREAD_REQUESTS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("FAILCWRITES");
        this._failcwrites = (Long)((CICSAttribute)LSRPoolBufferType.FAILED_CWRITE_REQUESTS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("COUNT");
        this._count = (Long)((CICSAttribute)LSRPoolBufferType.BUFFERS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("SIZE");
        this._size = (Long)((CICSAttribute)LSRPoolBufferType.BUFFER_SIZE).get(stringValue, normalizers);
        stringValue = record.get("TYPE");
        this._type = (ILSRPoolBuffer.BufferUsageValue)((CICSAttribute)LSRPoolBufferType.BUFFER_USAGE).get(stringValue, normalizers);
        stringValue = record.get("POOL");
        this._pool = (Long)((CICSAttribute)LSRPoolBufferType.POOL_NUMBER).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return LSRPoolBufferType.POOL_ID_BUFFER.internalToExternal((Object)this.getPoolIDBuffer());
        }
        catch (IllegalCICSAttributeException illegalCICSAttributeException) {
            return "";
        }
    }

    public String getPoolIDBuffer() {
        return this._poolsizetype;
    }

    public Long getHiperspaceBuffersCount() {
        return this._hiperbuff;
    }

    public Long getLookasideBufferReadsCount() {
        return this._lookasides;
    }

    public Long getBufferReadsCount() {
        return this._reads;
    }

    public Long getUserWrites() {
        return this._useriwrite;
    }

    public Long getNonUserWrites() {
        return this._nonuwrite;
    }

    public Long getSuccessfulCreads() {
        return this._creads;
    }

    public Long getSuccessfulCwrites() {
        return this._cwrites;
    }

    public Long getFailedCREADRequestsCount() {
        return this._failcreads;
    }

    public Long getFailedCWRITERequestsCount() {
        return this._failcwrites;
    }

    public Long getBuffersCount() {
        return this._count;
    }

    public Long getBufferSize() {
        return this._size;
    }

    public ILSRPoolBuffer.BufferUsageValue getBufferUsage() {
        return this._type;
    }

    public Long getPoolNumber() {
        return this._pool;
    }

    public LSRPoolBufferType getObjectType() {
        return LSRPoolBufferType.getInstance();
    }

    @Override
    public LSRPoolBufferReference getCICSObjectReference() {
        return new LSRPoolBufferReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == LSRPoolBufferType.POOL_ID_BUFFER) {
            return (V)this.getPoolIDBuffer();
        }
        if (attribute == LSRPoolBufferType.HIPERSPACE_BUFFERS_COUNT) {
            return (V)this.getHiperspaceBuffersCount();
        }
        if (attribute == LSRPoolBufferType.LOOKASIDE_BUFFER_READS_COUNT) {
            return (V)this.getLookasideBufferReadsCount();
        }
        if (attribute == LSRPoolBufferType.BUFFER_READS_COUNT) {
            return (V)this.getBufferReadsCount();
        }
        if (attribute == LSRPoolBufferType.USER_WRITES) {
            return (V)this.getUserWrites();
        }
        if (attribute == LSRPoolBufferType.NON_USER_WRITES) {
            return (V)this.getNonUserWrites();
        }
        if (attribute == LSRPoolBufferType.SUCCESSFUL_CREADS) {
            return (V)this.getSuccessfulCreads();
        }
        if (attribute == LSRPoolBufferType.SUCCESSFUL_CWRITES) {
            return (V)this.getSuccessfulCwrites();
        }
        if (attribute == LSRPoolBufferType.FAILED_CREAD_REQUESTS_COUNT) {
            return (V)this.getFailedCREADRequestsCount();
        }
        if (attribute == LSRPoolBufferType.FAILED_CWRITE_REQUESTS_COUNT) {
            return (V)this.getFailedCWRITERequestsCount();
        }
        if (attribute == LSRPoolBufferType.BUFFERS_COUNT) {
            return (V)this.getBuffersCount();
        }
        if (attribute == LSRPoolBufferType.BUFFER_SIZE) {
            return (V)this.getBufferSize();
        }
        if (attribute == LSRPoolBufferType.BUFFER_USAGE) {
            return (V)this.getBufferUsage();
        }
        if (attribute == LSRPoolBufferType.POOL_NUMBER) {
            return (V)this.getPoolNumber();
        }
        return super.getAttributeValue(attribute);
    }
}

