/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.common.util;

public class CNXCode {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2010, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int ADD = 601;
    public static final int DELETE = 603;
    public static final int DISCARD = 605;
    public static final int GET_ONE = 607;
    public static final int INSTALL = 609;
    public static final int PERFORM = 611;
    public static final int REMOVE_FROM_CSD_LIST = 613;
    public static final int REMOVE_FROM_RESOURCE_DESCRIPTION = 615;
    public static final int REMOVE_FROM_RESOURCE_GROUP = 617;
    public static final int UPDATE = 619;
    public static final int CREATE = 621;
    public static final int GET_MANY = 623;
    public static final int ADD_BUNDLE = 627;
    public static final int REMOVE_BUNDLE = 629;
    private static final int ZOS_EXPLORER_MESSAGE_RANGE_START = 800;
    public static final int DELETE_ENTRY = 801;
    public static final int DELETE_HFS_ENTRY = 803;
    public static final int CANCEL_JOB = 805;
    public static final int DELETE_JOB = 807;
    public static final int SUBMIT_JOB = 809;

    private CNXCode() {
    }

    public static String getCNXError(int code) {
        return CNXCode.formatCNXCode(code + 1, 'E');
    }

    public static String getCNXInfo(int code) {
        return CNXCode.formatCNXCode(code, 'I');
    }

    private static String formatCNXCode(int code, char suffix) {
        return String.valueOf(CNXCode.getMessagePrefix(code)) + String.format("%04d", code) + suffix;
    }

    private static String getMessagePrefix(int code) {
        return code < 800 ? "CNX" : "IZE";
    }
}

