/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.common.util;

import com.ibm.cics.common.util.LabelUtil;
import com.ibm.cics.common.util.StringUtil;
import java.text.MessageFormat;
import java.util.Collection;

public class SimpleValidationHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String REGEX_CICS_ALLOWABLE_CHARS_1 = "[A-Za-z0-9\\$@#\\./\\-_%&?!:\\|\"=\u00ac,;<>]*";
    public static final String CICS_ALLOWABLE_CHARS_1 = "a-z, A-Z, 0-9, $@#./-_%&?!:|\"=\u00ac,;<>";
    public static final String REGEX_NOT_INITIAL_NUMBER = "^[0-9].*";
    public static final String REGEX_CICS_ALLOWABLE_URI = "[A-Za-z0-9,\\-_\\.~!*'();@&=+\\$,/?#\\[\\]]*";
    public static final String CICS_ALLOWABLE_URI = "a-z, A-Z, 0-9,-_.~!*'();@&=+$,/?#[]";
    public static final String SINGLE_SPACE = ": ";

    public static void validateLatin1CharsOnly(String string, String label) throws IllegalArgumentException {
        SimpleValidationHelper.validateNotNull(string, label);
        if (StringUtil.containsNonLatin1PrintableChars(string)) {
            throw new IllegalArgumentException(label != null ? String.valueOf(label) + SINGLE_SPACE + LabelUtil.getString("SimpleValidationRules_onlyLatin1charsAllowed") : LabelUtil.getString("SimpleValidationRules_onlyLatin1charsAllowed"));
        }
    }

    public static void validateMaxLength(String string, int maxLength, String label) throws IllegalArgumentException {
        SimpleValidationHelper.validateNotNull(string, label);
        if (maxLength >= 0 && string.length() > maxLength) {
            throw new IllegalArgumentException(label != null ? String.valueOf(label) + SINGLE_SPACE + MessageFormat.format(LabelUtil.getString("SimpleValidationRules_maxLength"), Integer.toString(string.length()), maxLength) : MessageFormat.format(LabelUtil.getString("SimpleValidationRules_maxLength"), Integer.toString(string.length()), maxLength));
        }
    }

    public static void validateMinMaxInclusive(Long l, long min, long max) throws IllegalArgumentException {
        if (l == null) {
            throw new IllegalArgumentException(LabelUtil.getString("SimpleValidationRules_nullArgument"));
        }
        if (max > Long.MIN_VALUE && l > max) {
            throw new IllegalArgumentException(MessageFormat.format(LabelUtil.getString("SimpleValidationRules_maxValue"), l, max));
        }
        if (min < Long.MAX_VALUE && l < min) {
            throw new IllegalArgumentException(MessageFormat.format(LabelUtil.getString("SimpleValidationRules_minValue"), l, min));
        }
    }

    public static void validateMinMaxInclusiveOrSpecial(Long value, long min, long max, Collection<Long> specials) {
        for (Long specialInstance : specials) {
            if (specialInstance != value) continue;
            return;
        }
        SimpleValidationHelper.validateMinMaxInclusive(value, min, max);
    }

    public static void validateNotNull(Object o, String label) {
        if (o == null) {
            throw new IllegalArgumentException(label != null ? String.valueOf(label) + SINGLE_SPACE + LabelUtil.getString("SimpleValidationRules_nullArgument") : LabelUtil.getString("SimpleValidationRules_nullArgument"));
        }
    }

    public static void validateCharacters(String value, String validExpression, String validCharacters, String label) {
        try {
            SimpleValidationHelper.validateMatchRegEx(value, validExpression, label);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(LabelUtil.getString("SimpleValidationHelper.validCharacters", e.getMessage(), validCharacters));
        }
    }

    public static void validateWhiteSpace(String value, String validCharacters, String label) {
        if (value.contains(" ")) {
            throw new IllegalArgumentException(label != null ? String.valueOf(label) + SINGLE_SPACE + LabelUtil.getString("SimpleValidationRules_containsSpace", validCharacters) : LabelUtil.getString("SimpleValidationRules_containsSpace", validCharacters));
        }
    }

    public static void validateMatchRegEx(String value, String validExpression, String label) {
        SimpleValidationHelper.validateNotNull(value, label);
        if (!value.matches(validExpression)) {
            throw new IllegalArgumentException(label != null ? String.valueOf(label) + SINGLE_SPACE + LabelUtil.getString("SimpleValidationRules_invalidCharacters") : LabelUtil.getString("SimpleValidationRules_invalidCharacters"));
        }
    }

    public static void validateNotInitialNumber(String value, String label) {
        SimpleValidationHelper.validateNotNull(value, label);
        if (value.matches(REGEX_NOT_INITIAL_NUMBER)) {
            throw new IllegalArgumentException(label != null ? String.valueOf(label) + SINGLE_SPACE + LabelUtil.getString("SimpleValidationRules_initialNumberInvalid") : LabelUtil.getString("SimpleValidationRules_initialNumberInvalid"));
        }
    }

    public static void validateTransactionChars(String value, String label) {
        SimpleValidationHelper.validateCicsAllowableCharsForLength(value, 4, label);
    }

    public static void validateHfsFilenameChars(String value, String label) {
        SimpleValidationHelper.validateCicsAllowableCharsForLength(value, 255, label);
    }

    public static void validateUseridChars(String value, String label) {
        SimpleValidationHelper.validateCicsAllowableCharsForLength(value, 8, label);
    }

    public static void validateCicsAllowableCharsForLength(String value, int length, String label) {
        SimpleValidationHelper.validateNotNull(value, label);
        SimpleValidationHelper.validateMaxLength(value, length, label);
        SimpleValidationHelper.validateCharacters(value, REGEX_CICS_ALLOWABLE_CHARS_1, CICS_ALLOWABLE_CHARS_1, label);
    }

    public static void validateURLChars(String value, String label) {
        SimpleValidationHelper.validateNotNull(value, label);
        SimpleValidationHelper.validateCharacters(value, REGEX_CICS_ALLOWABLE_URI, CICS_ALLOWABLE_URI, label);
    }

    public static void validateNotToStartWith(String value, String label, String compareToStr) {
        SimpleValidationHelper.validateNotNull(value, label);
        if (compareToStr != null && compareToStr.length() != 0 && value.length() > compareToStr.length() - 1 && value.substring(0, compareToStr.length()).compareToIgnoreCase(compareToStr) == 0) {
            throw new IllegalArgumentException(label != null ? String.valueOf(label) + SINGLE_SPACE + LabelUtil.getString("SimpleValidationRules_notToStartWith", compareToStr) : LabelUtil.getString("SimpleValidationRules_notToStartWith", compareToStr));
        }
    }
}

