/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.TypeNotFoundException;
import com.ibm.cics.sm.comm.sm.IModelNames;
import com.ibm.cics.sm.comm.sm.internal.IOperationRule;
import java.util.List;

public class ResourceAvailableRule
implements IOperationRule {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    List<String> supportedResources;

    public ResourceAvailableRule(List<String> supportedResources) {
        this.supportedResources = supportedResources;
    }

    @Override
    public boolean matches(String resourceType, IContext context, ICICSOperation operation) {
        boolean result = operation.getOperationType() == ICICSOperation.OperationType.GET && !this.supportedResources.isEmpty();
        return result;
    }

    @Override
    public boolean passes(String resourceType, IContext context, ICICSOperation operation) {
        String modelName;
        if (this.supportedResources.isEmpty()) {
            return true;
        }
        try {
            modelName = IModelNames.ModelNamesHelper.getModelName(resourceType);
        }
        catch (TypeNotFoundException typeNotFoundException) {
            return true;
        }
        return this.supportedResources.contains(modelName);
    }
}

