/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.INormalizer;
import com.ibm.cics.sm.comm.IResourceTables;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.sm.internal.CMCI41NormalizerFactory;
import com.ibm.cics.sm.comm.sm.internal.INormalizerFactory;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class SMRecord
extends SMConnectionRecord {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static HashMap encodings = new HashMap();
    private Map fields = new HashMap();
    private String data;
    private final INormalizerFactory normalizerFactory;

    static {
        encodings.put("&amp;", "&");
        encodings.put("&lt;", "<");
        encodings.put("&gt;", ">");
        encodings.put("&quot;", "\"");
        encodings.put("&apos;", "'");
    }

    public SMRecord(INormalizerFactory normalizerFactory, String resourceType, IContext context) {
        super(resourceType, context);
        this.normalizerFactory = normalizerFactory;
    }

    public SMRecord(INormalizerFactory normalizerFactory, String resourceType, Attributes attributes, IContext context) {
        this(normalizerFactory, resourceType, context);
        boolean isCSD = IResourceTables.Helper.isCICSDefinition((String)resourceType) && attributes.getValue("csdgroup").length() > 0;
        int i = 0;
        while (i < attributes.getLength()) {
            String field = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (isCSD && field.startsWith("userdata")) {
                this.fields.put(field.toUpperCase(Locale.ENGLISH), "FORCE_ATTRIBUTE_UNSUPPORTED");
            } else {
                this.fields.put(field.toUpperCase(Locale.ENGLISH), SMRecord.decode(value));
            }
            ++i;
        }
    }

    @Deprecated
    public SMRecord(String resourceName, String data, IContext context) {
        this((INormalizerFactory)new CMCI41NormalizerFactory(), resourceName, data, context);
    }

    @Deprecated
    public SMRecord(String resourceType, Attributes attributes, IContext context) {
        this((INormalizerFactory)new CMCI41NormalizerFactory(), resourceType, attributes, context);
    }

    public SMRecord(INormalizerFactory normalizerFactory, String resourceName, String data, IContext context) {
        this(normalizerFactory, resourceName, context);
        this.data = data;
        char quote = '\"';
        if (data.indexOf(quote) == -1) {
            quote = '\'';
        }
        int begin = data.indexOf(" ");
        int end = data.lastIndexOf("/");
        if (end == -1) {
            end = data.length();
        }
        StringBuffer sb = new StringBuffer(data.substring(begin + 1, end));
        int i = sb.indexOf(" ");
        while (i != -1) {
            if (sb.charAt(i - 1) == quote) {
                sb.replace(i, i + 1, ",");
            }
            i = sb.indexOf(" ", i + 1);
        }
        StringTokenizer st1 = new StringTokenizer(sb.toString(), ",");
        while (st1.hasMoreTokens()) {
            String token;
            StringTokenizer st2 = new StringTokenizer(st1.nextToken(), "=");
            String field = st2.nextToken().trim();
            String value = "";
            if (st2.hasMoreTokens() && (token = st2.nextToken()).length() > 2) {
                value = token.substring(1, token.length() - 1);
            }
            this.fields.put(field.toUpperCase(Locale.ENGLISH), SMRecord.decode(value));
        }
    }

    private static String decode(String value) {
        StringBuffer newValue = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            String encoding;
            String symbol;
            int offset;
            char ch = value.charAt(i);
            if (ch == '&' && (offset = value.indexOf(59, i)) != -1 && (symbol = (String)encodings.get(encoding = value.substring(i, offset + 1))) != null) {
                newValue.append(symbol);
                i = offset;
            } else {
                newValue.append(ch);
            }
            ++i;
        }
        return newValue.toString();
    }

    public String get(String attribute) {
        String value = (String)this.fields.get(attribute);
        return value;
    }

    public Map getFields() {
        return null;
    }

    public String toExternalForm() {
        return this.data;
    }

    public String toString() {
        return "SMRecord[" + this.getResourceType() + ", " + this.fields + "]";
    }

    public Map<String, INormalizer> getNormalizers() {
        return this.normalizerFactory.getNormalizers();
    }

    public void put(String keyFieldName, String value) {
        this.fields.put(keyFieldName, value);
    }
}

