/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.sm.comm.IChildContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IDefinitionContext;
import com.ibm.cics.sm.comm.IScopedContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ContextHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ContextHelper.class);

    public static String findScope(IContext context) {
        String scope = null;
        while (scope == null && context != null) {
            scope = ContextHelper.getScopeFrom(context);
            context = ContextHelper.getParentContext(context);
        }
        return scope;
    }

    public static String getScopeFrom(IContext context) {
        IScopedContext scopedContext;
        if (context instanceof IScopedContext && (scopedContext = (IScopedContext)context).getScope() != null && !scopedContext.getScope().equals("")) {
            return scopedContext.getScope();
        }
        return null;
    }

    public static <T extends IContext> T getContextFrom(IContext baseContext, Class<T> targetContext) {
        if (targetContext.isInstance(baseContext)) {
            return (T)((IContext)targetContext.cast(baseContext));
        }
        return baseContext == null ? null : (T)ContextHelper.getContextFrom(ContextHelper.getParentContext(baseContext), targetContext);
    }

    public static IContext getParentContext(IContext context) {
        if (context instanceof IChildContext) {
            return ((IChildContext)context).getParentContext();
        }
        return ContextHelper.getParentContextReflectively(context);
    }

    private static IContext getParentContextReflectively(IContext context) {
        Class<?> toCheck = context.getClass();
        try {
            Method getParentMethod = toCheck.getMethod("getParentContext", new Class[0]);
            Object o = getParentMethod.invoke((Object)context, new Object[0]);
            if (o instanceof IContext && o != context) {
                return (IContext)o;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return null;
    }

    public static String findGroup(IContext context) {
        IDefinitionContext groupContext = ContextHelper.getContextFrom(context, IDefinitionContext.class);
        return groupContext != null ? groupContext.getResourceGroup() : null;
    }

    public static String getContextOrScopeNameFor(IContext context) {
        IScopedContext scopedContext = ContextHelper.getContextFrom(context, IScopedContext.class);
        if (scopedContext != null && !StringUtil.isEmpty((String)scopedContext.getScope())) {
            return scopedContext.getScope();
        }
        if (context != null) {
            return context.getContext();
        }
        return null;
    }
}

