/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.errors;

import com.ibm.cics.sm.comm.IResourceErrorCode;
import com.ibm.cics.sm.comm.IResourceErrors;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractResourceErrors
implements IResourceErrors {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<Integer, IResourceErrorCode> errorCodes;

    @Override
    public IResourceErrorCode findErrorCodeByNumber(int errorCodeInt) {
        IResourceErrorCode errorCode = this.errorCodes().get(errorCodeInt);
        return errorCode != null ? errorCode : new IResourceErrors.UnknownError(errorCodeInt);
    }

    @Override
    public IResourceErrorCode findErrorCodeByMnemonic(String mnemonic) {
        Class<?> clazz = this.getClass();
        try {
            Field field = clazz.getField(mnemonic);
            if (IResourceErrorCode.class.isAssignableFrom(field.getType())) {
                return (IResourceErrorCode)field.get(null);
            }
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public Map<Integer, IResourceErrorCode> errorCodes() {
        if (this.errorCodes == null) {
            Field[] fields;
            HashMap<Integer, IResourceErrorCode> errorCodes = new HashMap<Integer, IResourceErrorCode>();
            Class<?> clazz = this.getClass();
            Field[] fieldArray = fields = clazz.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (IResourceErrorCode.class.isAssignableFrom(field.getType())) {
                    try {
                        IResourceErrorCode errorCode = (IResourceErrorCode)field.get(null);
                        errorCodes.put(errorCode.getErrorCode(), errorCode);
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                ++n2;
            }
            this.errorCodes = Collections.unmodifiableMap(errorCodes);
        }
        return this.errorCodes;
    }
}

