/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.Messages;
import com.ibm.cics.model.CICSAttributeHint;
import com.ibm.cics.model.CICSRelease;
import com.ibm.cics.model.Debug;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeHint;
import com.ibm.cics.model.IllegalCICSAttributeException;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;

public class CICSDoubleAttribute
extends CICSAttribute<Double> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    CICSDoubleAttribute(String propertyId, String categoryId, String cicsName, Double defaultValue, CICSRelease validFrom, CICSRelease validTo) {
        super(propertyId, categoryId, cicsName, Double.class, defaultValue, 1.0, Double.MIN_NORMAL, validFrom, validTo, null, null, null);
    }

    @Override
    public String getNormalizerKey() {
        return "LONG_NORMALIZER_KEY";
    }

    @Override
    protected String internalToExternalImpl(Double modelValue) throws IllegalCICSAttributeException {
        if (modelValue == 0.0) {
            return "0";
        }
        if ((double)modelValue.intValue() == modelValue) {
            return new Integer(modelValue.intValue()).toString();
        }
        return modelValue.toString();
    }

    @Override
    public Double externalToInternal(String stringValue) throws IllegalCICSAttributeException {
        Double modelValue;
        ICICSAttributeHint hint = this.getValuesHint();
        if (hint != null && hint.hasSpecialValues() && (modelValue = Double.valueOf(0.0)) != null) {
            if (Debug.DEBUG_ATTRIBUTES) {
                Exception exc = new Exception("externalToInternal:" + this.getCicsName() + ":" + stringValue + " > " + modelValue);
                logger.logp(Level.SEVERE, this.getClass().getName(), "externalToInternal", exc.getLocalizedMessage(), exc);
            }
            return modelValue;
        }
        try {
            return Double.parseDouble(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalCICSAttributeException(NLS.bind((String)Messages.CICSAttribute_invalidNumber, (Object[])new Object[]{stringValue}), (ICICSAttribute)this, (Object)stringValue);
        }
    }

    public ICICSAttributeHint getValuesHint() {
        return CICSAttributeHint.NONE;
    }
}

