/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.model.AttributeValue;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.AbstractFilteredContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CICSObjectPrimaryKey
extends AbstractFilteredContext
implements IPrimaryKey {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected final HashMap<String, String> attributes = new HashMap();
    private final IContext parentContext;

    public CICSObjectPrimaryKey(IContext context, ICICSObject cicsObject) {
        super(context);
        this.parentContext = context;
        for (ICICSAttribute attribute : cicsObject.getObjectType().getKeyAttributes()) {
            try {
                Object o = cicsObject.getAttributeValue((IAttribute)attribute);
                this.addAttribute(attribute, o);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public CICSObjectPrimaryKey(IContext context, Map<ICICSAttribute<?>, Object> attributes) {
        super(context);
        this.parentContext = context;
        for (Map.Entry<ICICSAttribute<?>, Object> keyPair : attributes.entrySet()) {
            this.addAttribute(keyPair.getKey(), keyPair.getValue());
        }
    }

    public CICSObjectPrimaryKey(IContext context, AttributeValue<?> ... attributeValues) {
        this(context, AttributeValue.mapify(attributeValues));
    }

    public static CICSObjectPrimaryKey create(IContext context, ICICSAttribute keyAttribute, Object value) {
        Map<ICICSAttribute<?>, Object> attributes = CICSObjectPrimaryKey.createKeyMapWithGivenAttribute(keyAttribute, value);
        return new CICSObjectPrimaryKey(context, attributes);
    }

    protected static Map<ICICSAttribute<?>, Object> createKeyMapWithGivenAttribute(ICICSAttribute keyAttribute, Object value) {
        HashMap keyMap = new HashMap(1);
        keyMap.put(keyAttribute, value);
        return keyMap;
    }

    public static CICSObjectPrimaryKey create(IContext context, ICICSAttribute[] keyAttributes, Object[] values) {
        Map<ICICSAttribute<?>, Object> attributes = CICSObjectPrimaryKey.createKeyMapWithGivenAttributes(keyAttributes, values);
        return new CICSObjectPrimaryKey(context, attributes);
    }

    protected static Map<ICICSAttribute<?>, Object> createKeyMapWithGivenAttributes(ICICSAttribute[] keyAttributes, Object[] values) {
        if (keyAttributes.length != values.length) {
            throw new IllegalArgumentException("Different array lengths for keys and values");
        }
        HashMap keyMap = new HashMap(keyAttributes.length);
        int i = 0;
        while (i < keyAttributes.length) {
            keyMap.put(keyAttributes[i], values[i]);
            ++i;
        }
        return keyMap;
    }

    protected void addAttribute(ICICSAttribute<?> attribute, Object modelValue) {
        if (modelValue != attribute.getUnsupportedValue()) {
            try {
                String externalValue = attribute.internalToExternal(modelValue);
                this.attributes.put(attribute.getCicsName(), externalValue);
            }
            catch (IllegalCICSAttributeException illegalCICSAttributeException) {}
        }
    }

    protected static boolean attributesMatch(IPrimaryKey thisPK, IPrimaryKey otherPK) {
        Set otherNames;
        Set thisNames = thisPK.getAttributeNames();
        if (!thisNames.equals(otherNames = otherPK.getAttributeNames())) {
            return false;
        }
        for (String name : thisNames) {
            String thisValue = thisPK.getAttributeValue(name);
            String otherValue = otherPK.getAttributeValue(name);
            if (thisValue == null && otherValue != null) {
                return false;
            }
            if (thisValue.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o instanceof CICSObjectPrimaryKey) {
            return this.equals((CICSObjectPrimaryKey)((Object)o));
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private boolean equals(CICSObjectPrimaryKey other) {
        return this.parentContext.equals(other.parentContext) && this.matches(other);
    }

    public boolean matches(IPrimaryKey other) {
        if (((Object)((Object)this)).getClass().equals(other.getClass())) {
            return CICSObjectPrimaryKey.attributesMatch(this, other);
        }
        return false;
    }

    public Set getAttributeNames() {
        return this.attributes.keySet();
    }

    public String getAttributeValue(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.getContext() + "/" + this.getScope() + "/" + this.attributes.values() + "]";
    }
}

