/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.TableDescriptions;
import com.ibm.cics.model.AttributeValue;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeHint;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICICSType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public abstract class CICSObjectReference<T extends ICICSObject>
implements ICICSObjectReference<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICICSType<T> type;
    private final Map<ICICSAttribute<?>, Object> attributes = new LinkedHashMap();

    protected CICSObjectReference(ICICSType<T> type, AttributeValue<?> ... attributeValues) {
        this.type = type;
        AttributeValue<?>[] attributeValueArray = attributeValues;
        int n = attributeValues.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeValue<?> attributeValue = attributeValueArray[n2];
            this.setAttributeValue(attributeValue);
            ++n2;
        }
        if (!this.attributes.keySet().equals(type.getKeyAttributes())) {
            throw new IllegalArgumentException("AttributeValues must contain an identical set of the attributes defined to be key attributes by supplied type " + type + " containing: " + type.getKeyAttributes().toArray() + ", supplied: " + this.attributes.keySet().toArray());
        }
    }

    private <E> void setAttributeValue(AttributeValue<E> attributeValue) {
        this.setAttributeValue(attributeValue.getAttribute(), attributeValue.getValue());
    }

    public ICICSType<T> getCICSType() {
        return this.type;
    }

    public <V> void setAttributeValue(ICICSAttribute<V> attribute, V value) {
        this.attributes.put(attribute, value);
    }

    public <V> V getAttributeValue(ICICSAttribute<V> attribute) {
        return (V)this.attributes.get(attribute);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CICSObjectReference other = (CICSObjectReference)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.attributes == null) {
            if (other.attributes != null) {
                return false;
            }
        } else {
            for (ICICSAttribute<?> attribute : this.attributes.keySet()) {
                Object otherVal;
                if (!other.attributes.containsKey(attribute)) {
                    return false;
                }
                Object myVal = this.attributes.get(attribute);
                if (CICSObjectReference.attributeValuesEqual(attribute, myVal, otherVal = other.attributes.get(attribute))) continue;
                return false;
            }
        }
        return !(this.getCICSContainer() == null ? other.getCICSContainer() != null : !this.getCICSContainer().equals(other.getCICSContainer()));
    }

    public T resolve() throws CICSActionException {
        ICICSObjectSet<T> objectSet = this.getCICSObjectSet();
        List list = objectSet.get();
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return (T)((ICICSObject)list.get(0));
        }
        throw new CICSActionException("Resolving reference [" + this + "] returned " + list.size() + " results, where 0 or 1 are expected");
    }

    private ICICSObjectSet<T> getCICSObjectSet() {
        ICICSObjectSet objectSet = this.getCICSContainer().getCICSObjectSet(this.getCICSType());
        FilterExpression expression = FilterExpression.NULL;
        for (Map.Entry<ICICSAttribute<?>, Object> entry : this.attributes.entrySet()) {
            if (entry.getValue() == entry.getKey().getUnsupportedValue()) continue;
            expression = this.addFilter(expression, entry.getKey(), entry.getValue());
        }
        objectSet.setFilter(expression);
        return objectSet;
    }

    public void delete() throws CICSActionException {
        this.getCICSObjectSet().delete();
    }

    private <X> FilterExpression addFilter(FilterExpression expression, ICICSAttribute<X> attribute, Object value) {
        return expression.and(FilterExpression.is(attribute, (Object)value));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.getCICSContainer() == null ? 0 : this.getCICSContainer().hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public String getDescription() {
        String tableDescription = TableDescriptions.getTableDescription(this.type);
        return NLS.bind((String)"{0} \"{1}\"", (Object[])new Object[]{tableDescription, this.getAttributesDescription()});
    }

    private String getAttributesDescription() {
        String attributeValue;
        String nameAttribute = this.type.getNameAttribute();
        ICICSAttribute attribute = this.type.findAttributeByCicsName(nameAttribute);
        if (attribute != null && attribute.getType() == String.class && (attributeValue = (String)this.getAttributeValue(attribute)) != null) {
            return attributeValue;
        }
        return "";
    }

    private static boolean attributeValuesEqual(ICICSAttribute<?> attribute, Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        ICICSAttributeHint hint = attribute.getValuesHint();
        if (hint.hasSpecialValues() && hint.getSpecialValues().values().contains(value1)) {
            return value2 == value1;
        }
        return value1.equals(value2);
    }

    public String toString() {
        return this.getDescription();
    }
}

