/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.EqualityHelper;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ILocalTransaction;
import com.ibm.cics.model.IProgram;
import com.ibm.cics.model.IRemoteTransaction;
import com.ibm.cics.model.IURIMap;

public class OperationTypesWrapper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICICSResource cicsResourceWithOperation;
    private final IApplication application;

    public OperationTypesWrapper(IApplication application, ICICSResource aCicsResourceWithOperation) {
        this.cicsResourceWithOperation = aCicsResourceWithOperation;
        this.application = application;
    }

    public ICICSResource getCicsResourceWithOperation() {
        return this.cicsResourceWithOperation;
    }

    public String getOperationName() {
        if (this.cicsResourceWithOperation instanceof IProgram) {
            return ((IProgram)this.cicsResourceWithOperation).getOperationName();
        }
        if (this.cicsResourceWithOperation instanceof IURIMap) {
            return ((IURIMap)this.cicsResourceWithOperation).getOperationName();
        }
        if (this.cicsResourceWithOperation instanceof ILocalTransaction) {
            return ((ILocalTransaction)this.cicsResourceWithOperation).getOperationName();
        }
        if (this.cicsResourceWithOperation instanceof IRemoteTransaction) {
            return ((IRemoteTransaction)this.cicsResourceWithOperation).getOperationName();
        }
        return null;
    }

    public IApplication getApplication() {
        return this.application;
    }

    public String getApplicationName() {
        if (this.cicsResourceWithOperation instanceof IProgram) {
            return ((IProgram)this.cicsResourceWithOperation).getApplicationName();
        }
        if (this.cicsResourceWithOperation instanceof IURIMap) {
            return ((IURIMap)this.cicsResourceWithOperation).getApplicationName();
        }
        if (this.cicsResourceWithOperation instanceof ILocalTransaction) {
            return ((ILocalTransaction)this.cicsResourceWithOperation).getApplicationName();
        }
        if (this.cicsResourceWithOperation instanceof IRemoteTransaction) {
            return ((IRemoteTransaction)this.cicsResourceWithOperation).getApplicationName();
        }
        return null;
    }

    public String getPlatformName() {
        if (this.cicsResourceWithOperation instanceof IProgram) {
            return ((IProgram)this.cicsResourceWithOperation).getPlatformName();
        }
        if (this.cicsResourceWithOperation instanceof IURIMap) {
            return ((IURIMap)this.cicsResourceWithOperation).getPlatformName();
        }
        if (this.cicsResourceWithOperation instanceof ILocalTransaction) {
            return ((ILocalTransaction)this.cicsResourceWithOperation).getPlatformName();
        }
        if (this.cicsResourceWithOperation instanceof IRemoteTransaction) {
            return ((IRemoteTransaction)this.cicsResourceWithOperation).getPlatformName();
        }
        return null;
    }

    public Long getMajorVersion() {
        if (this.cicsResourceWithOperation instanceof IProgram) {
            return ((IProgram)this.cicsResourceWithOperation).getMajorVersion();
        }
        if (this.cicsResourceWithOperation instanceof IURIMap) {
            return ((IURIMap)this.cicsResourceWithOperation).getMajorVersion();
        }
        if (this.cicsResourceWithOperation instanceof ILocalTransaction) {
            return ((ILocalTransaction)this.cicsResourceWithOperation).getMajorVersion();
        }
        if (this.cicsResourceWithOperation instanceof IRemoteTransaction) {
            return ((IRemoteTransaction)this.cicsResourceWithOperation).getMajorVersion();
        }
        return -1L;
    }

    public Long getMinorVersion() {
        if (this.cicsResourceWithOperation instanceof IProgram) {
            return ((IProgram)this.cicsResourceWithOperation).getMinorVersion();
        }
        if (this.cicsResourceWithOperation instanceof IURIMap) {
            return ((IURIMap)this.cicsResourceWithOperation).getMinorVersion();
        }
        if (this.cicsResourceWithOperation instanceof ILocalTransaction) {
            return ((ILocalTransaction)this.cicsResourceWithOperation).getMinorVersion();
        }
        if (this.cicsResourceWithOperation instanceof IRemoteTransaction) {
            return ((IRemoteTransaction)this.cicsResourceWithOperation).getMinorVersion();
        }
        return -1L;
    }

    public Long getMicroVersion() {
        if (this.cicsResourceWithOperation instanceof IProgram) {
            return ((IProgram)this.cicsResourceWithOperation).getMicroVersion();
        }
        if (this.cicsResourceWithOperation instanceof IURIMap) {
            return ((IURIMap)this.cicsResourceWithOperation).getMicroVersion();
        }
        if (this.cicsResourceWithOperation instanceof ILocalTransaction) {
            return ((ILocalTransaction)this.cicsResourceWithOperation).getMicroVersion();
        }
        if (this.cicsResourceWithOperation instanceof IRemoteTransaction) {
            return ((IRemoteTransaction)this.cicsResourceWithOperation).getMicroVersion();
        }
        return -1L;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.application == null ? 0 : this.application.hashCode());
        result = 31 * result + (this.cicsResourceWithOperation == null ? 0 : this.cicsResourceWithOperation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperationTypesWrapper other = (OperationTypesWrapper)obj;
        if (this.application == null ? other.application != null : !EqualityHelper.equals((ICICSObject)this.application, (ICICSObject)other.application)) {
            return false;
        }
        return !(this.cicsResourceWithOperation == null ? other.cicsResourceWithOperation != null : !EqualityHelper.equals((ICICSObject)this.cicsResourceWithOperation, (ICICSObject)other.cicsResourceWithOperation));
    }
}

