/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.DB2TransactionReference;
import com.ibm.cics.core.model.DB2TransactionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.IDB2Transaction;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;
import java.util.Map;

public class DB2Transaction
extends CICSResource
implements IDB2Transaction {
    private String _name;
    private String _db2entry;
    private String _transid;
    private String _plan;
    private String _planexitname;
    private IDB2Transaction.ChangeAgentValue _changeagent;
    private String _changeusrid;
    private String _changeagrel;
    private IDB2Transaction.InstallAgentValue _installagent;
    private Date _changetime;
    private String _definesource;
    private Date _definetime;
    private String _installusrid;
    private Date _installtime;
    private Long _basdefinever;

    public DB2Transaction(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("NAME");
        this._name = (String)((CICSAttribute)DB2TransactionType.NAME).get(stringValue, normalizers);
        stringValue = record.get("DB2ENTRY");
        this._db2entry = (String)((CICSAttribute)DB2TransactionType.DB2_ENTRY).get(stringValue, normalizers);
        stringValue = record.get("TRANSID");
        this._transid = (String)((CICSAttribute)DB2TransactionType.TRANSACTION).get(stringValue, normalizers);
        stringValue = record.get("PLAN");
        this._plan = (String)((CICSAttribute)DB2TransactionType.PLAN).get(stringValue, normalizers);
        stringValue = record.get("PLANEXITNAME");
        this._planexitname = (String)((CICSAttribute)DB2TransactionType.PLAN_EXIT).get(stringValue, normalizers);
        stringValue = record.get("CHANGEAGENT");
        this._changeagent = (IDB2Transaction.ChangeAgentValue)((CICSAttribute)DB2TransactionType.CHANGE_AGENT).get(stringValue, normalizers);
        stringValue = record.get("CHANGEUSRID");
        this._changeusrid = (String)((CICSAttribute)DB2TransactionType.CHANGE_USER_ID).get(stringValue, normalizers);
        stringValue = record.get("CHANGEAGREL");
        this._changeagrel = (String)((CICSAttribute)DB2TransactionType.CHANGE_AGENT_RELEASE).get(stringValue, normalizers);
        stringValue = record.get("INSTALLAGENT");
        this._installagent = (IDB2Transaction.InstallAgentValue)((CICSAttribute)DB2TransactionType.INSTALL_AGENT).get(stringValue, normalizers);
        stringValue = record.get("CHANGETIME");
        this._changetime = (Date)((CICSAttribute)DB2TransactionType.CHANGE_TIME).get(stringValue, normalizers);
        stringValue = record.get("DEFINESOURCE");
        this._definesource = (String)((CICSAttribute)DB2TransactionType.DEFINE_SOURCE).get(stringValue, normalizers);
        stringValue = record.get("DEFINETIME");
        this._definetime = (Date)((CICSAttribute)DB2TransactionType.DEFINE_TIME).get(stringValue, normalizers);
        stringValue = record.get("INSTALLUSRID");
        this._installusrid = (String)((CICSAttribute)DB2TransactionType.INSTALL_USER_ID).get(stringValue, normalizers);
        stringValue = record.get("INSTALLTIME");
        this._installtime = (Date)((CICSAttribute)DB2TransactionType.INSTALL_TIME).get(stringValue, normalizers);
        stringValue = record.get("BASDEFINEVER");
        this._basdefinever = (Long)((CICSAttribute)DB2TransactionType.BASDEFINEVER).get(stringValue, normalizers);
    }

    public String getName() {
        return this._name;
    }

    public String getDB2Entry() {
        return this._db2entry;
    }

    public String getTransaction() {
        return this._transid;
    }

    public String getPlan() {
        return this._plan;
    }

    public String getPlanExit() {
        return this._planexitname;
    }

    public IDB2Transaction.ChangeAgentValue getChangeAgent() {
        return this._changeagent;
    }

    public String getChangeUserID() {
        return this._changeusrid;
    }

    public String getChangeAgentRelease() {
        return this._changeagrel;
    }

    public IDB2Transaction.InstallAgentValue getInstallAgent() {
        return this._installagent;
    }

    public Date getChangeTime() {
        return this._changetime;
    }

    public String getDefineSource() {
        return this._definesource;
    }

    public Date getDefineTime() {
        return this._definetime;
    }

    public String getInstallUserID() {
        return this._installusrid;
    }

    public Date getInstallTime() {
        return this._installtime;
    }

    public Long getBasdefinever() {
        return this._basdefinever;
    }

    public DB2TransactionType getObjectType() {
        return DB2TransactionType.getInstance();
    }

    @Override
    public DB2TransactionReference getCICSObjectReference() {
        return new DB2TransactionReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == DB2TransactionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == DB2TransactionType.DB2_ENTRY) {
            return (V)this.getDB2Entry();
        }
        if (attribute == DB2TransactionType.TRANSACTION) {
            return (V)this.getTransaction();
        }
        if (attribute == DB2TransactionType.PLAN) {
            return (V)this.getPlan();
        }
        if (attribute == DB2TransactionType.PLAN_EXIT) {
            return (V)this.getPlanExit();
        }
        if (attribute == DB2TransactionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == DB2TransactionType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == DB2TransactionType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == DB2TransactionType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == DB2TransactionType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == DB2TransactionType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == DB2TransactionType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == DB2TransactionType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == DB2TransactionType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == DB2TransactionType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        return super.getAttributeValue(attribute);
    }
}

