/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.LocalTransactionReference;
import com.ibm.cics.core.model.LocalTransactionType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ILocalTransaction;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableLocalTransaction;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableLocalTransaction
extends MutableCICSResource
implements IMutableLocalTransaction {
    private ILocalTransaction delegate;
    private MutableSMRecord record;

    public MutableLocalTransaction(ICPSM cpsm, IContext context, ILocalTransaction cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("LOCTRAN");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public ILocalTransaction.CommandSecurityValue getCommandSecurity() {
        return this.delegate.getCommandSecurity();
    }

    public Long getDeadlockTimeout() {
        return this.delegate.getDeadlockTimeout();
    }

    public ILocalTransaction.DumpingValue getDumping() {
        String result = this.record.get("DUMPING");
        if (result == null) {
            return this.delegate.getDumping();
        }
        return (ILocalTransaction.DumpingValue)((CICSAttribute)LocalTransactionType.DUMPING).get(result, this.record.getNormalizers());
    }

    public Long getPriority() {
        String result = this.record.get("PRIORITY");
        if (result == null) {
            return this.delegate.getPriority();
        }
        return (Long)((CICSAttribute)LocalTransactionType.PRIORITY).get(result, this.record.getNormalizers());
    }

    public String getProgram() {
        return this.delegate.getProgram();
    }

    public ILocalTransaction.PurgeabilityValue getPurgeability() {
        String result = this.record.get("PURGEABILITY");
        if (result == null) {
            return this.delegate.getPurgeability();
        }
        return (ILocalTransaction.PurgeabilityValue)((CICSAttribute)LocalTransactionType.PURGEABILITY).get(result, this.record.getNormalizers());
    }

    public Long getReadTimeout() {
        return this.delegate.getReadTimeout();
    }

    public ILocalTransaction.ScreenSizeValue getScreenSize() {
        return this.delegate.getScreenSize();
    }

    public ICICSEnums.EnablementValue getStatus() {
        String result = this.record.get("STATUS");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (ICICSEnums.EnablementValue)((CICSAttribute)LocalTransactionType.STATUS).get(result, this.record.getNormalizers());
    }

    public ILocalTransaction.TracingValue getTracing() {
        String result = this.record.get("TRACING");
        if (result == null) {
            return this.delegate.getTracing();
        }
        return (ILocalTransaction.TracingValue)((CICSAttribute)LocalTransactionType.TRACING).get(result, this.record.getNormalizers());
    }

    public Long getTWASize() {
        return this.delegate.getTWASize();
    }

    public Long getUseCount() {
        return this.delegate.getUseCount();
    }

    public Long getLocalUseCount() {
        return this.delegate.getLocalUseCount();
    }

    public Long getStorageViolationCount() {
        return this.delegate.getStorageViolationCount();
    }

    public String getProfile() {
        return this.delegate.getProfile();
    }

    public ILocalTransaction.ResourceSecurityValue getResourceSecurity() {
        return this.delegate.getResourceSecurity();
    }

    public ILocalTransaction.TaskDataLocationValue getTaskDataLocation() {
        return this.delegate.getTaskDataLocation();
    }

    public ILocalTransaction.TaskDataKeyValue getTaskDataKey() {
        return this.delegate.getTaskDataKey();
    }

    public ILocalTransaction.RoutingValue getRouting() {
        return this.delegate.getRouting();
    }

    public Long getRestartCount() {
        return this.delegate.getRestartCount();
    }

    public Long getRemoteCount() {
        return this.delegate.getRemoteCount();
    }

    public Long getRemoteStartCount() {
        return this.delegate.getRemoteStartCount();
    }

    public ILocalTransaction.DataIsolationValue getDataIsolation() {
        return this.delegate.getDataIsolation();
    }

    public Long getRunawayTime() {
        String result = this.record.get("RUNAWAY");
        if (result == null) {
            return this.delegate.getRunawayTime();
        }
        return (Long)((CICSAttribute)LocalTransactionType.RUNAWAY_TIME).get(result, this.record.getNormalizers());
    }

    public ILocalTransaction.RunawayTypeValue getRunawayType() {
        String result = this.record.get("RUNAWAYTYPE");
        if (result == null) {
            return this.delegate.getRunawayType();
        }
        return (ILocalTransaction.RunawayTypeValue)((CICSAttribute)LocalTransactionType.RUNAWAY_TYPE).get(result, this.record.getNormalizers());
    }

    public ILocalTransaction.ShutdownValue getShutdown() {
        String result = this.record.get("SHUTDOWN");
        if (result == null) {
            return this.delegate.getShutdown();
        }
        return (ILocalTransaction.ShutdownValue)((CICSAttribute)LocalTransactionType.SHUTDOWN).get(result, this.record.getNormalizers());
    }

    public ILocalTransaction.StorageClearanceValue getStorageClearance() {
        return this.delegate.getStorageClearance();
    }

    public String getTransactionClass() {
        String result = this.record.get("TRANCLASS");
        if (result == null) {
            return this.delegate.getTransactionClass();
        }
        return (String)((CICSAttribute)LocalTransactionType.TRANSACTION_CLASS).get(result, this.record.getNormalizers());
    }

    public String getRemoteName() {
        return this.delegate.getRemoteName();
    }

    public String getRemoteSystem() {
        return this.delegate.getRemoteSystem();
    }

    public String getTransactionRoutingProfile() {
        return this.delegate.getTransactionRoutingProfile();
    }

    public ILocalTransaction.IndoubtWaitValue getIndoubtWait() {
        return this.delegate.getIndoubtWait();
    }

    public ILocalTransaction.IndoubtValue getIndoubt() {
        return this.delegate.getIndoubt();
    }

    public Long getIndoubtWaitTime() {
        return this.delegate.getIndoubtWaitTime();
    }

    public Long getIndoubtWaitCount() {
        return this.delegate.getIndoubtWaitCount();
    }

    public Long getTransactionForcedActionCount() {
        return this.delegate.getTransactionForcedActionCount();
    }

    public Long getTimeoutForcedActionCount() {
        return this.delegate.getTimeoutForcedActionCount();
    }

    public Long getWaitForcedActionCount() {
        return this.delegate.getWaitForcedActionCount();
    }

    public Long getOperatorForcedActionCount() {
        return this.delegate.getOperatorForcedActionCount();
    }

    public Long getOtherForcedActionCount() {
        return this.delegate.getOtherForcedActionCount();
    }

    public Long getIndoubtActionMismatchCount() {
        return this.delegate.getIndoubtActionMismatchCount();
    }

    public String getFacilityLike() {
        return this.delegate.getFacilityLike();
    }

    public String getBridgeExitProgram() {
        return this.delegate.getBridgeExitProgram();
    }

    public ILocalTransaction.RoutingStatusValue getRoutingStatus() {
        return this.delegate.getRoutingStatus();
    }

    public Long getOTSTimeout() {
        return this.delegate.getOTSTimeout();
    }

    public ILocalTransaction.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public ILocalTransaction.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public String getApplicationName() {
        return this.delegate.getApplicationName();
    }

    public String getPlatformName() {
        return this.delegate.getPlatformName();
    }

    public String getOperationName() {
        return this.delegate.getOperationName();
    }

    public Long getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    public Long getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    public Long getMicroVersion() {
        return this.delegate.getMicroVersion();
    }

    public ILocalTransaction.AvailabilityValue getAvailability() {
        return this.delegate.getAvailability();
    }

    public void setDumping(ILocalTransaction.DumpingValue _dumping) {
        if (_dumping.equals((Object)this.delegate.getDumping())) {
            this.record.set("DUMPING", null);
        } else {
            LocalTransactionType.DUMPING.validate((Object)_dumping);
            String connectionSpecificExternalValue = ((CICSAttribute)LocalTransactionType.DUMPING).set(_dumping, this.record.getNormalizers());
            this.record.set("DUMPING", connectionSpecificExternalValue);
        }
    }

    public void setPriority(Long _priority) {
        if (_priority.equals(this.delegate.getPriority())) {
            this.record.set("PRIORITY", null);
        } else {
            LocalTransactionType.PRIORITY.validate((Object)_priority);
            String connectionSpecificExternalValue = ((CICSAttribute)LocalTransactionType.PRIORITY).set(_priority, this.record.getNormalizers());
            this.record.set("PRIORITY", connectionSpecificExternalValue);
        }
    }

    public void setPurgeability(ILocalTransaction.PurgeabilityValue _purgeability) {
        if (_purgeability.equals((Object)this.delegate.getPurgeability())) {
            this.record.set("PURGEABILITY", null);
        } else {
            LocalTransactionType.PURGEABILITY.validate((Object)_purgeability);
            String connectionSpecificExternalValue = ((CICSAttribute)LocalTransactionType.PURGEABILITY).set(_purgeability, this.record.getNormalizers());
            this.record.set("PURGEABILITY", connectionSpecificExternalValue);
        }
    }

    public void setStatus(ICICSEnums.EnablementValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("STATUS", null);
        } else {
            LocalTransactionType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)LocalTransactionType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("STATUS", connectionSpecificExternalValue);
        }
    }

    public void setTracing(ILocalTransaction.TracingValue _tracing) {
        if (_tracing.equals((Object)this.delegate.getTracing())) {
            this.record.set("TRACING", null);
        } else {
            LocalTransactionType.TRACING.validate((Object)_tracing);
            String connectionSpecificExternalValue = ((CICSAttribute)LocalTransactionType.TRACING).set(_tracing, this.record.getNormalizers());
            this.record.set("TRACING", connectionSpecificExternalValue);
        }
    }

    public void setRunawayTime(Long _runawayTime) {
        if (_runawayTime.equals(this.delegate.getRunawayTime())) {
            this.record.set("RUNAWAY", null);
        } else {
            LocalTransactionType.RUNAWAY_TIME.validate((Object)_runawayTime);
            String connectionSpecificExternalValue = ((CICSAttribute)LocalTransactionType.RUNAWAY_TIME).set(_runawayTime, this.record.getNormalizers());
            this.record.set("RUNAWAY", connectionSpecificExternalValue);
        }
    }

    public void setRunawayType(ILocalTransaction.RunawayTypeValue _runawayType) {
        if (_runawayType.equals((Object)this.delegate.getRunawayType())) {
            this.record.set("RUNAWAYTYPE", null);
        } else {
            LocalTransactionType.RUNAWAY_TYPE.validate((Object)_runawayType);
            String connectionSpecificExternalValue = ((CICSAttribute)LocalTransactionType.RUNAWAY_TYPE).set(_runawayType, this.record.getNormalizers());
            this.record.set("RUNAWAYTYPE", connectionSpecificExternalValue);
        }
    }

    public void setShutdown(ILocalTransaction.ShutdownValue _shutdown) {
        if (_shutdown.equals((Object)this.delegate.getShutdown())) {
            this.record.set("SHUTDOWN", null);
        } else {
            LocalTransactionType.SHUTDOWN.validate((Object)_shutdown);
            String connectionSpecificExternalValue = ((CICSAttribute)LocalTransactionType.SHUTDOWN).set(_shutdown, this.record.getNormalizers());
            this.record.set("SHUTDOWN", connectionSpecificExternalValue);
        }
    }

    public void setTransactionClass(String _transactionClass) {
        if (_transactionClass.equals(this.delegate.getTransactionClass())) {
            this.record.set("TRANCLASS", null);
        } else {
            LocalTransactionType.TRANSACTION_CLASS.validate((Object)_transactionClass);
            String connectionSpecificExternalValue = ((CICSAttribute)LocalTransactionType.TRANSACTION_CLASS).set(_transactionClass, this.record.getNormalizers());
            this.record.set("TRANCLASS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == LocalTransactionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == LocalTransactionType.COMMAND_SECURITY) {
            return (V)this.getCommandSecurity();
        }
        if (attribute == LocalTransactionType.DEADLOCK_TIMEOUT) {
            return (V)this.getDeadlockTimeout();
        }
        if (attribute == LocalTransactionType.DUMPING) {
            return (V)this.getDumping();
        }
        if (attribute == LocalTransactionType.PRIORITY) {
            return (V)this.getPriority();
        }
        if (attribute == LocalTransactionType.PROGRAM) {
            return (V)this.getProgram();
        }
        if (attribute == LocalTransactionType.PURGEABILITY) {
            return (V)this.getPurgeability();
        }
        if (attribute == LocalTransactionType.READ_TIMEOUT) {
            return (V)this.getReadTimeout();
        }
        if (attribute == LocalTransactionType.SCREEN_SIZE) {
            return (V)this.getScreenSize();
        }
        if (attribute == LocalTransactionType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == LocalTransactionType.TRACING) {
            return (V)this.getTracing();
        }
        if (attribute == LocalTransactionType.TWA_SIZE) {
            return (V)this.getTWASize();
        }
        if (attribute == LocalTransactionType.USE_COUNT) {
            return (V)this.getUseCount();
        }
        if (attribute == LocalTransactionType.LOCAL_USE_COUNT) {
            return (V)this.getLocalUseCount();
        }
        if (attribute == LocalTransactionType.STORAGE_VIOLATION_COUNT) {
            return (V)this.getStorageViolationCount();
        }
        if (attribute == LocalTransactionType.PROFILE) {
            return (V)this.getProfile();
        }
        if (attribute == LocalTransactionType.RESOURCE_SECURITY) {
            return (V)this.getResourceSecurity();
        }
        if (attribute == LocalTransactionType.TASK_DATA_LOCATION) {
            return (V)this.getTaskDataLocation();
        }
        if (attribute == LocalTransactionType.TASK_DATA_KEY) {
            return (V)this.getTaskDataKey();
        }
        if (attribute == LocalTransactionType.ROUTING) {
            return (V)this.getRouting();
        }
        if (attribute == LocalTransactionType.RESTART_COUNT) {
            return (V)this.getRestartCount();
        }
        if (attribute == LocalTransactionType.REMOTE_COUNT) {
            return (V)this.getRemoteCount();
        }
        if (attribute == LocalTransactionType.REMOTE_START_COUNT) {
            return (V)this.getRemoteStartCount();
        }
        if (attribute == LocalTransactionType.DATA_ISOLATION) {
            return (V)this.getDataIsolation();
        }
        if (attribute == LocalTransactionType.RUNAWAY_TIME) {
            return (V)this.getRunawayTime();
        }
        if (attribute == LocalTransactionType.RUNAWAY_TYPE) {
            return (V)this.getRunawayType();
        }
        if (attribute == LocalTransactionType.SHUTDOWN) {
            return (V)this.getShutdown();
        }
        if (attribute == LocalTransactionType.STORAGE_CLEARANCE) {
            return (V)this.getStorageClearance();
        }
        if (attribute == LocalTransactionType.TRANSACTION_CLASS) {
            return (V)this.getTransactionClass();
        }
        if (attribute == LocalTransactionType.REMOTE_NAME) {
            return (V)this.getRemoteName();
        }
        if (attribute == LocalTransactionType.REMOTE_SYSTEM) {
            return (V)this.getRemoteSystem();
        }
        if (attribute == LocalTransactionType.TRANSACTION_ROUTING_PROFILE) {
            return (V)this.getTransactionRoutingProfile();
        }
        if (attribute == LocalTransactionType.INDOUBT_WAIT) {
            return (V)this.getIndoubtWait();
        }
        if (attribute == LocalTransactionType.INDOUBT) {
            return (V)this.getIndoubt();
        }
        if (attribute == LocalTransactionType.INDOUBT_WAIT_TIME) {
            return (V)this.getIndoubtWaitTime();
        }
        if (attribute == LocalTransactionType.INDOUBT_WAIT_COUNT) {
            return (V)this.getIndoubtWaitCount();
        }
        if (attribute == LocalTransactionType.TRANSACTION_FORCED_ACTION_COUNT) {
            return (V)this.getTransactionForcedActionCount();
        }
        if (attribute == LocalTransactionType.TIMEOUT_FORCED_ACTION_COUNT) {
            return (V)this.getTimeoutForcedActionCount();
        }
        if (attribute == LocalTransactionType.WAIT_FORCED_ACTION_COUNT) {
            return (V)this.getWaitForcedActionCount();
        }
        if (attribute == LocalTransactionType.OPERATOR_FORCED_ACTION_COUNT) {
            return (V)this.getOperatorForcedActionCount();
        }
        if (attribute == LocalTransactionType.OTHER_FORCED_ACTION_COUNT) {
            return (V)this.getOtherForcedActionCount();
        }
        if (attribute == LocalTransactionType.INDOUBT_ACTION_MISMATCH_COUNT) {
            return (V)this.getIndoubtActionMismatchCount();
        }
        if (attribute == LocalTransactionType.FACILITY_LIKE) {
            return (V)this.getFacilityLike();
        }
        if (attribute == LocalTransactionType.BRIDGE_EXIT_PROGRAM) {
            return (V)this.getBridgeExitProgram();
        }
        if (attribute == LocalTransactionType.ROUTING_STATUS) {
            return (V)this.getRoutingStatus();
        }
        if (attribute == LocalTransactionType.OTS_TIMEOUT) {
            return (V)this.getOTSTimeout();
        }
        if (attribute == LocalTransactionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == LocalTransactionType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == LocalTransactionType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == LocalTransactionType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == LocalTransactionType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == LocalTransactionType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == LocalTransactionType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == LocalTransactionType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == LocalTransactionType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == LocalTransactionType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        if (attribute == LocalTransactionType.APPLICATION_NAME) {
            return (V)this.getApplicationName();
        }
        if (attribute == LocalTransactionType.PLATFORM_NAME) {
            return (V)this.getPlatformName();
        }
        if (attribute == LocalTransactionType.OPERATION_NAME) {
            return (V)this.getOperationName();
        }
        if (attribute == LocalTransactionType.MAJOR_VERSION) {
            return (V)this.getMajorVersion();
        }
        if (attribute == LocalTransactionType.MINOR_VERSION) {
            return (V)this.getMinorVersion();
        }
        if (attribute == LocalTransactionType.MICRO_VERSION) {
            return (V)this.getMicroVersion();
        }
        if (attribute == LocalTransactionType.AVAILABILITY) {
            return (V)this.getAvailability();
        }
        return super.getAttributeValue(attribute);
    }

    public LocalTransactionType getObjectType() {
        return LocalTransactionType.getInstance();
    }

    @Override
    public LocalTransactionReference getCICSObjectReference() {
        return new LocalTransactionReference(this.getCICSContainer(), this.getName());
    }
}

