/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.URIMapReference;
import com.ibm.cics.core.model.URIMapType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IURIMap;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableURIMap;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableURIMap
extends MutableCICSResource
implements IMutableURIMap {
    private IURIMap delegate;
    private MutableSMRecord record;

    public MutableURIMap(ICPSM cpsm, IContext context, IURIMap cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("URIMAP");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public IURIMap.StatusValue getStatus() {
        String result = this.record.get("ENABLESTATUS");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (IURIMap.StatusValue)((CICSAttribute)URIMapType.STATUS).get(result, this.record.getNormalizers());
    }

    public IURIMap.UsageValue getUsage() {
        return this.delegate.getUsage();
    }

    public IURIMap.SchemeValue getScheme() {
        return this.delegate.getScheme();
    }

    public String getHost() {
        return this.delegate.getHost();
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    public String getMediatype() {
        return this.delegate.getMediatype();
    }

    public String getCharacterset() {
        return this.delegate.getCharacterset();
    }

    public String getHostcodepage() {
        return this.delegate.getHostcodepage();
    }

    public String getTemplatename() {
        return this.delegate.getTemplatename();
    }

    public String getHfsfile() {
        return this.delegate.getHfsfile();
    }

    public String getTCPIPService() {
        return this.delegate.getTCPIPService();
    }

    public IURIMap.AnalyzerstatValue getAnalyzerstat() {
        return this.delegate.getAnalyzerstat();
    }

    public String getConverter() {
        return this.delegate.getConverter();
    }

    public String getTransaction() {
        return this.delegate.getTransaction();
    }

    public String getProgram() {
        return this.delegate.getProgram();
    }

    public String getPipeline() {
        return this.delegate.getPipeline();
    }

    public String getWebService() {
        return this.delegate.getWebService();
    }

    public String getUserid() {
        return this.delegate.getUserid();
    }

    public String getCertificate() {
        return this.delegate.getCertificate();
    }

    public String getCiphers() {
        return this.delegate.getCiphers();
    }

    public String getLocation() {
        String result = this.record.get("LOCATION");
        if (result == null) {
            return this.delegate.getLocation();
        }
        return (String)((CICSAttribute)URIMapType.LOCATION).get(result, this.record.getNormalizers());
    }

    public Long getReferenceCount() {
        return this.delegate.getReferenceCount();
    }

    public Long getMatchdisabld() {
        return this.delegate.getMatchdisabld();
    }

    public Long getMatchredirec() {
        return this.delegate.getMatchredirec();
    }

    public Long getNumciphers() {
        return this.delegate.getNumciphers();
    }

    public IURIMap.RedirecttypeValue getRedirecttype() {
        String result = this.record.get("REDIRECTTYPE");
        if (result == null) {
            return this.delegate.getRedirecttype();
        }
        return (IURIMap.RedirecttypeValue)((CICSAttribute)URIMapType.REDIRECTTYPE).get(result, this.record.getNormalizers());
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public IURIMap.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public IURIMap.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public String getAtomservice() {
        return this.delegate.getAtomservice();
    }

    public String getIpresolved() {
        return this.delegate.getIpresolved();
    }

    public IURIMap.IpfamilyValue getIpfamily() {
        return this.delegate.getIpfamily();
    }

    public IURIMap.HosttypeValue getHosttype() {
        return this.delegate.getHosttype();
    }

    public Long getPort() {
        return this.delegate.getPort();
    }

    public IURIMap.AuthenticateValue getAuthenticate() {
        return this.delegate.getAuthenticate();
    }

    public Long getSocketclose() {
        return this.delegate.getSocketclose();
    }

    public Long getSockpoolsize() {
        return this.delegate.getSockpoolsize();
    }

    public Long getSockplszpeak() {
        return this.delegate.getSockplszpeak();
    }

    public Long getSockreclaimd() {
        return this.delegate.getSockreclaimd();
    }

    public Long getSocktimedout() {
        return this.delegate.getSocktimedout();
    }

    public String getApplicationName() {
        return this.delegate.getApplicationName();
    }

    public String getPlatformName() {
        return this.delegate.getPlatformName();
    }

    public String getOperationName() {
        return this.delegate.getOperationName();
    }

    public Long getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    public Long getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    public Long getMicroVersion() {
        return this.delegate.getMicroVersion();
    }

    public IURIMap.AvailabilityValue getAvailability() {
        return this.delegate.getAvailability();
    }

    public void setStatus(IURIMap.StatusValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("ENABLESTATUS", null);
        } else {
            URIMapType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)URIMapType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("ENABLESTATUS", connectionSpecificExternalValue);
        }
    }

    public void setLocation(String _location) {
        if (_location.equals(this.delegate.getLocation())) {
            this.record.set("LOCATION", null);
        } else {
            URIMapType.LOCATION.validate((Object)_location);
            String connectionSpecificExternalValue = ((CICSAttribute)URIMapType.LOCATION).set(_location, this.record.getNormalizers());
            this.record.set("LOCATION", connectionSpecificExternalValue);
        }
    }

    public void setRedirecttype(IURIMap.RedirecttypeValue _redirecttype) {
        if (_redirecttype.equals((Object)this.delegate.getRedirecttype())) {
            this.record.set("REDIRECTTYPE", null);
        } else {
            URIMapType.REDIRECTTYPE.validate((Object)_redirecttype);
            String connectionSpecificExternalValue = ((CICSAttribute)URIMapType.REDIRECTTYPE).set(_redirecttype, this.record.getNormalizers());
            this.record.set("REDIRECTTYPE", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == URIMapType.NAME) {
            return (V)this.getName();
        }
        if (attribute == URIMapType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == URIMapType.USAGE) {
            return (V)this.getUsage();
        }
        if (attribute == URIMapType.SCHEME) {
            return (V)this.getScheme();
        }
        if (attribute == URIMapType.HOST) {
            return (V)this.getHost();
        }
        if (attribute == URIMapType.PATH) {
            return (V)this.getPath();
        }
        if (attribute == URIMapType.MEDIATYPE) {
            return (V)this.getMediatype();
        }
        if (attribute == URIMapType.CHARACTERSET) {
            return (V)this.getCharacterset();
        }
        if (attribute == URIMapType.HOSTCODEPAGE) {
            return (V)this.getHostcodepage();
        }
        if (attribute == URIMapType.TEMPLATENAME) {
            return (V)this.getTemplatename();
        }
        if (attribute == URIMapType.HFSFILE) {
            return (V)this.getHfsfile();
        }
        if (attribute == URIMapType.TCPIP_SERVICE) {
            return (V)this.getTCPIPService();
        }
        if (attribute == URIMapType.ANALYZERSTAT) {
            return (V)this.getAnalyzerstat();
        }
        if (attribute == URIMapType.CONVERTER) {
            return (V)this.getConverter();
        }
        if (attribute == URIMapType.TRANSACTION) {
            return (V)this.getTransaction();
        }
        if (attribute == URIMapType.PROGRAM) {
            return (V)this.getProgram();
        }
        if (attribute == URIMapType.PIPELINE) {
            return (V)this.getPipeline();
        }
        if (attribute == URIMapType.WEB_SERVICE) {
            return (V)this.getWebService();
        }
        if (attribute == URIMapType.USERID) {
            return (V)this.getUserid();
        }
        if (attribute == URIMapType.CERTIFICATE) {
            return (V)this.getCertificate();
        }
        if (attribute == URIMapType.CIPHERS) {
            return (V)this.getCiphers();
        }
        if (attribute == URIMapType.LOCATION) {
            return (V)this.getLocation();
        }
        if (attribute == URIMapType.REFERENCE_COUNT) {
            return (V)this.getReferenceCount();
        }
        if (attribute == URIMapType.MATCHDISABLD) {
            return (V)this.getMatchdisabld();
        }
        if (attribute == URIMapType.MATCHREDIREC) {
            return (V)this.getMatchredirec();
        }
        if (attribute == URIMapType.NUMCIPHERS) {
            return (V)this.getNumciphers();
        }
        if (attribute == URIMapType.REDIRECTTYPE) {
            return (V)this.getRedirecttype();
        }
        if (attribute == URIMapType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == URIMapType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == URIMapType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == URIMapType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == URIMapType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == URIMapType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == URIMapType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == URIMapType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == URIMapType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == URIMapType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        if (attribute == URIMapType.ATOMSERVICE) {
            return (V)this.getAtomservice();
        }
        if (attribute == URIMapType.IPRESOLVED) {
            return (V)this.getIpresolved();
        }
        if (attribute == URIMapType.IPFAMILY) {
            return (V)this.getIpfamily();
        }
        if (attribute == URIMapType.HOSTTYPE) {
            return (V)this.getHosttype();
        }
        if (attribute == URIMapType.PORT) {
            return (V)this.getPort();
        }
        if (attribute == URIMapType.AUTHENTICATE) {
            return (V)this.getAuthenticate();
        }
        if (attribute == URIMapType.SOCKETCLOSE) {
            return (V)this.getSocketclose();
        }
        if (attribute == URIMapType.SOCKPOOLSIZE) {
            return (V)this.getSockpoolsize();
        }
        if (attribute == URIMapType.SOCKPLSZPEAK) {
            return (V)this.getSockplszpeak();
        }
        if (attribute == URIMapType.SOCKRECLAIMD) {
            return (V)this.getSockreclaimd();
        }
        if (attribute == URIMapType.SOCKTIMEDOUT) {
            return (V)this.getSocktimedout();
        }
        if (attribute == URIMapType.APPLICATION_NAME) {
            return (V)this.getApplicationName();
        }
        if (attribute == URIMapType.PLATFORM_NAME) {
            return (V)this.getPlatformName();
        }
        if (attribute == URIMapType.OPERATION_NAME) {
            return (V)this.getOperationName();
        }
        if (attribute == URIMapType.MAJOR_VERSION) {
            return (V)this.getMajorVersion();
        }
        if (attribute == URIMapType.MINOR_VERSION) {
            return (V)this.getMinorVersion();
        }
        if (attribute == URIMapType.MICRO_VERSION) {
            return (V)this.getMicroVersion();
        }
        if (attribute == URIMapType.AVAILABILITY) {
            return (V)this.getAvailability();
        }
        return super.getAttributeValue(attribute);
    }

    public URIMapType getObjectType() {
        return URIMapType.getInstance();
    }

    @Override
    public URIMapReference getCICSObjectReference() {
        return new URIMapReference(this.getCICSContainer(), this.getName());
    }
}

