/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.TransactionGroupReference;
import com.ibm.cics.core.model.TransactionGroupType;
import com.ibm.cics.core.model.internal.CPSMDefinition;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ITransactionGroup;
import com.ibm.cics.model.ITransactionGroupEntry;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class TransactionGroup
extends CPSMDefinition
implements ITransactionGroup {
    private String _name;
    private ITransactionGroup.AffinityRelationValue _affinity;
    private ITransactionGroup.AffinityLifetimeValue _afflife;
    private ITransactionGroup.MatchKeyValue _match;
    private ITransactionGroup.StatusValue _state;
    private String _desc;
    private String _eventname;
    private Long _abendcrit;
    private Long _abendthresh;
    private ITransactionGroup.CreateAffinityValue _affauto;
    private ITransactionGroup.AlgorithmTypeValue _algtype;

    public TransactionGroup(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("NAME");
        this._name = (String)((CICSAttribute)TransactionGroupType.NAME).get(stringValue, normalizers);
        stringValue = record.get("AFFINITY");
        this._affinity = (ITransactionGroup.AffinityRelationValue)((CICSAttribute)TransactionGroupType.AFFINITY_RELATION).get(stringValue, normalizers);
        stringValue = record.get("AFFLIFE");
        this._afflife = (ITransactionGroup.AffinityLifetimeValue)((CICSAttribute)TransactionGroupType.AFFINITY_LIFETIME).get(stringValue, normalizers);
        stringValue = record.get("MATCH");
        this._match = (ITransactionGroup.MatchKeyValue)((CICSAttribute)TransactionGroupType.MATCH_KEY).get(stringValue, normalizers);
        stringValue = record.get("STATE");
        this._state = (ITransactionGroup.StatusValue)((CICSAttribute)TransactionGroupType.STATUS).get(stringValue, normalizers);
        stringValue = record.get("DESC");
        this._desc = (String)((CICSAttribute)TransactionGroupType.DESCRIPTION).get(stringValue, normalizers);
        stringValue = record.get("EVENTNAME");
        this._eventname = (String)((CICSAttribute)TransactionGroupType.RTA_EVENT).get(stringValue, normalizers);
        stringValue = record.get("ABENDCRIT");
        this._abendcrit = (Long)((CICSAttribute)TransactionGroupType.ABEND_PROBABILITY).get(stringValue, normalizers);
        stringValue = record.get("ABENDTHRESH");
        this._abendthresh = (Long)((CICSAttribute)TransactionGroupType.ABEND_LOAD_LEVEL).get(stringValue, normalizers);
        stringValue = record.get("AFFAUTO");
        this._affauto = (ITransactionGroup.CreateAffinityValue)((CICSAttribute)TransactionGroupType.CREATE_AFFINITY).get(stringValue, normalizers);
        stringValue = record.get("ALGTYPE");
        this._algtype = (ITransactionGroup.AlgorithmTypeValue)((CICSAttribute)TransactionGroupType.ALGORITHM_TYPE).get(stringValue, normalizers);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public ITransactionGroup.AffinityRelationValue getAffinityRelation() {
        return this._affinity;
    }

    public ITransactionGroup.AffinityLifetimeValue getAffinityLifetime() {
        return this._afflife;
    }

    public ITransactionGroup.MatchKeyValue getMatchKey() {
        return this._match;
    }

    public ITransactionGroup.StatusValue getStatus() {
        return this._state;
    }

    public String getDescription() {
        return this._desc;
    }

    public String getRtaEvent() {
        return this._eventname;
    }

    public Long getAbendProbability() {
        return this._abendcrit;
    }

    public Long getAbendLoadLevel() {
        return this._abendthresh;
    }

    public ITransactionGroup.CreateAffinityValue getCreateAffinity() {
        return this._affauto;
    }

    public ITransactionGroup.AlgorithmTypeValue getAlgorithmType() {
        return this._algtype;
    }

    public TransactionGroupType getObjectType() {
        return TransactionGroupType.getInstance();
    }

    @Override
    public TransactionGroupReference getCICSObjectReference() {
        return new TransactionGroupReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == TransactionGroupType.NAME) {
            return (V)this.getName();
        }
        if (attribute == TransactionGroupType.AFFINITY_RELATION) {
            return (V)this.getAffinityRelation();
        }
        if (attribute == TransactionGroupType.AFFINITY_LIFETIME) {
            return (V)this.getAffinityLifetime();
        }
        if (attribute == TransactionGroupType.MATCH_KEY) {
            return (V)this.getMatchKey();
        }
        if (attribute == TransactionGroupType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == TransactionGroupType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == TransactionGroupType.RTA_EVENT) {
            return (V)this.getRtaEvent();
        }
        if (attribute == TransactionGroupType.ABEND_PROBABILITY) {
            return (V)this.getAbendProbability();
        }
        if (attribute == TransactionGroupType.ABEND_LOAD_LEVEL) {
            return (V)this.getAbendLoadLevel();
        }
        if (attribute == TransactionGroupType.CREATE_AFFINITY) {
            return (V)this.getCreateAffinity();
        }
        if (attribute == TransactionGroupType.ALGORITHM_TYPE) {
            return (V)this.getAlgorithmType();
        }
        return super.getAttributeValue(attribute);
    }

    public ICICSObjectSet<ITransactionGroupEntry> getTransactionsInGroup() {
        return TransactionGroupType.TRANSACTIONS_IN_GROUP.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }
}

