/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WorkloadAffinityReference;
import com.ibm.cics.core.model.WorkloadAffinityType;
import com.ibm.cics.core.model.internal.CPSMManager;
import com.ibm.cics.model.IWorkloadAffinity;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public abstract class WorkloadAffinityGen
extends CPSMManager
implements IWorkloadAffinity {
    private String _trangrp;
    private String _workload;
    private IWorkloadAffinity.AffinityValue _affinity;
    private IWorkloadAffinity.LifetimeValue _lifetime;
    private String _userid;
    private String _luname;
    private String _torname;
    private String _termid;
    private String _reservd2;
    private String _aor;
    private String _wrklowner;
    private String _cbtskey;
    private String _locuowid;
    private String _netuowid;
    private String _affkey;

    public WorkloadAffinityGen(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("TRANGRP");
        this._trangrp = (String)((CICSAttribute)WorkloadAffinityType.TRANSACTION_GROUP).get(stringValue, normalizers);
        stringValue = record.get("WORKLOAD");
        this._workload = (String)((CICSAttribute)WorkloadAffinityType.WORKLOAD).get(stringValue, normalizers);
        stringValue = record.get("AFFINITY");
        this._affinity = (IWorkloadAffinity.AffinityValue)((CICSAttribute)WorkloadAffinityType.AFFINITY).get(stringValue, normalizers);
        stringValue = record.get("LIFETIME");
        this._lifetime = (IWorkloadAffinity.LifetimeValue)((CICSAttribute)WorkloadAffinityType.LIFETIME).get(stringValue, normalizers);
        stringValue = record.get("USERID");
        this._userid = (String)((CICSAttribute)WorkloadAffinityType.USER_ID).get(stringValue, normalizers);
        stringValue = record.get("LUNAME");
        this._luname = (String)((CICSAttribute)WorkloadAffinityType.LU_NAME).get(stringValue, normalizers);
        stringValue = record.get("TORNAME");
        this._torname = (String)((CICSAttribute)WorkloadAffinityType.ROUTING_REGION).get(stringValue, normalizers);
        stringValue = record.get("TERMID");
        this._termid = (String)((CICSAttribute)WorkloadAffinityType.TERMINAL_ID).get(stringValue, normalizers);
        stringValue = record.get("RESERVD2");
        this._reservd2 = (String)((CICSAttribute)WorkloadAffinityType.CBTS_ACTIVITY_ID).get(stringValue, normalizers);
        stringValue = record.get("AOR");
        this._aor = (String)((CICSAttribute)WorkloadAffinityType.TARGET_REGION).get(stringValue, normalizers);
        stringValue = record.get("WRKLOWNER");
        this._wrklowner = (String)((CICSAttribute)WorkloadAffinityType.WORKLOAD_OWNER).get(stringValue, normalizers);
        stringValue = record.get("CBTSKEY");
        this._cbtskey = (String)((CICSAttribute)WorkloadAffinityType.BTS_ACTIVITY_ID).get(stringValue, normalizers);
        stringValue = record.get("LOCUOWID");
        this._locuowid = (String)((CICSAttribute)WorkloadAffinityType.LOCAL_UOWID).get(stringValue, normalizers);
        stringValue = record.get("NETUOWID");
        this._netuowid = (String)((CICSAttribute)WorkloadAffinityType.NETWORK_UOWID).get(stringValue, normalizers);
        stringValue = record.get("AFFKEY");
        this._affkey = (String)((CICSAttribute)WorkloadAffinityType.AFFINITY_KEY).get(stringValue, normalizers);
    }

    public String getTransactionGroup() {
        return this._trangrp;
    }

    public String getWorkload() {
        return this._workload;
    }

    public IWorkloadAffinity.AffinityValue getAffinity() {
        return this._affinity;
    }

    public IWorkloadAffinity.LifetimeValue getLifetime() {
        return this._lifetime;
    }

    public String getUserId() {
        return this._userid;
    }

    public String getLuName() {
        return this._luname;
    }

    public String getRoutingRegion() {
        return this._torname;
    }

    public String getTerminalId() {
        return this._termid;
    }

    public String getCbtsActivityID() {
        return this._reservd2;
    }

    public String getTargetRegion() {
        return this._aor;
    }

    public String getWorkloadOwner() {
        return this._wrklowner;
    }

    public String getBtsActivityID() {
        return this._cbtskey;
    }

    public String getLocalUOWID() {
        return this._locuowid;
    }

    public String getNetworkUOWID() {
        return this._netuowid;
    }

    public String getAffinityKey() {
        return this._affkey;
    }

    public WorkloadAffinityType getObjectType() {
        return WorkloadAffinityType.getInstance();
    }

    @Override
    public WorkloadAffinityReference getCICSObjectReference() {
        return new WorkloadAffinityReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WorkloadAffinityType.TRANSACTION_GROUP) {
            return (V)this.getTransactionGroup();
        }
        if (attribute == WorkloadAffinityType.WORKLOAD) {
            return (V)this.getWorkload();
        }
        if (attribute == WorkloadAffinityType.AFFINITY) {
            return (V)this.getAffinity();
        }
        if (attribute == WorkloadAffinityType.LIFETIME) {
            return (V)this.getLifetime();
        }
        if (attribute == WorkloadAffinityType.USER_ID) {
            return (V)this.getUserId();
        }
        if (attribute == WorkloadAffinityType.LU_NAME) {
            return (V)this.getLuName();
        }
        if (attribute == WorkloadAffinityType.ROUTING_REGION) {
            return (V)this.getRoutingRegion();
        }
        if (attribute == WorkloadAffinityType.TERMINAL_ID) {
            return (V)this.getTerminalId();
        }
        if (attribute == WorkloadAffinityType.CBTS_ACTIVITY_ID) {
            return (V)this.getCbtsActivityID();
        }
        if (attribute == WorkloadAffinityType.TARGET_REGION) {
            return (V)this.getTargetRegion();
        }
        if (attribute == WorkloadAffinityType.WORKLOAD_OWNER) {
            return (V)this.getWorkloadOwner();
        }
        if (attribute == WorkloadAffinityType.BTS_ACTIVITY_ID) {
            return (V)this.getBtsActivityID();
        }
        if (attribute == WorkloadAffinityType.LOCAL_UOWID) {
            return (V)this.getLocalUOWID();
        }
        if (attribute == WorkloadAffinityType.NETWORK_UOWID) {
            return (V)this.getNetworkUOWID();
        }
        if (attribute == WorkloadAffinityType.AFFINITY_KEY) {
            return (V)this.getAffinityKey();
        }
        return super.getAttributeValue(attribute);
    }
}

