/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.core.model.BundleType;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.ScopedContext;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.core.ui.views.ResourcesView;
import com.ibm.cics.explorer.tables.ui.IBaseContextProvider;
import com.ibm.cics.explorer.tables.ui.internal.BaseContextProvider;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IManagementPart;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowBundlesForManagementPartAction
implements IActionDelegate,
IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ShowBundlesForManagementPartAction.class.getPackage().getName());
    private IManagementPart part;
    private ScopedContext context;

    public void run(IAction action) {
        IWorkbenchPage workbenchPage;
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"run", (Object)this);
        if (this.part != null && this.context != null && (workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            IViewPart viewPart = null;
            try {
                boolean createNewView;
                IViewReference ref = workbenchPage.findViewReference("com.ibm.cics.sm.ui.views.bundlesLegacy", this.part.getId());
                if (ref == null) {
                    ref = workbenchPage.findViewReference("com.ibm.cics.sm.ui.views.bundlesLegacy:" + this.part.getId(), this.part.getId());
                }
                if (ref != null) {
                    viewPart = ref.getView(true);
                }
                boolean bl = createNewView = viewPart == null;
                if (createNewView) {
                    viewPart = workbenchPage.showView("com.ibm.cics.sm.ui.views.bundlesLegacy", this.part.getId(), 1);
                } else {
                    workbenchPage.activate((IWorkbenchPart)viewPart);
                }
                ResourcesView newView = (ResourcesView)viewPart;
                final FilteredContext filteredContext = new FilteredContext((IContext)this.context);
                filteredContext.setAttributeValue(BundleType.MGMTPART, (Object)this.part.getId());
                newView.getResourcesTable().setBaseContextProvider((IBaseContextProvider)new BaseContextProvider(){

                    public IContext getContext() {
                        return filteredContext;
                    }

                    public String getDescription() {
                        return ShowBundlesForManagementPartAction.this.part.getBundleID();
                    }
                });
                if (createNewView) {
                    newView.setViewName(NLS.bind((String)CloudMessages.ShowBundlesForManagementPartAction_viewTitle, (Object[])new Object[]{newView.getTitle(), this.part.getBundleID(), this.part.getBundleMajorVersion(), this.part.getBundleMinorVersion(), this.part.getBundleMicroVersion()}));
                    UIPlugin.getDefault().addTransientView((IViewPart)newView);
                }
            }
            catch (PartInitException e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"run", (Throwable)e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sSelection;
        if (selection != null && selection instanceof IStructuredSelection && (sSelection = (IStructuredSelection)selection).size() == 1) {
            IPrimaryKey key;
            final Object object = sSelection.getFirstElement();
            if (object instanceof IManagementPart) {
                this.part = (IManagementPart)object;
            }
            if (object instanceof ICoreObject && (key = (IPrimaryKey)((ICoreObject)object).getAdapter(IPrimaryKey.class)) != null) {
                this.context = new ScopedContext(key.getContext(), null);
                final FilteredContext filteredContext = new FilteredContext((IContext)this.context);
                filteredContext.setAttributeValue(CICSRegionGroupDefinitionType.REGIONTYPE, (Object)this.part.getRegionType());
                Job contactCPSM = new Job(CloudMessages.pending){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ICPSM cpsm = ((ICoreObject)object).getCPSM();
                            ICICSRegionGroupDefinition[] regGroups = (ICICSRegionGroupDefinition[])cpsm.getDefinitions2((ICICSType)CICSRegionGroupDefinitionType.getInstance(), (IContext)filteredContext);
                            ShowBundlesForManagementPartAction.this.context = new ScopedContext(ShowBundlesForManagementPartAction.this.context.getContext(), regGroups[0].getGroup());
                        }
                        catch (CICSSystemManagerException e) {
                            Debug.error((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"selectionChanged", (Throwable)e);
                        }
                        Debug.event((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"selectionChanged", (Object)Status.OK_STATUS);
                        return Status.OK_STATUS;
                    }
                };
                contactCPSM.schedule();
            }
        }
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        this.selectionChanged(null, selection);
        this.run(null);
        return null;
    }

    public boolean isHandled() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }
}

