/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.CICSplexType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.IParent;
import com.ibm.cics.core.model.RegionType;
import com.ibm.cics.core.model.RegionsModel;
import com.ibm.cics.core.model.ResourcesModel;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IRegion;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.context.ICMASContext;

public class ModelUtilities {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static IRegion findRegion(ICICSplex cicsPlex, String regionName) {
        RegionsModel regions = (RegionsModel)ModelUtilities.getRegions((IParent)cicsPlex);
        IRegion region = (IRegion)regions.find(regionName);
        return region;
    }

    public static ResourcesModel getRegions(IParent plex) {
        ResourcesModel regions = plex.getChildrenAsModel(RegionType.getInstance());
        return regions;
    }

    public static String findApplID(final IManagedRegion managedRegion) {
        ICoreObject coreObject = (ICoreObject)managedRegion;
        IPrimaryKey key = (IPrimaryKey)coreObject.getAdapter(IPrimaryKey.class);
        ICPSM cpsm = coreObject.getCPSM();
        ICMASContext context = new ICMASContext(){

            public String getContext() {
                return managedRegion.getCMASName();
            }
        };
        try {
            ICICSplex cicsPlex = (ICICSplex)cpsm.get(CICSplexType.getInstance(), CICSplexType.getPrimaryKey((IContext)context, key.getContext(), managedRegion.getCMASName()));
            IRegion region = ModelUtilities.findRegion(cicsPlex, managedRegion.getName());
            if (region != null) {
                return region.getApplID();
            }
            return null;
        }
        catch (CICSSystemManagerException cICSSystemManagerException) {
            return null;
        }
    }
}

